/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.jai.util.SunTileCache;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.JAI;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.util.MapModel;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.LockingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusPage
extends ServerAdminPage {
    private final Map<String, String> values = new HashMap<String, String>();
    private static final String KEY_LOCKS = "locks";
    private static final String KEY_CONNECTIONS = "connections";
    private static final String KEY_MEMORY = "memory";
    private static final String KEY_JVM_VERSION = "jvm_version";
    private static final String KEY_JAI_AVAILABLE = "jai_available";
    private static final String KEY_JAI_IMAGEIO_AVAILABLE = "jai_imageio_available";
    private static final String KEY_JAI_MAX_MEM = "jai_max_mem";
    private static final String KEY_JAI_MEM_USAGE = "jai_mem_usage";
    private static final String KEY_JAI_MEM_THRESHOLD = "jai_mem_threshold";
    private static final String KEY_JAI_TILE_THREADS = "jai_tile_threads";
    private static final String KEY_JAI_TILE_THREAD_PRIORITY = "jai_tile_thread_priority";

    public StatusPage() {
        this.updateModel();
        this.add((Component)new Label(KEY_LOCKS, (IModel)new MapModel(this.values, KEY_LOCKS)));
        this.add((Component)new Label(KEY_CONNECTIONS, (IModel)new MapModel(this.values, KEY_CONNECTIONS)));
        this.add((Component)new Label(KEY_MEMORY, (IModel)new MapModel(this.values, KEY_MEMORY)));
        this.add((Component)new Label("jvm.version", (IModel)new MapModel(this.values, KEY_JVM_VERSION)));
        this.add((Component)new Label("jai.available", (IModel)new MapModel(this.values, KEY_JAI_AVAILABLE)));
        this.add((Component)new Label("jai.imageio.available", (IModel)new MapModel(this.values, KEY_JAI_IMAGEIO_AVAILABLE)));
        this.add((Component)new Label("jai.memory.available", (IModel)new MapModel(this.values, KEY_JAI_MAX_MEM)));
        this.add((Component)new Label("jai.memory.used", (IModel)new MapModel(this.values, KEY_JAI_MEM_USAGE)));
        this.add((Component)new Label("jai.memory.threshold", (IModel)new MapModel(this.values, KEY_JAI_MEM_THRESHOLD)));
        this.add((Component)new Label("jai.tile.threads", (IModel)new MapModel(this.values, KEY_JAI_TILE_THREADS)));
        this.add((Component)new Label("jai.tile.priority", (IModel)new MapModel(this.values, KEY_JAI_TILE_THREAD_PRIORITY)));
        this.add((Component)new Link("free.locks"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                StatusPage.this.updateModel();
            }
        });
        this.add((Component)new Link("free.memory"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                System.gc();
                System.runFinalization();
                StatusPage.this.updateModel();
            }
        });
        this.add((Component)new Link("free.memory.jai"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                SunTileCache jaiCache = StatusPage.this.getGeoServer().getGlobal().getJAI().getTileCache();
                long capacityBefore = jaiCache.getMemoryCapacity();
                jaiCache.flush();
                jaiCache.setMemoryCapacity(0L);
                System.gc();
                System.runFinalization();
                jaiCache.setMemoryCapacity(capacityBefore);
                StatusPage.this.updateModel();
            }
        });
        this.add((Component)new AjaxLink("clear.resourceCache"){

            public void onClick(AjaxRequestTarget target) {
                Catalog cat = StatusPage.this.getCatalog();
                try {
                    cat.getResourcePool().dispose();
                    this.info(this.getLocalizer().getString("resourceCacheClearedSuccessfully", (Component)this));
                }
                catch (Exception e) {
                    this.error(e);
                }
                target.addComponent((Component)StatusPage.this.feedbackPanel);
            }
        });
        this.add((Component)new Label("reload.date.geoserver", "Jul 14, 3:07 PM"));
        this.add((Component)new Label("reload.date.configuration", "Jul 14, 3:07 PM"));
        this.add((Component)new Label("reload.date.xml", "Mar 14, 2:15 PM"));
    }

    private void updateModel() {
        this.values.put(KEY_LOCKS, Long.toString(this.getLockCount()));
        this.values.put(KEY_CONNECTIONS, Long.toString(this.getConnectionCount()));
        this.values.put(KEY_MEMORY, this.formatUsedMemory());
        this.values.put(KEY_JVM_VERSION, System.getProperty("java.vendor") + ": " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + ")");
        this.values.put(KEY_JAI_AVAILABLE, Boolean.toString(this.isNativeJAIAvailable()));
        this.values.put(KEY_JAI_IMAGEIO_AVAILABLE, Boolean.toString(PackageUtil.isCodecLibAvailable()));
        JAIInfo jaiInfo = this.getGeoServer().getGlobal().getJAI();
        JAI jai = jaiInfo.getJAI();
        SunTileCache jaiCache = jaiInfo.getTileCache();
        this.values.put(KEY_JAI_MAX_MEM, this.formatMemory(jaiCache.getMemoryCapacity()));
        this.values.put(KEY_JAI_MEM_USAGE, this.formatMemory(jaiCache.getCacheMemoryUsed()));
        this.values.put(KEY_JAI_MEM_THRESHOLD, Float.toString(100.0f * jaiCache.getMemoryThreshold()));
        this.values.put(KEY_JAI_TILE_THREADS, Integer.toString(jai.getTileScheduler().getParallelism()));
        this.values.put(KEY_JAI_TILE_THREAD_PRIORITY, Integer.toString(jai.getTileScheduler().getPriority()));
    }

    boolean isNativeJAIAvailable() {
        try {
            Class<?> image = Class.forName("com.sun.medialib.mlib.Image");
            return (Boolean)image.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private String formatUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        long usedBytes = runtime.totalMemory() - runtime.freeMemory();
        String formattedUsedMemory = this.formatMemory(usedBytes);
        return formattedUsedMemory;
    }

    private String formatMemory(long bytes) {
        long KB = 1024L;
        long MB = 0x100000L;
        long GB = 0x40000000L;
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(2);
        String formattedUsedMemory = bytes > 0x40000000L ? formatter.format(bytes / 0x40000000L) + " GB" : (bytes > 0x100000L ? formatter.format(bytes / 0x100000L) + " MB" : formatter.format(bytes / 1024L) + " KB");
        return formattedUsedMemory;
    }

    private synchronized int getLockCount() {
        int count = 0;
        for (DataStoreInfo meta : this.getDataStores()) {
            if (!meta.isEnabled()) continue;
            try {
                LockingManager lockingManager;
                DataAccess store = meta.getDataStore(null);
                if (store instanceof DataStore && (lockingManager = ((DataStore)store).getLockingManager()) == null) continue;
            }
            catch (IllegalStateException notAvailable) {
            }
            catch (Throwable huh) {}
        }
        return count;
    }

    private synchronized int getConnectionCount() {
        int count = 0;
        for (DataStoreInfo meta : this.getDataStores()) {
            if (!meta.isEnabled()) continue;
            try {
                meta.getDataStore(null);
            }
            catch (Throwable notAvailable) {
                continue;
            }
            ++count;
        }
        return count;
    }

    private List<DataStoreInfo> getDataStores() {
        return this.getGeoServer().getCatalog().getDataStores();
    }
}

