/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.WebResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.web.Category;
import org.geoserver.web.DeveloperToolbar;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.HeaderContribution;
import org.geoserver.web.MenuPageInfo;
import org.geoserver.web.acegi.GeoServerSession;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerBasePage
extends WebPage
implements IAjaxIndicatorAware {
    protected static final String HEADER_PANEL = "headerPanel";
    protected static final Logger LOGGER = Logging.getLogger(GeoServerBasePage.class);
    protected FeedbackPanel feedbackPanel;

    public GeoServerBasePage() {
        ResourceReference faviconReference = null;
        List<HeaderContribution> cssContribs = this.getGeoServerApplication().getBeansOfType(HeaderContribution.class);
        for (HeaderContribution csscontrib : cssContribs) {
            try {
                if (!csscontrib.appliesTo(this)) continue;
                ResourceReference ref = csscontrib.getCSS();
                if (ref != null) {
                    this.add((IBehavior)HeaderContributor.forCss((ResourceReference)ref));
                }
                if ((ref = csscontrib.getJavaScript()) != null) {
                    this.add((IBehavior)HeaderContributor.forJavaScript((ResourceReference)ref));
                }
                if ((ref = csscontrib.getFavicon()) == null) continue;
                faviconReference = ref;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Problem adding header contribution", t);
            }
        }
        if (faviconReference == null) {
            faviconReference = new ResourceReference(GeoServerBasePage.class, "favicon.ico");
        }
        String faviconUrl = ((Object)RequestCycle.get().urlFor(faviconReference)).toString();
        this.add((Component)new ExternalLink("faviconLink", faviconUrl, null));
        this.add((Component)new Label("pageTitle", this.getPageTitle()));
        WebMarkupContainer loginForm = new WebMarkupContainer("loginform");
        this.add((Component)loginForm);
        Authentication user = GeoServerSession.get().getAuthentication();
        boolean anonymous = user == null;
        loginForm.setVisible(anonymous);
        WebMarkupContainer logoutForm = new WebMarkupContainer("logoutform");
        logoutForm.setVisible(user != null);
        this.add((Component)logoutForm);
        logoutForm.add((Component)new Label("username", anonymous ? "Nobody" : user.getName()));
        this.add((Component)new BookmarkablePageLink("home", GeoServerHomePage.class).add((Component)new Label("label", (IModel)new StringResourceModel("home", (Component)null, null))));
        DeveloperToolbar devToolbar = new DeveloperToolbar("devButtons");
        this.add((Component)devToolbar);
        devToolbar.setVisible("development".equalsIgnoreCase(this.getApplication().getConfigurationType()));
        final Map<Category, List<MenuPageInfo>> links = this.splitByCategory(this.filterSecured(this.getGeoServerApplication().getBeansOfType(MenuPageInfo.class)));
        List<Object> standalone = links.containsKey(null) ? links.get(null) : new ArrayList();
        links.remove(null);
        ArrayList<Category> categories = new ArrayList<Category>(links.keySet());
        Collections.sort(categories);
        this.add((Component)new ListView("category", categories){

            public void populateItem(ListItem item) {
                Category category = (Category)item.getModelObject();
                item.add((Component)new Label("category.header", (IModel)new StringResourceModel(category.getNameKey(), (Component)null, null)));
                item.add((Component)new ListView("category.links", (List)links.get(category)){

                    public void populateItem(ListItem item) {
                        MenuPageInfo info = (MenuPageInfo)item.getModelObject();
                        BookmarkablePageLink link = new BookmarkablePageLink("link", info.getComponentClass());
                        link.add((IBehavior)new AttributeModifier("title", true, (IModel)new StringResourceModel(info.getDescriptionKey(), (Component)null, null)));
                        link.add((Component)new Label("link.label", (IModel)new StringResourceModel(info.getTitleKey(), (Component)null, null)));
                        Image image = info.getIcon() != null ? new Image("link.icon", new ResourceReference(info.getComponentClass(), info.getIcon())) : new Image("link.icon", new ResourceReference(GeoServerBasePage.class, "img/icons/silk/wrench.png"));
                        image.add((IBehavior)new AttributeModifier("alt", true, (IModel)new ParamResourceModel(info.getTitleKey(), null, new Object[0])));
                        link.add((Component)image);
                        item.add((Component)link);
                    }
                });
            }
        });
        this.add((Component)new ListView("standalone", standalone){

            public void populateItem(ListItem item) {
                MenuPageInfo info = (MenuPageInfo)item.getModelObject();
                BookmarkablePageLink link = new BookmarkablePageLink("link", info.getComponentClass());
                link.add((IBehavior)new AttributeModifier("title", true, (IModel)new StringResourceModel(info.getDescriptionKey(), (Component)null, null)));
                link.add((Component)new Label("link.label", (IModel)new StringResourceModel(info.getTitleKey(), (Component)null, null)));
                item.add((Component)link);
            }
        });
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.add((Component)this.feedbackPanel);
        this.feedbackPanel.setOutputMarkupId(true);
        this.add((Component)new Image("ajaxFeedbackImage", new ResourceReference(GeoServerBasePage.class, "img/ajax-loader.gif")));
        this.add((Component)new WebMarkupContainer(HEADER_PANEL));
    }

    String getPageTitle() {
        try {
            ParamResourceModel model = new ParamResourceModel("title", (Component)this, new Object[0]);
            return "GeoServer: " + model.getString();
        }
        catch (Exception e) {
            LOGGER.warning(((Object)((Object)this)).getClass().getSimpleName() + " does not have a title set");
            return "GeoServer";
        }
    }

    protected void setHeaderPanel(Component component) {
        if (!HEADER_PANEL.equals(component.getId())) {
            throw new IllegalArgumentException("The header panel component must have 'headerPanel' id");
        }
        this.remove(HEADER_PANEL);
        this.add(component);
    }

    protected GeoServerApplication getGeoServerApplication() {
        return (GeoServerApplication)this.getApplication();
    }

    public GeoServerSession getSession() {
        return (GeoServerSession)super.getSession();
    }

    protected GeoServer getGeoServer() {
        return this.getGeoServerApplication().getGeoServer();
    }

    protected Catalog getCatalog() {
        return this.getGeoServerApplication().getCatalog();
    }

    private Map<Category, List<MenuPageInfo>> splitByCategory(List<MenuPageInfo> pages) {
        Collections.sort(pages);
        HashMap<Category, List<MenuPageInfo>> map = new HashMap<Category, List<MenuPageInfo>>();
        for (MenuPageInfo page : pages) {
            Category cat = page.getCategory();
            if (!map.containsKey(cat)) {
                map.put(cat, new ArrayList());
            }
            map.get(cat).add(page);
        }
        return map;
    }

    private List<MenuPageInfo> filterSecured(List<MenuPageInfo> pageList) {
        Authentication user = this.getSession().getAuthentication();
        ArrayList<MenuPageInfo> result = new ArrayList<MenuPageInfo>();
        for (MenuPageInfo page : pageList) {
            Class pageClass = page.getComponentClass();
            if (GeoServerSecuredPage.class.isAssignableFrom(pageClass) && !page.getPageAuthorizer().isAccessAllowed(pageClass, user)) continue;
            result.add(page);
        }
        return result;
    }

    protected void configureResponse() {
        super.configureResponse();
        WebResponse response = this.getWebRequestCycle().getWebResponse();
        response.setHeader("Cache-Control", "no-cache, max-age=0, must-revalidate, no-store");
    }

    public String getAjaxIndicatorMarkupId() {
        return "ajaxFeedback";
    }

    public FeedbackPanel getFeedbackPanel() {
        return this.feedbackPanel;
    }
}

