/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.user;

import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.security.SelectionUserRemovalLink;
import org.geoserver.web.security.user.EditUserPage;
import org.geoserver.web.security.user.NewUserPage;
import org.geoserver.web.security.user.UserListProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPage
extends GeoServerSecuredPage {
    private GeoServerTablePanel<User> users;
    GeoServerDialog dialog;
    private SelectionUserRemovalLink removal;

    public UserPage() {
        UserListProvider provider = new UserListProvider();
        this.users = new GeoServerTablePanel<User>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<User> property) {
                if (property == UserListProvider.USERNAME) {
                    return UserPage.this.editUserLink(id, itemModel, property);
                }
                if (property == UserListProvider.ROLES) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == UserListProvider.ADMIN) {
                    return new Label(id, property.getModel(itemModel));
                }
                throw new RuntimeException("Uknown property " + property);
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                UserPage.this.removal.setEnabled(UserPage.this.users.getSelection().size() > 0);
                target.addComponent((Component)UserPage.this.removal);
            }
        };
        this.add((Component)this.users);
        this.users.setOutputMarkupId(true);
        this.dialog = new GeoServerDialog("dialog");
        this.add((Component)this.dialog);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add((Component)new BookmarkablePageLink("addNew", NewUserPage.class));
        this.removal = new SelectionUserRemovalLink("removeSelected", this.users, this.dialog);
        header.add((Component)this.removal);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    AjaxLink addUserLink() {
        return new AjaxLink("addUser", (IModel)new Model()){

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((Page)new NewUserPage());
            }
        };
    }

    Component editUserLink(String id, IModel itemModel, GeoServerDataProvider.Property<User> property) {
        return new SimpleAjaxLink(id, itemModel, property.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                this.setResponsePage((Page)new EditUserPage((UserDetails)this.getModelObject()));
            }
        };
    }
}

