/*
 * Decompiled with CFR 0.152.
 */
package simple.http.load;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import simple.http.load.Configuration;
import simple.http.serve.Locator;
import simple.util.Resolver;
import simple.util.xml.Node;
import simple.util.xml.Traverser;

final class PatternResolver
extends Traverser {
    private Configuration setup = new Configuration();
    private Properties table = new Properties();
    private Resolver list = new Resolver();
    private Map data = new HashMap();
    private Map load = new HashMap();

    public PatternResolver(Locator lookup) {
        this.init(lookup);
    }

    private void init(Locator lookup) {
        try {
            this.load(lookup);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load(Locator lookup) throws Exception {
        try {
            this.load(lookup, "Mapper.xml");
        }
        catch (IOException e) {
            this.load(lookup, "mapper.xml");
        }
    }

    private void load(Locator lookup, String name) throws Exception {
        this.parse(lookup.getFile(name), "utf-8");
    }

    public Configuration getConfiguration(String name) {
        return (Configuration)this.data.get(name);
    }

    public String getClass(String name) {
        return (String)this.load.get(name);
    }

    public String getName(String path) {
        return this.list.resolve(path);
    }

    protected void start() {
        this.setup.clear();
        this.table.clear();
        this.load.clear();
        this.data.clear();
        this.list.clear();
    }

    protected void process(Node node) {
        String name = node.getName();
        if (name.equals("match")) {
            this.match(node);
        }
        if (name.equals("service")) {
            this.setup.clear();
            this.table.clear();
        }
        if (name.equals("section")) {
            this.setup.putAll((Map<?, ?>)this.table);
            this.table.clear();
        }
    }

    protected void commit(Node node) {
        String name = node.getName();
        if (name.equals("service")) {
            this.service(node);
        }
        if (name.equals("property")) {
            this.property(node);
        }
        if (name.equals("section")) {
            this.section(node);
        }
    }

    private void section(Node node) {
        String name = node.getAttribute("id");
        if (name != null) {
            this.setup.put(name, this.table.clone());
            this.table.clear();
        }
    }

    private void service(Node node) {
        String name = node.getAttribute("name");
        String type = node.getAttribute("type");
        if (name != null) {
            this.setup.putAll((Map<?, ?>)this.table);
            this.data.put(name, this.setup.clone());
            this.load.put(name, type);
        }
    }

    private void match(Node node) {
        String name = node.getAttribute("name");
        String path = node.getAttribute("path");
        if (path != null) {
            this.list.insert(path, name);
        }
    }

    private void property(Node node) {
        String name = node.getAttribute("key");
        if (name != null) {
            this.table.put(name, node.getProperty());
        }
    }
}

