/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection_UniqueFunction
extends FunctionExpressionImpl
implements FunctionExpression {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.function");
    FeatureCollection<SimpleFeatureType, SimpleFeature> previousFeatureCollection = null;
    Object unique = null;

    public Collection_UniqueFunction() {
        super("Collection_Unique");
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    static CalcResult calculateUnique(FeatureCollection<SimpleFeatureType, SimpleFeature> collection, Expression expression) throws IllegalFilterException, IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(expression);
        collection.accepts(uniqueVisitor, null);
        return uniqueVisitor.getResult();
    }

    @Override
    public void setParameters(List args) {
        super.setParameters(args);
        Expression expr = (Expression)this.getExpression(0);
        expr.accept(new AbstractFilterVisitor(){

            public void visit(AttributeExpression expression) {
                String xpath = expression.getAttributePath();
                if (xpath.startsWith("featureMembers/*/")) {
                    xpath = xpath.substring(17);
                } else if (xpath.startsWith("featureMember/*/")) {
                    xpath = xpath.substring(16);
                }
                try {
                    expression.setAttributePath(xpath);
                }
                catch (IllegalFilterException illegalFilterException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        if (feature == null) {
            return new Integer(0);
        }
        FeatureCollection featureCollection = (FeatureCollection)feature;
        Expression expr = (Expression)this.getExpression(0);
        FeatureCollection featureCollection2 = featureCollection;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.unique = null;
                try {
                    CalcResult result = Collection_UniqueFunction.calculateUnique(featureCollection, expr);
                    if (result != null) {
                        this.unique = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.unique;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

