/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.TreeSet;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.util.Converters;
import org.opengis.feature.Attribute;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;

public class Types {
    public static boolean isValid(Attribute attribute) {
        try {
            Types.validate(attribute.getType(), attribute, attribute.getValue(), false);
            return true;
        }
        catch (IllegalAttributeException invalid) {
            return false;
        }
    }

    public static void validate(Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(attribute.getType(), attribute, attributeContent, false);
    }

    public static void validate(AttributeType type, Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(type, attribute, attributeContent, false);
    }

    protected static void validate(AttributeType type, Attribute attribute, Object attributeContent, boolean isSuper) throws IllegalAttributeException {
        if (type == null) {
            throw new IllegalAttributeException("null type");
        }
        if (attributeContent == null) {
            if (!attribute.isNillable()) {
                throw new IllegalAttributeException(type.getName() + " not nillable");
            }
            return;
        }
        if (type.isIdentified() && attribute.getIdentifier() == null) {
            throw new NullPointerException(type.getName() + " is identified, null id not accepted");
        }
        if (!isSuper) {
            Class<?> clazz = attributeContent.getClass();
            Class binding = type.getBinding();
            if (binding != null && binding != clazz && !binding.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + type.getName() + " as it is not assignable from " + binding);
            }
        }
        if (type.getRestrictions() != null) {
            for (Filter f : type.getRestrictions()) {
                if (f.evaluate((Object)attribute)) continue;
                throw new IllegalAttributeException("Attribute instance (" + attribute.getIdentifier() + ")" + "fails to pass filter: " + f);
            }
        }
        if (type.getSuper() != null) {
            Types.validate(type.getSuper(), attribute, attributeContent, true);
        }
    }

    public static void validate(AttributeDescriptor descriptor, Object value) throws IllegalAttributeException {
        if (descriptor == null) {
            throw new NullPointerException("Attribute descriptor required for validation");
        }
        if (value == null) {
            if (!descriptor.isNillable()) {
                throw new IllegalArgumentException(descriptor.getName() + " requires a non null value");
            }
        } else {
            Types.validate(descriptor.getType(), value, false);
        }
    }

    public static Object parse(AttributeDescriptor descriptor, Object value) throws IllegalArgumentException {
        if (value == null) {
            if (descriptor.isNillable()) {
                return descriptor.getDefaultValue();
            }
        } else {
            Object converted;
            Class target = descriptor.getType().getBinding();
            if (!target.isAssignableFrom(value.getClass()) && (converted = Converters.convert(value, target)) != null) {
                return converted;
            }
        }
        return value;
    }

    protected static void validate(AttributeType type, Object value, boolean isSuper) throws IllegalAttributeException {
        if (!isSuper) {
            Class<?> clazz = value.getClass();
            Class binding = type.getBinding();
            if (binding != null && !binding.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + type.getName() + " as it is not assignable from " + binding);
            }
        }
        if (type.getRestrictions() != null && type.getRestrictions().size() > 0) {
            for (Filter filter : type.getRestrictions()) {
                if (filter.evaluate(value)) continue;
                throw new IllegalAttributeException(type.getName() + " restriction " + filter + " not met by: " + value);
            }
        }
        if (type.getSuper() != null) {
            Types.validate(type.getSuper(), value, true);
        }
    }

    public static void assertNameAssignable(FeatureType expected, FeatureType actual) {
        String actualName;
        String expectedName = expected.getName().getLocalPart();
        if (!expectedName.equals(actualName = actual.getName().getLocalPart())) {
            throw new IllegalAttributeException("Expected '" + expectedName + "' but was supplied '" + actualName + "'.");
        }
        TreeSet<String> names = new TreeSet<String>();
        for (PropertyDescriptor descriptor : actual.getDescriptors()) {
            names.add(descriptor.getName().getLocalPart());
        }
        for (PropertyDescriptor descriptor : expected.getDescriptors()) {
            expectedName = descriptor.getName().getLocalPart();
            if (names.contains(expectedName)) {
                names.remove(expectedName);
                continue;
            }
            throw new IllegalAttributeException("Expected to find a match for '" + expectedName + "' but was not available remaining names: " + names);
        }
        if (!names.isEmpty()) {
            throw new IllegalAttributeException("Expected to find attributes '" + expectedName + "' but was not available remaining names: " + names);
        }
        for (PropertyDescriptor expectedDescriptor : expected.getDescriptors()) {
            expectedName = expectedDescriptor.getName().getLocalPart();
            PropertyDescriptor actualDescriptor = actual.getDescriptor(expectedName);
            Class expectedBinding = expectedDescriptor.getType().getBinding();
            Class actualBinding = actualDescriptor.getType().getBinding();
            if (actualBinding.isAssignableFrom(expectedBinding)) continue;
            throw new IllegalArgumentException("Expected " + expectedBinding.getSimpleName() + " for " + expectedName + " but was " + actualBinding.getSimpleName());
        }
    }

    public static void assertOrderAssignable(SimpleFeatureType expected, SimpleFeatureType actual) {
        String actualName;
        String expectedName = expected.getName().getLocalPart();
        if (!expectedName.equals(actualName = actual.getName().getLocalPart())) {
            throw new IllegalAttributeException("Expected '" + expectedName + "' but was supplied '" + actualName + "'.");
        }
        if (expected.getAttributeCount() != actual.getAttributeCount()) {
            throw new IllegalAttributeException("Expected " + expected.getAttributeCount() + " attributes, but was supplied " + actual.getAttributeCount());
        }
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            Class expectedBinding = expected.getDescriptor(i).getType().getBinding();
            Class actualBinding = actual.getDescriptor(i).getType().getBinding();
            if (actualBinding.isAssignableFrom(expectedBinding)) continue;
            String name = expected.getDescriptor(i).getLocalName();
            throw new IllegalArgumentException("Expected " + expectedBinding.getSimpleName() + " for " + name + " but was " + actualBinding.getSimpleName());
        }
    }
}

