/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.palette;

public final class EfficientInverseColorMapComputation {
    protected final int bits;
    protected final int truncationBits;
    protected final int blueQuantizationMask;
    protected final int greenQuantizationMask;
    protected final int redQuantizationMask;
    protected final byte[][] colorMap;
    protected final byte[] mapBuf;

    public EfficientInverseColorMapComputation(byte[][] rgbColorMap, int quantizationBits) {
        this.colorMap = rgbColorMap;
        this.bits = quantizationBits;
        this.truncationBits = 8 - this.bits;
        this.blueQuantizationMask = (1 << this.bits) - 1;
        this.greenQuantizationMask = this.blueQuantizationMask << this.bits;
        this.redQuantizationMask = this.greenQuantizationMask << this.bits;
        int maximumQuantizationValue = 1 << this.bits;
        int numberOfColors = this.colorMap[0].length;
        this.mapBuf = new byte[maximumQuantizationValue * maximumQuantizationValue * maximumQuantizationValue];
        int[] distBuf = new int[maximumQuantizationValue * maximumQuantizationValue * maximumQuantizationValue];
        int x = 1 << this.truncationBits;
        int xsqr = x * x;
        int txsqr = xsqr + xsqr;
        for (int i = 0; i < numberOfColors; ++i) {
            int red = this.colorMap[0][i] & 0xFF;
            int green = this.colorMap[1][i] & 0xFF;
            int blue = this.colorMap[2][i] & 0xFF;
            int x_ = x / 2;
            int rdist = red - x_;
            int gdist = green - x_;
            int bdist = blue - x_;
            rdist = rdist * rdist + gdist * gdist + bdist * bdist;
            int rinc = 2 * (xsqr - (red << this.truncationBits));
            int ginc = 2 * (xsqr - (green << this.truncationBits));
            int binc = 2 * (xsqr - (blue << this.truncationBits));
            int r = 0;
            int rxx = rinc;
            int rgbI = 0;
            while (r < maximumQuantizationValue) {
                gdist = rdist;
                int g = 0;
                int gxx = ginc;
                while (g < maximumQuantizationValue) {
                    bdist = gdist;
                    int b = 0;
                    int bxx = binc;
                    while (b < maximumQuantizationValue) {
                        if (i == 0 || distBuf[rgbI] > bdist) {
                            distBuf[rgbI] = bdist;
                            this.mapBuf[rgbI] = (byte)i;
                        }
                        bdist += bxx;
                        ++b;
                        ++rgbI;
                        bxx += txsqr;
                    }
                    gdist += gxx;
                    ++g;
                    gxx += txsqr;
                }
                rdist += rxx;
                ++r;
                rxx += txsqr;
            }
        }
    }

    public int getIndexNearest(int red, int green, int blue) {
        return this.mapBuf[(red << 2 * this.bits - this.truncationBits & this.redQuantizationMask) + (green << 1 * this.bits - this.truncationBits & this.greenQuantizationMask) + (blue >> this.truncationBits & this.blueQuantizationMask)] & 0xFF;
    }
}

