/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.responses.helpers.DescribeLayerTransformer;

public class DescribeLayerResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)DescribeLayerResponse.class.getPackage().getName());
    public static final String DESCLAYER_MIME_TYPE = "application/vnd.ogc.wms_xml";
    private DescribeLayerRequest request;
    private DescribeLayerTransformer transformer;
    private byte[] content;

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request request) throws ServiceException {
        this.request = (DescribeLayerRequest)request;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("executing request ").append(request).toString());
        }
        this.transformer = new DescribeLayerTransformer(this.request.getBaseUrl());
        this.transformer.setNamespaceDeclarationEnabled(false);
        Charset encoding = this.request.getWMS().getCharSet();
        this.transformer.setEncoding(encoding);
        if (request.getServiceConfig().isVerbose()) {
            this.transformer.setIndentation(2);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.transformer.transform((Object)this.request, out);
        }
        catch (TransformerException e) {
            throw new WmsException(e);
        }
        this.content = out.toByteArray();
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.content == null) {
            throw new IllegalStateException("execute() has not been called or does not succeed.");
        }
        out.write(this.content);
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return null;
    }

    public void abort(ServiceInfo gs) {
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        return DESCLAYER_MIME_TYPE;
    }
}

