/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geotools.styling.Style;
import org.geotools.util.Converters;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMS {
    public static final String JPEG_COMPRESSION = "jpegCompression";
    public static final int JPEG_COMPRESSION_DEFAULT = 25;
    public static final String PNG_COMPRESSION = "pngCompression";
    public static final int PNG_COMPRESSION_DEFAULT = 25;
    static final Logger LOGGER = Logging.getLogger(WMS.class);
    public static final String WEB_CONTAINER_KEY = "WMS";
    public static final String SVG_SIMPLE = "Simple";
    public static final String SVG_BATIK = "Batik";
    private final GeoServer geoserver;

    public WMS(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    private Catalog getCatalog() {
        return this.geoserver.getCatalog();
    }

    public WMSInfo getServiceInfo() {
        return (WMSInfo)this.geoserver.getService(WMSInfo.class);
    }

    public Style getStyleByName(String styleName) throws IOException {
        StyleInfo styleInfo = this.getCatalog().getStyleByName(styleName);
        return styleInfo == null ? null : styleInfo.getStyle();
    }

    public LayerInfo getLayerByName(String layerName) {
        return this.getCatalog().getLayerByName(layerName);
    }

    public LayerGroupInfo getLayerGroupByName(String layerGroupName) {
        return this.getCatalog().getLayerGroupByName(layerGroupName);
    }

    public boolean isEnabled() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return serviceInfo.isEnabled();
    }

    public String getVersion() {
        WMSInfo serviceInfo = this.getServiceInfo();
        List versions = serviceInfo.getVersions();
        String version = versions.size() > 0 ? ((Version)versions.get(0)).toString() : "1.1.1";
        return version;
    }

    public GeoServer getGeoServer() {
        return this.geoserver;
    }

    public WMSInfo.WMSInterpolation getInterpolation() {
        return this.getServiceInfo().getInterpolation();
    }

    public Boolean getPNGNativeAcceleration() {
        JAIInfo jaiInfo = this.getJaiInfo();
        return jaiInfo.isPngAcceleration();
    }

    public Boolean getJPEGNativeAcceleration() {
        JAIInfo jaiInfo = this.getJaiInfo();
        return jaiInfo.isJpegAcceleration();
    }

    private JAIInfo getJaiInfo() {
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        return global.getJAI();
    }

    public Charset getCharSet() {
        GeoServer geoServer2 = this.getGeoServer();
        GeoServerInfo global = geoServer2.getGlobal();
        String charset = global.getCharset();
        return Charset.forName(charset);
    }

    public String getProxyBaseUrl() {
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        String proxyBaseUrl = global.getProxyBaseUrl();
        return proxyBaseUrl;
    }

    public int getUpdateSequence() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        return global.getUpdateSequence();
    }

    public int getWatermarkTransparency() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getTransparency();
    }

    public int getWatermarkPosition() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        WatermarkInfo.Position position = watermark.getPosition();
        return position.getCode();
    }

    public boolean isGlobalWatermarking() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.isEnabled();
    }

    public String getGlobalWatermarkingURL() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getURL();
    }

    public FeatureTypeInfo getFeatureTypeInfo(Name name) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo resource = (FeatureTypeInfo)catalog.getResourceByName(name, FeatureTypeInfo.class);
        return resource;
    }

    public CoverageInfo getCoverageInfo(Name name) {
        Catalog catalog = this.getCatalog();
        CoverageInfo resource = (CoverageInfo)catalog.getResourceByName(name, CoverageInfo.class);
        return resource;
    }

    public List<LayerInfo> getLayers() {
        Catalog catalog = this.getCatalog();
        return catalog.getLayers();
    }

    public String getNamespaceByPrefix(String prefix) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceInfo = catalog.getNamespaceByPrefix(prefix);
        return namespaceInfo == null ? null : namespaceInfo.getURI();
    }

    public List<LayerGroupInfo> getLayerGroups() {
        Catalog catalog = this.getCatalog();
        List layerGroups = catalog.getLayerGroups();
        return layerGroups;
    }

    public boolean supportsSLD() {
        return true;
    }

    public boolean supportsUserLayer() {
        return true;
    }

    public boolean supportsUserStyle() {
        return true;
    }

    public boolean supportsRemoteWFS() {
        return true;
    }

    public void setSvgRenderer(String svgRendererHint) {
        WMSInfo serviceInfo = this.getServiceInfo();
        serviceInfo.getMetadata().put("svgRenderer", (Serializable)((Object)svgRendererHint));
    }

    public String getSvgRenderer() {
        WMSInfo serviceInfo = this.getServiceInfo();
        String svgRendererHint = (String)((Object)serviceInfo.getMetadata().get((Object)"svgRenderer"));
        return svgRendererHint;
    }

    public boolean isSvgAntiAlias() {
        WMSInfo serviceInfo = this.getServiceInfo();
        Boolean svgAntiAlias = (Boolean)Converters.convert((Object)serviceInfo.getMetadata().get((Object)"svgAntiAlias"), Boolean.class);
        return svgAntiAlias == null ? true : svgAntiAlias;
    }

    public int getPngCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), PNG_COMPRESSION, 25);
    }

    public int getJpegCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), JPEG_COMPRESSION, 25);
    }

    int getMetadataPercentage(MetadataMap metadata, String key, int defaultValue) {
        Integer parsedValue = (Integer)Converters.convert((Object)metadata.get((Object)key), Integer.class);
        if (parsedValue == null) {
            return defaultValue;
        }
        int value = parsedValue;
        if (value < 0 || value > 100) {
            LOGGER.warning("Invalid percertage value for '" + key + "', it should be between 0 and 100");
            return defaultValue;
        }
        return value;
    }

    public int getNumDecimals() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        return global.getNumDecimals();
    }

    public String getNameSpacePrefix(String nsUri) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo ns = catalog.getNamespaceByURI(nsUri);
        return ns == null ? null : ns.getPrefix();
    }

    public int getMaxBuffer() {
        return this.getServiceInfo().getMaxBuffer();
    }

    public int getMaxRequestMemory() {
        return this.getServiceInfo().getMaxRequestMemory();
    }

    public int getMaxRenderingTime() {
        return this.getServiceInfo().getMaxRenderingTime();
    }

    public int getMaxRenderingErrors() {
        return this.getServiceInfo().getMaxRenderingErrors();
    }
}

