/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.gdal;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import org.gdal.gdal.gdalJNI;

public class ColorTable {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected ColorTable(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ColorTable obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            gdalJNI.delete_ColorTable(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public IndexColorModel getIndexColorModel(int bits) {
        int size = this.GetCount();
        byte[] reds = new byte[size];
        byte[] greens = new byte[size];
        byte[] blues = new byte[size];
        byte[] alphas = new byte[size];
        int noAlphas = 0;
        int zeroAlphas = 0;
        int lastAlphaIndex = -1;
        Color entry = null;
        for (int i = 0; i < size; ++i) {
            entry = this.GetColorEntry(i);
            reds[i] = (byte)(entry.getRed() & 0xFF);
            greens[i] = (byte)(entry.getGreen() & 0xFF);
            blues[i] = (byte)(entry.getBlue() & 0xFF);
            byte alpha = (byte)(entry.getAlpha() & 0xFF);
            if (alpha == 255) {
                ++noAlphas;
            } else if (alpha == 0) {
                ++zeroAlphas;
                lastAlphaIndex = i;
            }
            alphas[i] = alpha;
        }
        if (noAlphas == size) {
            return new IndexColorModel(bits, size, reds, greens, blues);
        }
        if (noAlphas == size - 1 && zeroAlphas == 1) {
            return new IndexColorModel(bits, size, reds, greens, blues, lastAlphaIndex);
        }
        return new IndexColorModel(bits, size, reds, greens, blues, alphas);
    }

    public ColorTable(int arg0) {
        this(gdalJNI.new_ColorTable(arg0), true);
    }

    public ColorTable Clone() {
        long cPtr = gdalJNI.ColorTable_Clone(this.swigCPtr, this);
        return cPtr == 0L ? null : new ColorTable(cPtr, false);
    }

    public int GetPaletteInterpretation() {
        return gdalJNI.ColorTable_GetPaletteInterpretation(this.swigCPtr, this);
    }

    public int GetCount() {
        return gdalJNI.ColorTable_GetCount(this.swigCPtr, this);
    }

    public Color GetColorEntry(int arg0) {
        return gdalJNI.ColorTable_GetColorEntry(this.swigCPtr, this, arg0);
    }

    public int GetColorEntryAsRGB(int arg0, Color arg1) {
        return gdalJNI.ColorTable_GetColorEntryAsRGB(this.swigCPtr, this, arg0, arg1);
    }

    public void SetColorEntry(int arg0, Color arg1) {
        gdalJNI.ColorTable_SetColorEntry(this.swigCPtr, this, arg0, arg1);
    }
}

