/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import org.geoserver.config.GeoServer;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.GMLInfoImpl;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSInfoImpl;
import org.geotools.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFSXStreamLoader
extends XStreamServiceLoader<WFSInfo> {
    public WFSXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "wfs");
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        xp.getXStream().alias("wfs", WFSInfo.class, WFSInfoImpl.class);
    }

    protected WFSInfo createServiceFromScratch(GeoServer gs) {
        WFSInfoImpl wfs = new WFSInfoImpl();
        wfs.setId("wfs");
        GMLInfoImpl gml2 = new GMLInfoImpl();
        gml2.setSrsNameStyle(GMLInfo.SrsNameStyle.XML);
        wfs.getGML().put(WFSInfo.Version.V_10, gml2);
        GMLInfoImpl gml3 = new GMLInfoImpl();
        gml3.setSrsNameStyle(GMLInfo.SrsNameStyle.URN);
        wfs.getGML().put(WFSInfo.Version.V_11, new GMLInfoImpl());
        return wfs;
    }

    public Class<WFSInfo> getServiceClass() {
        return WFSInfo.class;
    }

    protected WFSInfo initialize(WFSInfo service) {
        if (service.getVersions() == null) {
            ((WFSInfoImpl)service).setVersions(new ArrayList());
        }
        if (service.getVersions().isEmpty()) {
            service.getVersions().add(new Version("1.0.0"));
            service.getVersions().add(new Version("1.1.0"));
        }
        return service;
    }
}

