/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentState;
import org.opengis.feature.type.Name;

public final class ContentEntry {
    Name typeName;
    Map<Transaction, ContentState> state;
    ContentDataStore dataStore;

    public ContentEntry(ContentDataStore dataStore, Name typeName) {
        this.typeName = typeName;
        this.dataStore = dataStore;
        this.state = new HashMap<Transaction, ContentState>();
        ContentState autoState = dataStore.createContentState(this);
        autoState.setTransaction(Transaction.AUTO_COMMIT);
        this.state.put(Transaction.AUTO_COMMIT, autoState);
    }

    public Name getName() {
        return this.typeName;
    }

    public String getTypeName() {
        return this.typeName.getLocalPart();
    }

    public ContentDataStore getDataStore() {
        return this.dataStore;
    }

    public ContentState getState(Transaction transaction) {
        if (this.state.containsKey(transaction)) {
            return this.state.get(transaction);
        }
        ContentState auto = this.state.get(Transaction.AUTO_COMMIT);
        ContentState copy = auto.copy();
        copy.setTransaction(transaction != null ? transaction : Transaction.AUTO_COMMIT);
        this.state.put(transaction, copy);
        return copy;
    }

    void notifiyFeatureEvent(ContentState source, FeatureEvent notification) {
        for (ContentState entry : this.state.values()) {
            if (entry == source) continue;
            for (FeatureListener listener : source.listeners) {
                try {
                    listener.changed(notification);
                }
                catch (Throwable t) {
                    this.dataStore.LOGGER.log(Level.WARNING, "Problem issuing feature event " + notification, t);
                }
            }
        }
    }

    public void dispose() {
        for (ContentState s : this.state.values()) {
            s.close();
        }
    }

    public String toString() {
        return this.getTypeName();
    }
}

