/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class PropertyFeatureSource
extends AbstractFeatureLocking {
    String typeName;
    SimpleFeatureType featureType;
    PropertyDataStore store;
    long cacheTimestamp = 0L;
    ReferencedEnvelope cacheBounds = null;
    int cacheCount = -1;

    PropertyFeatureSource(PropertyDataStore propertyDataStore, String typeName) throws IOException {
        this.store = propertyDataStore;
        this.typeName = typeName;
        this.featureType = this.store.getSchema(typeName);
        this.store.listenerManager.addFeatureListener(this, new FeatureListener(){

            public void changed(FeatureEvent featureEvent) {
                if (PropertyFeatureSource.this.cacheBounds != null) {
                    if (featureEvent.getEventType() == 1) {
                        PropertyFeatureSource.this.cacheBounds.expandToInclude(featureEvent.getBounds());
                    } else {
                        PropertyFeatureSource.this.cacheBounds = null;
                    }
                }
                PropertyFeatureSource.this.cacheCount = -1;
            }
        });
    }

    public DataStore getDataStore() {
        return this.store;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.store.listenerManager.addFeatureListener(this, listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.store.listenerManager.removeFeatureListener(this, listener);
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public int getCount(Query query) {
        if (Filter.INCLUDE == query.getFilter() && this.getTransaction() == Transaction.AUTO_COMMIT) {
            File file = new File(this.store.directory, this.typeName + ".properties");
            if (this.cacheCount != -1 && file.lastModified() == this.cacheTimestamp) {
                return this.cacheCount;
            }
            this.cacheCount = this.countFile(file);
            this.cacheTimestamp = file.lastModified();
            return this.cacheCount;
        }
        return -1;
    }

    private int countFile(File file) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            while (reader.readLine() != null) {
            }
            return reader.getLineNumber() - 1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public ReferencedEnvelope getBounds() {
        File file = new File(this.store.directory, this.typeName + ".properties");
        if (this.cacheBounds != null && file.lastModified() == this.cacheTimestamp) {
            return this.cacheBounds;
        }
        try {
            this.cacheBounds = this.getFeatures().getBounds();
            this.cacheTimestamp = file.lastModified();
            return this.cacheBounds;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

