/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchemaContent;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.Node;
import org.geotools.xml.ParserDelegate;
import org.geotools.xml.impl.DocumentHandler;
import org.geotools.xml.impl.ElementHandler;
import org.geotools.xml.impl.ElementImpl;
import org.geotools.xml.impl.Handler;
import org.geotools.xml.impl.NodeImpl;
import org.picocontainer.MutablePicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DelegatingHandler
implements DocumentHandler,
ElementHandler {
    ParserDelegate delegate;
    Handler parent;
    QName elementName;
    NodeImpl parseTree;

    DelegatingHandler(ParserDelegate delegate, QName elementName, Handler parent) {
        this.delegate = delegate;
        this.parent = parent;
        this.elementName = elementName;
        XSDElementDeclaration e = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        e.setTargetNamespace(elementName.getNamespaceURI());
        e.setName(elementName.getLocalPart());
        ElementImpl instance = new ElementImpl(e);
        instance.setName(elementName.getLocalPart());
        instance.setNamespace(elementName.getNamespaceURI());
        this.parseTree = new NodeImpl(instance);
    }

    public void setContext(MutablePicoContainer context) {
    }

    public MutablePicoContainer getContext() {
        return null;
    }

    public XSDElementDeclaration getElementDeclaration() {
        return ((ElementInstance)this.parseTree.getComponent()).getElementDeclaration();
    }

    public Handler getParentHandler() {
        return this.parent;
    }

    public Handler createChildHandler(QName name) {
        return new DelegatingHandler(this.delegate, name, this);
    }

    public void startChildHandler(Handler child) {
    }

    public void endChildHandler(Handler child) {
    }

    public InstanceComponent getComponent() {
        return null;
    }

    public Node getParseNode() {
        return this.parseTree;
    }

    public XSDSchemaContent getSchemaContent() {
        return null;
    }

    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    public void endDocument() throws SAXException {
        this.delegate.endDocument();
    }

    public void startElement(QName name, Attributes attributes) throws SAXException {
        if (!(this.parent instanceof DelegatingHandler)) {
            this.parent.startChildHandler(this);
        }
        this.delegate.startElement(name.getNamespaceURI(), name.getLocalPart(), this.qname(name), attributes);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.delegate.characters(ch, start, length);
    }

    public void endElement(QName name) throws SAXException {
        this.delegate.endElement(name.getNamespaceURI(), name.getLocalPart(), this.qname(name));
    }

    String qname(QName name) {
        return name.getNamespaceURI() != null ? name.getPrefix() + ":" + name.getLocalPart() : name.getLocalPart();
    }
}

