/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.collections.MultiHashMap;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.geotools.xml.Encoder;
import org.geotools.xml.PropertyExtractor;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.GetPropertiesExecutor;
import org.geotools.xml.impl.GetPropertyExecutor;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Element;

public class BindingPropertyExtractor
implements PropertyExtractor {
    Encoder encoder;
    MutablePicoContainer context;

    public BindingPropertyExtractor(Encoder encoder, MutablePicoContainer context) {
        this.encoder = encoder;
        this.context = context;
    }

    public boolean canHandle(Object object) {
        return true;
    }

    public void setContext(MutablePicoContainer context) {
        this.context = context;
    }

    public List properties(Object object, XSDElementDeclaration element) {
        ArrayList<Object[]> properties = new ArrayList<Object[]>();
        List children = this.encoder.getSchemaIndex().getChildElementParticles(element);
        for (XSDParticle particle : children) {
            XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
            if (child.isElementDeclarationReference()) {
                child = child.getResolvedElementDeclaration();
            }
            GetPropertyExecutor executor = new GetPropertyExecutor(object, (XSDNamedComponent)child);
            this.encoder.getBindingWalker().walk((XSDFeature)element, executor, this.context);
            if (executor.getChildObject() == null) continue;
            properties.add(new Object[]{particle, executor.getChildObject()});
        }
        GetPropertiesExecutor executor = new GetPropertiesExecutor(object, element);
        this.encoder.getBindingWalker().walk((XSDFeature)element, executor, this.context);
        if (!executor.getProperties().isEmpty()) {
            MultiHashMap map = new MultiHashMap();
            for (Object[] property : executor.getProperties()) {
                map.put(property[0], property[1]);
            }
            HashMap<QName, XSDParticle> particles = new HashMap<QName, XSDParticle>();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() instanceof XSDParticle) {
                    XSDParticle particle = (XSDParticle)entry.getKey();
                    particles.put(Schemas.getParticleName(particle), particle);
                    continue;
                }
                QName name = (QName)entry.getKey();
                Collection values = (Collection)entry.getValue();
                if (Encoder.COMMENT.equals(name)) {
                    Element comment = this.encoder.getDocument().createElement(Encoder.COMMENT.getLocalPart());
                    Iterator v = values.iterator();
                    while (v.hasNext()) {
                        comment.appendChild(this.encoder.getDocument().createTextNode(v.next().toString()));
                    }
                    XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration elementDecl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    elementDecl.setTargetNamespace(Encoder.COMMENT.getNamespaceURI());
                    elementDecl.setName(Encoder.COMMENT.getLocalPart());
                    elementDecl.setElement(comment);
                    particle.setContent((XSDParticleContent)elementDecl);
                    particles.put(name, particle);
                    continue;
                }
                XSDElementDeclaration elementDecl = this.encoder.getSchemaIndex().getElementDeclaration(name);
                if (elementDecl == null) {
                    elementDecl = this.encoder.getSchema().resolveElementDeclaration(name.getNamespaceURI(), name.getLocalPart());
                }
                XSDParticle reference = null;
                for (XSDParticle particle : Schemas.getChildElementParticles(element.getType(), true)) {
                    XSDElementDeclaration el = (XSDElementDeclaration)particle.getContent();
                    if (el.isElementDeclarationReference()) {
                        el = el.getResolvedElementDeclaration();
                    }
                    if (!Schemas.isBaseType(elementDecl, el)) continue;
                    reference = particle;
                    break;
                }
                XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
                XSDElementDeclaration wrapper = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                wrapper.setResolvedElementDeclaration(elementDecl);
                particle.setContent((XSDParticleContent)wrapper);
                if (reference != null) {
                    particle.setMaxOccurs(reference.getMaxOccurs());
                } else if (values.size() > 1) {
                    particle.setMaxOccurs(-1);
                } else {
                    particle.setMaxOccurs(1);
                }
                particles.put(name, particle);
            }
            for (Object[] property : executor.getProperties()) {
                Collection values = (Collection)map.get(property[0]);
                QName name = property[0] instanceof XSDParticle ? Schemas.getParticleName((XSDParticle)property[0]) : (QName)property[0];
                XSDParticle particle = (XSDParticle)particles.get(name);
                if (particle == null) continue;
                if (values.size() > 1) {
                    properties.add(new Object[]{particle, values});
                } else {
                    properties.add(new Object[]{particle, values.iterator().next()});
                }
                particles.remove(name);
            }
        }
        return properties;
    }
}

