/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.validation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private StreamWrapper os = new StreamWrapper();
    private int status = 200;
    PrintWriter pw = new PrintWriter((OutputStream)((Object)this.os));

    public ResponseWrapper(HttpServletResponse response, boolean dtdCheckEnabled) {
        super(response);
        this.os.setResponse(response);
        this.os.setCheckForDtdDefnEnabled(dtdCheckEnabled);
    }

    public String outputStreamToString() throws IOException {
        this.pw.flush();
        return this.os.outputStreamToString();
    }

    public PrintWriter getWriter() {
        return this.pw;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void setContentLength(int i) {
    }

    public void flushBuffer() throws IOException {
        this.pw.flush();
    }

    public void resetBuffer() {
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.status = sc;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isContentXHTML() throws IOException {
        this.pw.flush();
        this.os.checkForDocType();
        return this.os.isContentXHTML();
    }

    class StreamWrapper
    extends ServletOutputStream {
        private ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        private boolean checkForDtdDefnDone = false;
        private boolean checkForDtdDefnEnabled = false;
        private boolean contentXHTML = false;
        private HttpServletResponse response;
        private ServletOutputStream servletOutputStream;

        public void close() throws IOException {
            this.checkForDocType();
        }

        public void flush() throws IOException {
            if (this.servletOutputStream != null) {
                this.servletOutputStream.flush();
                return;
            }
            this.byteArrayOS.flush();
            this.checkForDocType();
        }

        public void write(byte[] b) throws IOException {
            if (this.servletOutputStream != null) {
                this.servletOutputStream.write(b);
                return;
            }
            this.byteArrayOS.write(b);
            this.checkForDocType();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.servletOutputStream != null) {
                this.servletOutputStream.write(b, off, len);
                return;
            }
            this.byteArrayOS.write(b, off, len);
            this.checkForDocType();
        }

        public synchronized void write(int b) throws IOException {
            if (this.servletOutputStream != null) {
                this.servletOutputStream.write(b);
                return;
            }
            this.byteArrayOS.write(b);
            this.checkForDocType();
        }

        public String outputStreamToString() throws IOException {
            if (this.servletOutputStream != null) {
                throw new IOException("servlet output stream in use this should not be called");
            }
            this.flush();
            return this.byteArrayOS.toString();
        }

        private void checkForDocType() throws IOException {
            if (!this.checkForDtdDefnEnabled) {
                return;
            }
            if (this.checkForDtdDefnDone) {
                return;
            }
            if (this.byteArrayOS.size() < 128) {
                return;
            }
            this.checkForDtdDefnDone = true;
            String contentSoFar = this.byteArrayOS.toString();
            if (contentSoFar.indexOf("<!DOCTYPE") != -1 && contentSoFar.indexOf("-//W3C//DTD XHTML") != -1) {
                this.contentXHTML = true;
            } else {
                this.contentXHTML = false;
                this.servletOutputStream = this.response.getOutputStream();
                this.servletOutputStream.write(this.byteArrayOS.toByteArray());
                this.byteArrayOS = new ByteArrayOutputStream();
            }
        }

        public void setCheckForDtdDefnEnabled(boolean checkForDtdDefnEnabled) {
            this.checkForDtdDefnEnabled = checkForDtdDefnEnabled;
        }

        public void setResponse(HttpServletResponse response) {
            this.response = response;
        }

        public boolean isContentXHTML() {
            return this.contentXHTML;
        }
    }
}

