/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.io.Writer;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.SQLDialect;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

class FilterToSqlHelper {
    protected static final String IO_ERROR = "io problem writing filter";
    FilterToSQL delegate;
    Writer out;
    boolean looseBBOXEnabled;

    public FilterToSqlHelper(FilterToSQL delegate) {
        this.delegate = delegate;
    }

    public static FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        return caps;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            if (filter instanceof DistanceBufferOperator) {
                this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
            } else {
                this.visitComparisonSpatialOperator(filter, property, geometry, swapped, extraData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
        return extraData;
    }

    void visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (filter instanceof DWithin && !swapped || filter instanceof Beyond && swapped) {
            this.out.write("ST_DWITHIN(");
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            this.out.write(Double.toString(filter.getDistance()));
            this.out.write(")");
        }
        if (filter instanceof DWithin && swapped || filter instanceof Beyond && !swapped) {
            this.out.write("ST_DISTANCE(");
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(") > ");
            this.out.write(Double.toString(filter.getDistance()));
        }
    }

    void visitComparisonSpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (!(filter instanceof Disjoint)) {
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(" && ");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            if (filter instanceof BBOX && this.looseBBOXEnabled) {
                return;
            }
            this.out.write(" AND ");
        }
        String closingParenthesis = ")";
        if (filter instanceof Equals) {
            this.out.write("equals");
        } else if (filter instanceof Disjoint) {
            this.out.write("NOT (intersects");
            closingParenthesis = closingParenthesis + ")";
        } else if (filter instanceof Intersects || filter instanceof BBOX) {
            this.out.write("intersects");
        } else if (filter instanceof Crosses) {
            this.out.write("crosses");
        } else if (filter instanceof Within) {
            if (swapped) {
                this.out.write("contains");
            } else {
                this.out.write("within");
            }
        } else if (filter instanceof Contains) {
            if (swapped) {
                this.out.write("within");
            } else {
                this.out.write("contains");
            }
        } else if (filter instanceof Overlaps) {
            this.out.write("overlaps");
        } else if (filter instanceof Touches) {
            this.out.write("touches");
        } else {
            throw new RuntimeException("Unsupported filter type " + filter.getClass());
        }
        this.out.write("(");
        property.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(", ");
        geometry.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(closingParenthesis);
    }
}

