/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PointPolygonAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class PointInsidePolygonValidation
extends PointPolygonAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        FeatureSource pointSource = (FeatureSource)layers.get(this.getPointTypeRef());
        FeatureSource polySource = (FeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
        Object[] polys = polySource.getFeatures().toArray();
        Object[] points = pointSource.getFeatures().toArray();
        if (!envelope.contains((Envelope)polySource.getBounds())) {
            results.error((SimpleFeature)polys[0], "Point Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains((Envelope)pointSource.getBounds())) {
            results.error((SimpleFeature)points[0], "Line Feature Source is not contained within the Envelope provided.");
            return false;
        }
        for (int i = 0; i < points.length; ++i) {
            SimpleFeature tmp = (SimpleFeature)points[i];
            Geometry gt = (Geometry)tmp.getDefaultGeometry();
            if (!(gt instanceof Polygon)) continue;
            Polygon ls = (Polygon)gt;
            boolean r = false;
            for (int j = 0; j < polys.length && !r; ++j) {
                Point pt;
                SimpleFeature tmp2 = (SimpleFeature)polys[j];
                Geometry gt2 = (Geometry)tmp2.getDefaultGeometry();
                if (!(gt2 instanceof Point) || (pt = (Point)gt2).within((Geometry)ls)) continue;
                r = true;
            }
            if (r) continue;
            results.error(tmp, "Polygon does not contained one of the specified points.");
            return false;
        }
        return true;
    }
}

