/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.util.HashSet;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineLineAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class LineIntersectsLineWithNodeValidation
extends LineLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        FeatureSource fsLine = (FeatureSource)layers.get(this.getLineTypeRef());
        FeatureCollection fcLine = fsLine.getFeatures();
        FeatureIterator fLine = fcLine.features();
        FeatureSource fsRLine = (FeatureSource)layers.get(this.getRestrictedLineTypeRef());
        FeatureCollection fcRLine = fsRLine.getFeatures();
        while (fLine.hasNext()) {
            SimpleFeature line = (SimpleFeature)fLine.next();
            FeatureIterator fRLine = fcRLine.features();
            Geometry lineGeom = (Geometry)line.getDefaultGeometry();
            if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
            if (LineString.class.isAssignableFrom(lineGeom.getClass())) {
                while (fRLine.hasNext()) {
                    SimpleFeature rLine = (SimpleFeature)fRLine.next();
                    Geometry rLineGeom = (Geometry)rLine.getDefaultGeometry();
                    if (envelope.contains(rLineGeom.getEnvelopeInternal())) {
                        if (LineString.class.isAssignableFrom(rLineGeom.getClass())) {
                            if (lineGeom.intersects(rLineGeom)) {
                                if (this.hasPair(((LineString)lineGeom).getCoordinateSequence(), ((LineString)rLineGeom).getCoordinateSequence())) continue;
                                results.error(rLine, "Line does not intersect line at node covered by the specified Line.");
                                r = false;
                                continue;
                            }
                            results.warning(rLine, "Does not intersect the LineString");
                            continue;
                        }
                        fcRLine.remove(rLine);
                        results.warning(rLine, "Invalid type: this feature is not a derivative of a LineString");
                        continue;
                    }
                    fcRLine.remove(rLine);
                }
                continue;
            }
            results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
        }
        return r;
    }

    private boolean hasPair(CoordinateSequence a1, CoordinateSequence a2) {
        int i;
        CoordinateSequence c = a1;
        HashSet<Coordinate> m = new HashSet<Coordinate>();
        for (i = 0; i < c.size(); ++i) {
            m.add(c.getCoordinate(i));
        }
        c = a2;
        for (i = 0; i < c.size(); ++i) {
            if (m.add(c.getCoordinate(i))) continue;
            return true;
        }
        return false;
    }
}

