/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.attributes;

import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class EqualityValidation
extends DefaultFeatureValidation {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");
    private String attributeName;
    private Object expected;
    private Filter filter = Filter.INCLUDE;

    public int getPriority() {
        return 200;
    }

    public String[] getTypeRefs() {
        if (this.getTypeRef() == null) {
            return null;
        }
        if (this.getTypeRef().equals("*")) {
            return ALL;
        }
        return new String[]{this.getTypeRef()};
    }

    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        if (!this.filter.evaluate((Object)feature)) {
            return true;
        }
        Object actual = feature.getAttribute(this.attributeName);
        if (this.expected.equals(actual)) {
            return true;
        }
        results.error(feature, this.attributeName + " did not not equals " + this.expected);
        return false;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Object getExpected() {
        return this.expected;
    }

    public void setExpected(Object expected) {
        this.expected = expected;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

