/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.Dispatcher;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.FakeHttpServletRequest;
import org.geowebcache.layer.wms.FakeHttpServletResponse;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;

public class WMSGeoServerHelper
extends WMSSourceHelper {
    private static Logger log = Logging.getLogger((String)WMSGeoServerHelper.class.toString());
    Dispatcher gsDispatcher;

    public WMSGeoServerHelper(Dispatcher gsDispatcher) {
        this.gsDispatcher = gsDispatcher;
    }

    protected byte[] makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, String wmsParams, String expectedMimeType) throws GeoWebCacheException {
        FakeHttpServletRequest req = new FakeHttpServletRequest(wmsParams);
        FakeHttpServletResponse resp = new FakeHttpServletResponse();
        try {
            this.gsDispatcher.handleRequest((HttpServletRequest)req, (HttpServletResponse)resp);
        }
        catch (Exception e) {
            log.fine(e.getMessage());
            throw new GeoWebCacheException("Problem communicating with GeoServer" + e.getMessage());
        }
        if (super.mimeStringCheck(expectedMimeType, resp.getContentType())) {
            byte[] bytes = resp.getBytes();
            log.finer("Received " + bytes.length);
            tileRespRecv.setStatus(200);
            return bytes;
        }
        log.severe("Unexpected response from GeoServer for request: " + wmsParams);
        throw new GeoWebCacheException("Unexpected response from GeoServer for request " + wmsParams);
    }
}

