/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.wfs;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.data.Query;
import org.geotools.filter.Filter;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLComplexTypes;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.AttributeGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.wfs.WFSSchema;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WFSBasicComplexTypes {
    public static final String LOCK_KEY = "WFSBasicComplexTypes.LOCKID.KEY";

    static class FeatureCollectionType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new FeatureCollectionType();

        FeatureCollectionType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return new Attribute[]{new AttributeGT(null, "lockId", WFSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false)};
        }

        public ElementGrouping getChild() {
            return ((ComplexType)this.getParent()).getChild();
        }

        public Type getParent() {
            return GMLComplexTypes.AbstractFeatureCollectionType.getInstance();
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
            String lock = null;
            lock = attrs.getValue("", "lockID");
            if (lock == null || "".equals(lock)) {
                lock = attrs.getValue(WFSSchema.NAMESPACE.toString(), "lockID");
            }
            if (hints != null && lock != null && !"".equals(lock)) {
                hints.put(WFSBasicComplexTypes.LOCK_KEY, lock);
            }
            return this.getParent().getValue(element, value, attrs, hints);
        }

        public String getName() {
            return "FeatureCollectionType";
        }

        public Class getInstanceType() {
            return this.getParent().getInstanceType();
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return this.getParent().canEncode(element, value, hints);
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            this.getParent().encode(element, value, output, hints);
        }
    }

    static class QueryType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new QueryType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement(FilterSchema.getInstance().getElements()[34], 0, Integer.MAX_VALUE){

            public URI getNamespace() {
                return FilterSchema.NAMESPACE;
            }
        }, new WFSSchema.WFSElement(FilterSchema.getInstance().getElements()[2], 0, Integer.MAX_VALUE){

            public URI getNamespace() {
                return FilterSchema.NAMESPACE;
            }
        }};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("handle", XSISimpleTypes.String.getInstance(), 0), new WFSSchema.WFSAttribute("typeName", XSISimpleTypes.QName.getInstance(), 2), new WFSSchema.WFSAttribute("featureVersion", XSISimpleTypes.String.getInstance(), 0)};

        QueryType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) {
            return null;
        }

        public String getName() {
            return "QueryType";
        }

        public Class getInstanceType() {
            return Query.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            if (element.getType() != null && this.getName().equals(element.getType().getName())) {
                return value == null || value instanceof Query;
            }
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (this.canEncode(element, value, hints)) {
                Query query = (Query)value;
                AttributesImpl attributes = new AttributesImpl();
                if (query.getHandle() != null && !"".equals(query.getHandle())) {
                    attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[0].getName(), null, "string", query.getHandle());
                }
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", query.getTypeName());
                try {
                    if (query.getVersion() != null && !"".equals(query.getVersion())) {
                        attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[2].getName(), null, "string", query.getVersion());
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                output.startElement(element.getNamespace(), element.getName(), (Attributes)attributes);
                String[] propNames = query.getPropertyNames();
                if (Query.ALL_NAMES != propNames && propNames != null) {
                    for (int i = 0; i < propNames.length; ++i) {
                        elems[0].getType().encode(elems[0], (Object)propNames[i], output, hints);
                    }
                }
                if (Filter.INCLUDE != query.getFilter() && query.getFilter() != null && elems[1].getType().canEncode(elems[1], (Object)query.getFilter(), hints)) {
                    elems[1].getType().encode(elems[1], (Object)query.getFilter(), output, hints);
                }
            } else {
                throw new OperationNotSupportedException("not a valid value/element for a DescribeFeatureTypeType.");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class GetCapabilitiesType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new GetCapabilitiesType();
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("version", XSISimpleTypes.String.getInstance(), 2){

            public String getFixed() {
                return "1.0.0";
            }
        }, new WFSSchema.WFSAttribute("service", XSISimpleTypes.String.getInstance(), 2){

            public String getFixed() {
                return "WFS";
            }
        }};

        GetCapabilitiesType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) {
            return null;
        }

        public String getName() {
            return "GetCapabilitiesType";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value == null;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[0].getName(), null, "string", attrs[0].getFixed());
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", attrs[1].getFixed());
            output.element(element.getNamespace(), element.getName(), (Attributes)attributes);
        }
    }

    static class DescribeFeatureTypeType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new DescribeFeatureTypeType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("TypeName", (Type)XSISimpleTypes.QName.getInstance(), 0, Integer.MAX_VALUE, false, null)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("version", XSISimpleTypes.String.getInstance(), 2){

            public String getFixed() {
                return "1.0.0";
            }
        }, new WFSSchema.WFSAttribute("service", XSISimpleTypes.String.getInstance(), 2){

            public String getFixed() {
                return "WFS";
            }
        }, new WFSSchema.WFSAttribute("outputFormat", XSISimpleTypes.String.getInstance(), 2){

            public String getFixed() {
                return "XMLSCHEMA";
            }
        }};

        DescribeFeatureTypeType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) {
            return null;
        }

        public String getName() {
            return "DescribeFeatureTypeType";
        }

        public Class getInstanceType() {
            return String[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            if (element.getType() != null && this.getName().equals(element.getType().getName())) {
                return value instanceof String[];
            }
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (this.canEncode(element, value, hints)) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[0].getName(), null, "string", attrs[0].getFixed());
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", attrs[1].getFixed());
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[2].getName(), null, "string", attrs[2].getFixed());
                output.startElement(element.getNamespace(), element.getName(), (Attributes)attributes);
                String[] strs = (String[])value;
                for (int i = 0; i < strs.length; ++i) {
                    XSISimpleTypes.QName.getInstance().encode(elems[0], (Object)strs[i], output, hints);
                }
            } else {
                throw new OperationNotSupportedException("not a valid value/element for a DescribeFeatureTypeType.");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class GetFeatureType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new GetFeatureType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("Query", (Type)QueryType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("version", XSISimpleTypes.String.getInstance(), 2){

            public String getFixed() {
                return "1.0.0";
            }
        }, new WFSSchema.WFSAttribute("service", XSISimpleTypes.String.getInstance(), 2){

            public String getFixed() {
                return "WFS";
            }
        }, new WFSSchema.WFSAttribute("outputFormat", XSISimpleTypes.String.getInstance(), 2){

            public String getFixed() {
                return "GML2";
            }
        }, new WFSSchema.WFSAttribute("maxFeatures", XSISimpleTypes.PositiveInteger.getInstance(), 0)};

        GetFeatureType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) {
            return null;
        }

        public String getName() {
            return "GetFeatureType";
        }

        public Class getInstanceType() {
            return Query.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            if (element.getType() != null && this.getName().equals(element.getType().getName())) {
                return value == null || value instanceof Query;
            }
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (this.canEncode(element, value, hints)) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[0].getName(), null, "string", attrs[0].getFixed());
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", attrs[1].getFixed());
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[2].getName(), null, "string", attrs[2].getFixed());
                Query query = (Query)value;
                if (query != null && query.getMaxFeatures() != Integer.MAX_VALUE) {
                    attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[3].getName(), null, "integer", "" + query.getMaxFeatures());
                }
                output.startElement(element.getNamespace(), element.getName(), (Attributes)attributes);
                if (elems[0].getType().canEncode(elems[0], value, hints)) {
                    elems[0].getType().encode(elems[0], value, output, hints);
                }
            } else {
                throw new OperationNotSupportedException("not a valid value/element for a DescribeFeatureTypeType.");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }
}

