/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.protocol.wfs;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EObject;
import org.geotools.util.logging.Logging;

public class WFSResponse {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs.protocol.wfs");
    private Charset charset;
    private String contentType;
    private InputStream inputStream;
    private EObject request;
    private String targetUrl;

    public WFSResponse(String targetUrl, EObject originatingRequest, Charset charset, String contentType, InputStream in) {
        this.targetUrl = targetUrl;
        this.request = originatingRequest;
        this.charset = charset == null ? Charset.forName("UTF-8") : charset;
        this.contentType = contentType;
        this.inputStream = in;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("WFS response: charset=" + charset + ", contentType=" + contentType);
        }
    }

    public Charset getCharacterEncoding() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    public EObject getOriginatingRequest() {
        return this.request;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public String toString() {
        return "WFSResponse[charset=" + this.charset + ", contentType=" + this.contentType + "]";
    }
}

