/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.expression.Expression;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class GridCoverageRenderer {
    private static boolean DEBUG = Boolean.getBoolean("org.geotools.renderer.lite.gridcoverage2d.debug");
    private static String debugDir;
    private static final Crop coverageCropFactory;
    private static final Logger LOGGER;
    private final CoordinateReferenceSystem destinationCRS;
    private final GeneralEnvelope destinationEnvelope;
    private final Rectangle destinationSize;
    private final AffineTransform finalGridToWorld;
    private final AffineTransform finalWorldToGrid;
    private final Hints hints = new Hints();
    private static final ParameterValueGroup resampleParams;
    private static ParameterValueGroup cropParams;
    private static final Resample resampleFactory;

    static float getOpacity(RasterSymbolizer symbolizer) {
        float alpha = 1.0f;
        Expression exp = symbolizer.getOpacity();
        if (exp == null) {
            return alpha;
        }
        Number number = (Number)exp.evaluate(null, Float.class);
        if (number == null) {
            return alpha;
        }
        return number.floatValue();
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize) throws TransformException, NoninvertibleTransformException {
        this(destinationCRS, envelope, screenSize, null, null);
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize, AffineTransform worldToScreen) throws TransformException, NoninvertibleTransformException {
        this(destinationCRS, envelope, screenSize, worldToScreen, null);
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize, RenderingHints java2dHints) throws TransformException, NoninvertibleTransformException {
        this(destinationCRS, envelope, screenSize, null, java2dHints);
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize, AffineTransform worldToScreen, RenderingHints java2dHints) throws TransformException, NoninvertibleTransformException {
        this.destinationSize = screenSize;
        this.destinationCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)destinationCRS);
        if (this.destinationCRS == null) {
            throw new TransformException(Errors.format((int)31, (Object)destinationCRS));
        }
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper();
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        gridToEnvelopeMapper.setGridRange((GridEnvelope)new GridEnvelope2D(this.destinationSize));
        this.destinationEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)new ReferencedEnvelope(envelope, destinationCRS));
        gridToEnvelopeMapper.setEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
        if (worldToScreen != null && XAffineTransform.getRotation((AffineTransform)worldToScreen) != 0.0) {
            this.finalWorldToGrid = new AffineTransform(worldToScreen);
            this.finalGridToWorld = this.finalWorldToGrid.createInverse();
        } else {
            this.finalGridToWorld = new AffineTransform(gridToEnvelopeMapper.createAffineTransform());
            this.finalWorldToGrid = this.finalGridToWorld.createInverse();
        }
        if (java2dHints != null) {
            this.hints.add(java2dHints);
        }
        this.hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        this.hints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
    }

    private static GridCoverage2D resample(GridCoverage2D gc, CoordinateReferenceSystem crs, Interpolation interpolation, GeneralEnvelope destinationEnvelope, Hints hints) throws FactoryException {
        assert (CRS.equalsIgnoreMetadata((Object)destinationEnvelope.getCoordinateReferenceSystem(), (Object)crs) || CRS.findMathTransform((CoordinateReferenceSystem)destinationEnvelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)crs).isIdentity());
        ParameterValueGroup param = resampleParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)crs);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        return (GridCoverage2D)resampleFactory.doOperation(param, hints);
    }

    private static GridCoverage2D getCroppedCoverage(GridCoverage2D gc, GeneralEnvelope envelope, CoordinateReferenceSystem crs, Hints hints) {
        GeneralEnvelope oldEnvelope = (GeneralEnvelope)gc.getEnvelope();
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)envelope);
        intersectionEnvelope.setCoordinateReferenceSystem(crs);
        intersectionEnvelope.intersect((org.opengis.geometry.Envelope)oldEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            return null;
        }
        ParameterValueGroup param = cropParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("Envelope").setValue((Object)intersectionEnvelope);
        return (GridCoverage2D)coverageCropFactory.doOperation(param, hints);
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer) throws FactoryException, TransformException, NoninvertibleTransformException {
        RenderedImage finalImage;
        GridCoverage2D finalGC;
        GridCoverage2D preSymbolizer;
        GeneralEnvelope destinationEnvelopeInSourceCRS;
        boolean doReprojection;
        GeneralEnvelope sourceCoverageEnvelope;
        CoordinateReferenceSystem sourceCoverageCRS;
        block49: {
            if (graphics == null) {
                throw new NullPointerException(Errors.format((int)143, (Object)"graphics"));
            }
            if (gridCoverage == null) {
                throw new NullPointerException(Errors.format((int)143, (Object)"gridCoverage"));
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Drawing coverage " + gridCoverage.toString());
            }
            sourceCoverageCRS = gridCoverage.getCoordinateReferenceSystem2D();
            sourceCoverageEnvelope = (GeneralEnvelope)gridCoverage.getEnvelope();
            MathTransform sourceCRSToDestinationCRSTransformation = CRS.findMathTransform((CoordinateReferenceSystem)sourceCoverageCRS, (CoordinateReferenceSystem)this.destinationCRS, (boolean)true);
            MathTransform destinationCRSToSourceCRSTransformation = sourceCRSToDestinationCRSTransformation.inverse();
            boolean bl = doReprojection = !sourceCRSToDestinationCRSTransformation.isIdentity();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Transforming coverage envelope with transform " + destinationCRSToSourceCRSTransformation.toWKT());
            }
            if (doReprojection) {
                try {
                    destinationEnvelopeInSourceCRS = CRS.transform((MathTransform)destinationCRSToSourceCRSTransformation, (org.opengis.geometry.Envelope)this.destinationEnvelope);
                }
                catch (TransformException te) {
                    GeneralEnvelope destinationEnvelopeWGS84;
                    if (!CRS.equalsIgnoreMetadata((Object)this.destinationCRS, (Object)DefaultGeographicCRS.WGS84)) {
                        MathTransform destinationCRSToWGS84transformation = CRS.findMathTransform((CoordinateReferenceSystem)this.destinationCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
                        if (!destinationCRSToWGS84transformation.isIdentity()) {
                            destinationEnvelopeWGS84 = CRS.transform((MathTransform)destinationCRSToWGS84transformation, (org.opengis.geometry.Envelope)this.destinationEnvelope);
                            destinationEnvelopeWGS84.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                        } else {
                            destinationEnvelopeWGS84 = new GeneralEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
                        }
                    } else {
                        destinationEnvelopeWGS84 = new GeneralEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
                    }
                    if (!CRS.equalsIgnoreMetadata((Object)sourceCoverageCRS, (Object)DefaultGeographicCRS.WGS84)) {
                        MathTransform WGS84ToSourceCoverageCRSTransformation = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)sourceCoverageCRS, (boolean)true);
                        if (!WGS84ToSourceCoverageCRSTransformation.isIdentity()) {
                            destinationEnvelopeInSourceCRS = CRS.transform((MathTransform)WGS84ToSourceCoverageCRSTransformation, (org.opengis.geometry.Envelope)destinationEnvelopeWGS84);
                            destinationEnvelopeInSourceCRS.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                        } else {
                            destinationEnvelopeInSourceCRS = new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelopeWGS84);
                        }
                        break block49;
                    }
                    destinationEnvelopeInSourceCRS = new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelopeWGS84);
                }
            } else {
                destinationEnvelopeInSourceCRS = new GeneralEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
            }
        }
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelopeInSourceCRS);
        intersectionEnvelope.intersect((org.opengis.geometry.Envelope)sourceCoverageEnvelope);
        if (intersectionEnvelope.isEmpty() || intersectionEnvelope.isNull()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("The destination envelope does not intersect the envelope of the source coverage.");
            }
            return;
        }
        Interpolation interpolation = (Interpolation)this.hints.get((Object)JAI.KEY_INTERPOLATION);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Using interpolation " + interpolation);
        }
        GridCoverage2D preResample = gridCoverage;
        try {
            preResample = GridCoverageRenderer.getCroppedCoverage(gridCoverage, intersectionEnvelope, sourceCoverageCRS, this.hints);
            if (preResample == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Skipping current coverage because cropped to an empty area");
                }
                return;
            }
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Crop Failed for reason: " + t.getLocalizedMessage());
            }
            preResample = gridCoverage;
        }
        if (DEBUG) {
            this.writeRenderedImage(preResample.geophysics(false).getRenderedImage(), "preresample");
        }
        if (doReprojection) {
            preSymbolizer = GridCoverageRenderer.resample(preResample, this.destinationCRS, (Interpolation)(interpolation == null ? new InterpolationNearest() : interpolation), this.destinationEnvelope, this.hints);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Reprojecting to crs " + this.destinationCRS.toWKT());
            }
        } else {
            preSymbolizer = preResample;
        }
        if (DEBUG) {
            this.writeRenderedImage(preSymbolizer.geophysics(false).getRenderedImage(), "preSymbolizer");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Raster Symbolizer ");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Raster Symbolizer ").toString());
        }
        if (symbolizer != null) {
            RasterSymbolizerHelper rsp = new RasterSymbolizerHelper(preSymbolizer, this.hints);
            rsp.visit(symbolizer);
            finalGC = (GridCoverage2D)rsp.getOutput();
            finalImage = finalGC.geophysics(false).getRenderedImage();
        } else {
            finalGC = preSymbolizer;
            finalImage = finalGC.geophysics(false).getRenderedImage();
        }
        GridGeometry2D recoloredCoverageGridGeometry = finalGC.getGridGeometry();
        MathTransform2D finalGCTransform = recoloredCoverageGridGeometry.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        if (!(finalGCTransform instanceof AffineTransform)) {
            throw new UnsupportedOperationException("Non-affine transformations not yet implemented");
        }
        AffineTransform finalGCgridToWorld = new AffineTransform((AffineTransform)finalGCTransform);
        AffineTransform clonedFinalWorldToGrid = (AffineTransform)this.finalWorldToGrid.clone();
        clonedFinalWorldToGrid.concatenate(finalGCgridToWorld);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("clonedFinalWorldToGrid " + clonedFinalWorldToGrid.toString());
        }
        RenderingHints oldHints = graphics.getRenderingHints();
        graphics.setRenderingHints((Map<?, ?>)this.hints);
        float alpha = GridCoverageRenderer.getOpacity(symbolizer);
        Composite oldAlphaComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, alpha));
        try {
            if (DEBUG) {
                this.writeRenderedImage(finalImage, "final");
            }
            graphics.drawRenderedImage(finalImage, clonedFinalWorldToGrid);
        }
        catch (Throwable t) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
                }
                if (t instanceof IllegalArgumentException) {
                    if (DEBUG) {
                        this.writeRenderedImage(finalImage, "preWORKAROUND1");
                    }
                    RenderedImage image = new ImageWorker(finalImage).forceComponentColorModel(true).getRenderedImage();
                    if (DEBUG) {
                        this.writeRenderedImage(image, "WORKAROUND1");
                    }
                    graphics.drawRenderedImage(image, clonedFinalWorldToGrid);
                } else if (t instanceof ImagingOpException) {
                    BufferedImage buf;
                    BufferedImage bufferedImage = buf = finalImage.getColorModel().hasAlpha() ? new BufferedImage(finalImage.getWidth(), finalImage.getHeight(), 6) : new BufferedImage(finalImage.getWidth(), finalImage.getHeight(), 5);
                    if (DEBUG) {
                        this.writeRenderedImage(buf, "preWORKAROUND2");
                    }
                    Graphics2D g = (Graphics2D)buf.getGraphics();
                    int translationX = finalImage.getMinX();
                    int translationY = finalImage.getMinY();
                    g.drawRenderedImage(finalImage, AffineTransform.getTranslateInstance(-translationX, -translationY));
                    g.dispose();
                    if (DEBUG) {
                        this.writeRenderedImage(buf, "WORKAROUND2");
                    }
                    clonedFinalWorldToGrid.concatenate(AffineTransform.getTranslateInstance(translationX, translationY));
                    graphics.drawImage(buf, clonedFinalWorldToGrid, null);
                    buf.flush();
                    buf = null;
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to renderer this raster, no workaround found");
                }
            }
            catch (Throwable t1) {
                LOGGER.log(Level.WARNING, t1.getLocalizedMessage(), t1);
            }
        }
        graphics.setComposite(oldAlphaComposite);
        graphics.setRenderingHints(oldHints);
    }

    private void writeRenderedImage(RenderedImage raster, String fileName) {
        if (debugDir == null) {
            throw new NullPointerException("Unable to write the provided coverage in the debug directory");
        }
        if (!DEBUG) {
            throw new IllegalStateException("Unable to write the provided coverage since we are not in debug mode");
        }
        try {
            ImageIO.write(raster, "tiff", new File(debugDir, fileName + ".tiff"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    static {
        if (DEBUG) {
            File tempDir = new File(System.getProperty("user.home"), "gt-renderer");
            if (!tempDir.exists()) {
                if (!tempDir.mkdir()) {
                    System.out.println("Unable to create debug dir, exiting application!!!");
                }
                DEBUG = false;
                debugDir = null;
            } else {
                debugDir = tempDir.getAbsolutePath();
                System.out.println("Debug dir " + debugDir);
            }
        }
        coverageCropFactory = new Crop();
        LOGGER = Logging.getLogger((String)"org.geotools.rendering");
        DefaultProcessor processor = new DefaultProcessor((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        resampleParams = processor.getOperation("Resample").getParameters();
        cropParams = processor.getOperation("CoverageCrop").getParameters();
        resampleFactory = new Resample();
    }
}

