/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LineStringCursor;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.TextStyle2D;

public class LabelPainter {
    LabelCacheItem labelItem;
    List<LineInfo> lines;
    Graphics2D graphics;
    boolean outlineRenderingEnabled;
    GeometryFactory gf = new GeometryFactory();
    Rectangle2D labelBounds;

    public LabelPainter(Graphics2D graphics, boolean outlineRenderingEnabled) {
        this.graphics = graphics;
        this.outlineRenderingEnabled = outlineRenderingEnabled;
    }

    public void setLabel(LabelCacheItem labelItem) {
        this.labelItem = labelItem;
        labelItem.getTextStyle().setLabel(labelItem.getLabel());
        this.labelBounds = null;
        this.lines = null;
        String text = labelItem.getLabel();
        if (!text.contains("\n") && labelItem.getAutoWrap() <= 0 || labelItem.isFollowLineEnabled()) {
            FontRenderContext frc = this.graphics.getFontRenderContext();
            TextLayout layout = new TextLayout(text, labelItem.getTextStyle().getFont(), frc);
            LineInfo line = new LineInfo(text, this.layoutSentence(text, labelItem), layout);
            this.labelBounds = line.gv.getVisualBounds();
            this.normalizeBounds(this.labelBounds);
            this.lines = Collections.singletonList(line);
            return;
        }
        String[] splitted = text.split("\\n");
        this.lines = new ArrayList<LineInfo>();
        if (labelItem.getAutoWrap() <= 0) {
            for (String string : splitted) {
                FontRenderContext frc = this.graphics.getFontRenderContext();
                TextLayout layout = new TextLayout(string, labelItem.getTextStyle().getFont(), frc);
                LineInfo info = new LineInfo(string, this.layoutSentence(string, labelItem), layout);
                this.lines.add(info);
            }
        } else {
            HashMap<TextAttribute, Font> map = new HashMap<TextAttribute, Font>();
            map.put(TextAttribute.FONT, labelItem.getTextStyle().getFont());
            for (int i = 0; i < splitted.length; ++i) {
                String line = splitted[i];
                AttributedString attributedString = new AttributedString(line, map);
                AttributedCharacterIterator iter = attributedString.getIterator();
                LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(iter, BreakIterator.getWordInstance(), this.graphics.getFontRenderContext());
                int prevPosition = 0;
                while (lineMeasurer.getPosition() < iter.getEndIndex()) {
                    TextLayout layout = lineMeasurer.nextLayout(labelItem.getAutoWrap());
                    int newPosition = lineMeasurer.getPosition();
                    String extracted = line.substring(prevPosition, newPosition).trim();
                    prevPosition = newPosition;
                    LineInfo info = new LineInfo(extracted, this.layoutSentence(extracted, labelItem), layout);
                    this.lines.add(info);
                }
            }
        }
        double maxWidth = 0.0;
        for (LineInfo lineInfo : this.lines) {
            maxWidth = Math.max(lineInfo.gv.getVisualBounds().getWidth(), maxWidth);
        }
        double boundsY = 0.0;
        double labelY = 0.0;
        for (LineInfo info : this.lines) {
            double minX;
            Rectangle2D currBounds = info.gv.getVisualBounds();
            TextLayout layout = info.layout;
            info.x = minX = (maxWidth - currBounds.getWidth()) * labelItem.getTextStyle().getAnchorX() - currBounds.getMinX();
            if (this.labelBounds == null) {
                this.labelBounds = currBounds;
                boundsY = currBounds.getMinY() + (double)layout.getAscent() + (double)layout.getDescent() + (double)layout.getLeading();
            } else {
                Rectangle2D.Double translated = new Rectangle2D.Double(minX, boundsY, currBounds.getWidth(), currBounds.getHeight());
                boundsY += (double)(layout.getAscent() + layout.getDescent() + layout.getLeading());
                labelY += (double)(layout.getAscent() + layout.getDescent() + layout.getLeading());
                this.labelBounds = this.labelBounds.createUnion(translated);
            }
            info.y = labelY;
        }
        this.normalizeBounds(this.labelBounds);
    }

    void normalizeBounds(Rectangle2D bounds) {
        if (bounds.isEmpty()) {
            bounds.setRect(bounds.getCenterX() - 1.0, bounds.getCenterY() - 1.0, 2.0, 2.0);
        }
    }

    GlyphVector layoutSentence(String label, LabelCacheItem item) {
        int length;
        Font font = item.getTextStyle().getFont();
        char[] chars = label.toCharArray();
        if (Bidi.requiresBidi(chars, 0, length = label.length()) && new Bidi(label, -2).isRightToLeft()) {
            return font.layoutGlyphVector(this.graphics.getFontRenderContext(), chars, 0, length, 1);
        }
        return font.createGlyphVector(this.graphics.getFontRenderContext(), chars);
    }

    public LabelCacheItem getLabel() {
        return this.labelItem;
    }

    public double getLineHeight() {
        return this.lines.get((int)0).gv.getVisualBounds().getHeight() - (double)this.lines.get((int)0).layout.getDescent();
    }

    public double getAscent() {
        return this.lines.get((int)0).layout.getAscent();
    }

    public int getStraightLabelWidth() {
        return (int)Math.round(this.getLabelBounds().getWidth());
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public Rectangle2D getFullLabelBounds() {
        Rectangle2D bounds = (Rectangle2D)this.getLabelBounds().clone();
        int haloRadius = Math.round(this.labelItem.getTextStyle().getHaloFill() != null ? this.labelItem.getTextStyle().getHaloRadius() : 0.0f);
        bounds.add(bounds.getMinX() - (double)haloRadius, bounds.getMinY() - (double)haloRadius);
        bounds.add(bounds.getMaxX() + (double)haloRadius, bounds.getMaxY() + (double)haloRadius);
        if (this.labelItem.getTextStyle().getGraphic() != null) {
            Rectangle area = this.labelItem.getTextStyle().getGraphicDimensions();
            Rectangle2D.Double shieldBounds = new Rectangle2D.Double(-((RectangularShape)area).getWidth() / 2.0 + bounds.getMinX() - bounds.getWidth() / 2.0, -((RectangularShape)area).getHeight() / 2.0 + bounds.getMinY() - bounds.getHeight() / 2.0, ((RectangularShape)area).getWidth(), ((RectangularShape)area).getHeight());
            bounds = bounds.createUnion(shieldBounds);
        }
        this.normalizeBounds(bounds);
        return bounds;
    }

    public Rectangle2D getLabelBounds() {
        return this.labelBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintStraightLabel(AffineTransform transform) throws Exception {
        Rectangle2D glyphBounds = this.getLabelBounds();
        glyphBounds = transform.createTransformedShape(glyphBounds).getBounds();
        AffineTransform oldTransform = this.graphics.getTransform();
        try {
            AffineTransform newTransform = new AffineTransform(oldTransform);
            newTransform.concatenate(transform);
            this.graphics.setTransform(newTransform);
            if (this.labelItem.getTextStyle().getGraphic() != null) {
                LiteShape2 tempShape = new LiteShape2((Geometry)this.gf.createPoint(new Coordinate(glyphBounds.getWidth() / 2.0, -1.0 * glyphBounds.getHeight() / 2.0)), null, null, false, false);
                this.labelItem.getTextStyle().getGraphic().setMinMaxScale(0.0, 10.0);
                new StyledShapePainter(null).paint(this.graphics, tempShape, this.labelItem.getTextStyle().getGraphic(), 5.0);
            }
            if (this.labelItem.getTextStyle().getFont().getSize() == 0) {
                return;
            }
            if (this.lines.size() == 1) {
                this.drawGlyphVector(this.lines.get((int)0).gv);
            } else {
                AffineTransform lineTx = new AffineTransform(transform);
                for (LineInfo line : this.lines) {
                    lineTx.setTransform(transform);
                    lineTx.translate(line.x, line.y);
                    this.graphics.setTransform(lineTx);
                    this.drawGlyphVector(line.gv);
                }
            }
        }
        finally {
            this.graphics.setTransform(oldTransform);
        }
    }

    private void drawGlyphVector(GlyphVector gv) {
        Shape outline = gv.getOutline();
        if (this.labelItem.getTextStyle().getHaloFill() != null) {
            this.configureHalo();
            this.graphics.draw(outline);
        }
        this.configureLabelStyle();
        if (this.outlineRenderingEnabled) {
            this.graphics.fill(outline);
        } else {
            this.graphics.drawGlyphVector(gv, 0.0f, 0.0f);
        }
    }

    private void configureHalo() {
        this.graphics.setPaint(this.labelItem.getTextStyle().getHaloFill());
        this.graphics.setComposite(this.labelItem.getTextStyle().getHaloComposite());
        int haloRadius = Math.round(this.labelItem.getTextStyle().getHaloFill() != null ? this.labelItem.getTextStyle().getHaloRadius() : 0.0f);
        this.graphics.setStroke(new BasicStroke(2.0f * (float)haloRadius, 1, 1));
    }

    private void configureLabelStyle() {
        Paint fill = this.labelItem.getTextStyle().getFill();
        Composite comp = this.labelItem.getTextStyle().getComposite();
        if (fill == null) {
            fill = Color.BLACK;
            comp = AlphaComposite.getInstance(3, 1.0f);
        }
        this.graphics.setPaint(fill);
        this.graphics.setComposite(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintCurvedLabel(LineStringCursor cursor) {
        if (this.labelItem.getTextStyle().getFont().getSize() == 0) {
            return;
        }
        GlyphVector glyphVector = this.lines.get((int)0).gv;
        AffineTransform oldTransform = this.graphics.getTransform();
        try {
            int i;
            if (!this.isLabelUpwards(cursor) && this.labelItem.isForceLeftToRightEnabled()) {
                LineStringCursor reverse = cursor.reverse();
                reverse.moveTo(cursor.getLineStringLength() - cursor.getCurrentOrdinate());
                cursor = reverse;
            }
            double anchorY = this.getLinePlacementYAnchor();
            double mid = cursor.getCurrentOrdinate();
            Coordinate c = new Coordinate();
            c = cursor.getCurrentPosition(c);
            this.graphics.setPaint(Color.BLACK);
            double startOrdinate = mid - (double)(this.getStraightLabelWidth() / 2);
            if (startOrdinate < 0.0) {
                startOrdinate = 0.0;
            }
            cursor.moveTo(startOrdinate);
            int numGlyphs = glyphVector.getNumGlyphs();
            float nextAdvance = glyphVector.getGlyphMetrics(0).getAdvance() * 0.5f;
            Shape[] outlines = new Shape[numGlyphs];
            AffineTransform[] transforms = new AffineTransform[numGlyphs];
            for (i = 0; i < numGlyphs; ++i) {
                outlines[i] = glyphVector.getGlyphOutline(i);
                Point2D p = glyphVector.getGlyphPosition(i);
                float advance = nextAdvance;
                nextAdvance = i < numGlyphs - 1 ? glyphVector.getGlyphMetrics(i + 1).getAdvance() * 0.5f : 0.0f;
                c = cursor.getCurrentPosition(c);
                AffineTransform t = new AffineTransform();
                t.setToTranslation(c.x, c.y);
                t.rotate(cursor.getCurrentAngle());
                t.translate(-p.getX() - (double)advance, -p.getY() + this.getLineHeight() * anchorY);
                transforms[i] = t;
                cursor.moveTo(cursor.getCurrentOrdinate() + (double)advance + (double)nextAdvance);
            }
            if (this.labelItem.getTextStyle().getHaloFill() != null) {
                this.configureHalo();
                for (i = 0; i < numGlyphs; ++i) {
                    this.graphics.setTransform(transforms[i]);
                    this.graphics.draw(outlines[i]);
                }
            }
            this.configureLabelStyle();
            for (i = 0; i < numGlyphs; ++i) {
                this.graphics.setTransform(transforms[i]);
                this.graphics.fill(outlines[i]);
            }
        }
        finally {
            this.graphics.setTransform(oldTransform);
        }
    }

    public double getLinePlacementYAnchor() {
        TextStyle2D textStyle = this.getLabel().getTextStyle();
        LineMetrics lm = textStyle.getFont().getLineMetrics(textStyle.getLabel(), this.graphics.getFontRenderContext());
        if (lm.getHeight() > 0.0f) {
            return (Math.abs(lm.getStrikethroughOffset()) + lm.getDescent() + lm.getLeading() / 2.0f) / lm.getHeight();
        }
        return 0.0;
    }

    boolean isLabelUpwards(LineStringCursor cursor) {
        double labelAngle = cursor.getCurrentAngle() + 1.5707963267948966;
        return (labelAngle %= Math.PI * 2) >= 0.0 && labelAngle < Math.PI;
    }

    private static class LineInfo {
        double x;
        double y;
        String text;
        GlyphVector gv;
        TextLayout layout;

        public LineInfo(String text, GlyphVector gv, TextLayout layout) {
            this.text = text;
            this.gv = gv;
            this.layout = layout;
        }

        public LineInfo(String text, GlyphVector gv) {
            this.text = text;
            this.gv = gv;
        }
    }
}

