/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.jdbc.datasource.DataSourceUtil;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.mysql.MySQLDataStore;
import org.geotools.util.logging.Logging;

public class MySQLDataStoreFactory
extends AbstractDataStoreFactory {
    private static final Logger LOGGER = Logging.getLogger((String)MySQLDataStoreFactory.class.getName());
    private static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "must be 'mysql'", true, (Object)"mysql");
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "mysql host machine", true, (Object)"localhost");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "mysql connection port", false, (Object)"3306");
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "msyql database");
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "user name to login as", false);
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, "password used to login", false);
    public static final DataAccessFactory.Param MAXCONN = new DataAccessFactory.Param("max connections", Integer.class, "maximum number of open connections", false, (Object)new Integer(10));
    public static final DataAccessFactory.Param MINCONN = new DataAccessFactory.Param("min connections", Integer.class, "minimum number of pooled connection", false, (Object)new Integer(4));
    public static final DataAccessFactory.Param VALIDATECONN = new DataAccessFactory.Param("validate connections", Boolean.class, "check connection is alive before using it", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "namespace prefix used", false);
    public static final DataAccessFactory.Param WKBENABLED = new DataAccessFactory.Param("wkb enabled", Boolean.class, "set to true if Well Known Binary should be used to read MySQLdata (experimental)", false, (Object)new Boolean(true));
    static final DataAccessFactory.Param[] arrayParameters = new DataAccessFactory.Param[]{DBTYPE, HOST, PORT, DATABASE, USER, PASSWD, NAMESPACE, WKBENABLED};

    public boolean canProcess(Map params) {
        if (!super.canProcess(params)) {
            return false;
        }
        return ((String)params.get("dbtype")).equalsIgnoreCase("mysql");
    }

    public DataStore createDataStore(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        Integer maxConn = (Integer)MAXCONN.lookUp(params);
        Integer minConn = (Integer)MINCONN.lookUp(params);
        Boolean validateConn = (Boolean)VALIDATECONN.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        Boolean wkbEnabled = (Boolean)WKBENABLED.lookUp(params);
        if (!this.canProcess(params)) {
            LOGGER.warning("Can not process : " + params);
            throw new IOException("The parameteres map isn't correct!!");
        }
        boolean validate = validateConn != null && validateConn != false;
        int maxActive = maxConn != null ? maxConn : 10;
        int maxIdle = minConn != null ? minConn : 4;
        ManageableDataSource ds = MySQLDataStoreFactory.getDefaultDataSource(host, user, passwd, port, database, maxActive, maxIdle, validate);
        MySQLDataStore store = namespace != null ? new MySQLDataStore((DataSource)ds, null, namespace) : new MySQLDataStore((DataSource)ds);
        if (wkbEnabled != null) {
            store.setWKBEnabled(wkbEnabled);
        }
        return store;
    }

    public static ManageableDataSource getDefaultDataSource(String host, String user, String passwd, int port, String database, int maxActive, int minIdle, boolean validate) throws DataSourceException {
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
        String driver = DRIVER_CLASS;
        return DataSourceUtil.buildDefaultDataSource((String)url, (String)driver, (String)user, (String)passwd, (int)maxActive, (int)minIdle, (String)(validate ? "select version()" : null), (boolean)false, (int)0);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("MySQL cannot create a new Database");
    }

    public String getDisplayName() {
        return "MySQL";
    }

    public String getDescription() {
        return "MySQL Database";
    }

    public boolean isAvailable() {
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.warning("MySQL data sources are not available: " + cnfe.getMessage());
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DBTYPE, HOST, PORT, DATABASE, USER, PASSWD, MAXCONN, MINCONN, VALIDATECONN, NAMESPACE};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

