/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.GridRange2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CroppedCoverage2D
extends GridCoverage2D {
    private static final long serialVersionUID = -501742139906901754L;
    private static final PrecisionModel pm;
    private static final GeometryFactory gf;
    public static final double EPS = 0.001;

    private CroppedCoverage2D(InternationalString name, PlanarImage sourceRaster, GridGeometry2D croppedGeometry, GridCoverage2D source, int actionTaken, java.awt.Polygon rasterSpaceROI, Hints hints) {
        super(name.toString(), sourceRaster, croppedGeometry, actionTaken == 1 ? null : (GridSampleDimension[])source.getSampleDimensions().clone(), new GridCoverage[]{source}, rasterSpaceROI != null ? Collections.singletonMap("GC_ROI", rasterSpaceROI) : null, hints);
    }

    static GridCoverage2D create(ParameterValueGroup parameters, Hints hints, GridCoverage2D sourceCoverage, AffineTransform sourceGridToWorldTransform, double scaleFactor) {
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        Envelope2D sourceEnvelope = sourceCoverage.getEnvelope2D();
        GridGeometry2D sourceGridGeometry = sourceCoverage.getGridGeometry();
        GridRange2D sourceGridRange = sourceGridGeometry.getGridRange2D();
        boolean isSimpleTransform = CoverageUtilities.isSimpleGridToWorldTransform(sourceGridToWorldTransform, 0.001);
        RenderingHints targetHints = CroppedCoverage2D.prepareHints(hints, sourceImage);
        int actionTaken = 0;
        ImageLayout layout = CroppedCoverage2D.initLayout(sourceImage, targetHints);
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        JAI processor = OperationJAI.getJAI(targetHints);
        boolean useProvidedProcessor = !processor.equals(JAI.getDefaultInstance());
        try {
            GeneralEnvelope cropEnvelope = (GeneralEnvelope)parameters.parameter("Envelope").getValue();
            if (cropEnvelope.isEmpty()) {
                throw new CannotCropException(Errors.format((int)187));
            }
            if (cropEnvelope.equals(sourceEnvelope, scaleFactor / 2.0, false)) {
                return sourceCoverage;
            }
            AffineTransform sourceWorldToGridTransform = sourceGridToWorldTransform.createInverse();
            Rectangle2D finalRasterAreaDouble = XAffineTransform.transform(sourceWorldToGridTransform, cropEnvelope.toRectangle2D(), null);
            Rectangle finalRasterArea = finalRasterAreaDouble.getBounds();
            Rectangle.intersect(finalRasterArea, sourceGridRange, finalRasterArea);
            if (finalRasterArea.isEmpty()) {
                throw new CannotCropException(Errors.format((int)187));
            }
            if (finalRasterArea.equals(sourceGridRange) && isSimpleTransform) {
                return sourceCoverage;
            }
            double minX = finalRasterArea.getMinX();
            double minY = finalRasterArea.getMinY();
            double width = finalRasterArea.getWidth();
            double height = finalRasterArea.getHeight();
            ParameterBlock pbj = new ParameterBlock();
            pbj.addSource(sourceImage);
            java.awt.Polygon rasterSpaceROI = null;
            String operatioName = null;
            if (!isSimpleTransform) {
                Rectangle2D rect = cropEnvelope.toRectangle2D();
                Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMinX(), rect.getMinY())};
                LinearRing ring = gf.createLinearRing(coord);
                Polygon modelSpaceROI = new Polygon(ring, null, gf);
                assert (modelSpaceROI.getEnvelopeInternal().equals(new ReferencedEnvelope(rect, cropEnvelope.getCoordinateReferenceSystem())));
                ArrayList<Point2D> points = new ArrayList<Point2D>(5);
                rasterSpaceROI = FeatureUtilities.convertPolygonToPointArray(modelSpaceROI, ProjectiveTransform.create(sourceWorldToGridTransform), points);
                if ((rasterSpaceROI == null || rasterSpaceROI.getBounds().isEmpty()) && finalRasterArea.isEmpty()) {
                    throw new CannotCropException(Errors.format((int)187));
                }
                boolean doMosaic = CroppedCoverage2D.decideJAIOperation(parameters, rasterSpaceROI.getBounds2D(), points);
                if (doMosaic) {
                    assert (!isSimpleTransform);
                    ROIShape roi = new ROIShape((Shape)rasterSpaceROI);
                    pbj.add(MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
                    pbj.add(null);
                    pbj.add(new ROI[]{roi});
                    pbj.add(null);
                    pbj.add(CoverageUtilities.getBackgroundValues(sourceCoverage));
                    Rectangle bounds = roi.getBounds2D().getBounds();
                    Rectangle.intersect(bounds, sourceGridRange, bounds);
                    if (bounds.isEmpty()) {
                        throw new CannotCropException(Errors.format((int)187));
                    }
                    if (bounds.getBounds().equals(sourceGridRange) && isSimpleTransform) {
                        return sourceCoverage;
                    }
                    Rectangle boundsInt = bounds.getBounds();
                    layout.setMinX(boundsInt.x);
                    layout.setWidth(boundsInt.width);
                    layout.setMinY(boundsInt.y);
                    layout.setHeight(boundsInt.height);
                    operatioName = "Mosaic";
                }
            }
            if (operatioName == null) {
                pbj.add((float)minX);
                pbj.add((float)minY);
                pbj.add((float)width);
                pbj.add((float)height);
                operatioName = "Crop";
            }
            RenderedOp croppedImage = !useProvidedProcessor ? JAI.create(operatioName, (ParameterBlock)pbj, (RenderingHints)targetHints) : processor.createNS(operatioName, pbj, targetHints);
            return new CroppedCoverage2D(sourceCoverage.getName(), (PlanarImage)croppedImage, new GridGeometry2D(new GridEnvelope2D(croppedImage.getBounds()), (MathTransform)sourceGridGeometry.getGridToCRS2D(PixelOrientation.CENTER), sourceCoverage.getCoordinateReferenceSystem()), sourceCoverage, actionTaken, rasterSpaceROI, hints);
        }
        catch (TransformException e) {
            throw new CannotCropException(Errors.format((int)187), e);
        }
        catch (NoninvertibleTransformException e) {
            throw new CannotCropException(Errors.format((int)187), e);
        }
    }

    private static RenderingHints prepareHints(Hints hints, RenderedImage sourceImage) {
        RenderingHints targetHints = ImageUtilities.getRenderingHints(sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(null);
        }
        if (hints != null) {
            targetHints.add((RenderingHints)hints);
        }
        return targetHints;
    }

    private static ImageLayout initLayout(RenderedImage sourceImage, RenderingHints hints) {
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        return layout;
    }

    private static boolean decideJAIOperation(ParameterValueGroup parameters, Rectangle2D finalGridRange, List<Point2D> points) throws InvalidParameterTypeException, ParameterNotFoundException {
        double cropArea = finalGridRange.getWidth() * finalGridRange.getHeight();
        double roiArea = Math.abs(Crop.area(points.toArray(new Point2D[0])));
        double roiOpt = parameters.parameter("ROITolerance").doubleValue();
        boolean doMosaic = roiOpt * cropArea > roiArea;
        return doMosaic;
    }

    static {
        Hints defaultHints = GeoTools.getDefaultHints();
        Object o = defaultHints.get((Object)Hints.JTS_PRECISION_MODEL);
        pm = o != null ? (PrecisionModel)o : new PrecisionModel();
        gf = new GeometryFactory(pm, 0);
    }
}

