/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class FilterToSQL
implements FilterVisitor,
ExpressionVisitor {
    protected static final String IO_ERROR = "io problem writing filter";
    protected FilterCapabilities capabilities = null;
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private String sqlNameEscape = "";
    protected Writer out;
    protected FIDMapper mapper;
    protected SimpleFeatureType featureType;
    protected boolean encodingFunction = false;

    public FilterToSQL() {
    }

    public FilterToSQL(Writer out) {
        this.out = out;
    }

    public void setWriter(Writer out) {
        this.out = out;
    }

    public void encode(Filter filter) throws FilterToSQLException {
        if (this.out == null) {
            throw new FilterToSQLException("Can't encode to a null writer.");
        }
        if (this.getCapabilities().fullySupports(filter)) {
            try {
                this.out.write("WHERE ");
                filter.accept((FilterVisitor)this, null);
            }
            catch (IOException ioe) {
                LOGGER.warning("Unable to export filter" + ioe);
                throw new FilterToSQLException("Problem writing filter: ", ioe);
            }
        } else {
            throw new FilterToSQLException("Filter type not supported");
        }
    }

    public String encodeToString(Filter filter) throws FilterToSQLException {
        StringWriter out = new StringWriter();
        this.out = out;
        this.encode(filter);
        return out.getBuffer().toString();
    }

    public void encode(Expression expression) throws FilterToSQLException {
        if (this.out == null) {
            throw new FilterToSQLException("Can't encode to a null writer.");
        }
        expression.accept((ExpressionVisitor)this, null);
    }

    public String encodeToString(Expression expression) throws FilterToSQLException {
        StringWriter out = new StringWriter();
        this.out = out;
        this.encode(expression);
        return out.getBuffer().toString();
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public void setFIDMapper(FIDMapper mapper) {
        this.mapper = mapper;
    }

    public FIDMapper getFIDMapper() {
        return this.mapper;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        capabilities.addType(PropertyIsNull.class);
        capabilities.addType(PropertyIsBetween.class);
        capabilities.addType(Id.class);
        capabilities.addType(IncludeFilter.class);
        capabilities.addType(ExcludeFilter.class);
        return capabilities;
    }

    public final synchronized FilterCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.createFilterCapabilities();
        }
        return this.capabilities;
    }

    public void setCapabilities(FilterCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        try {
            this.out.write("0 = 1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        try {
            this.out.write("1 = 1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyIsBetween");
        Expression expr = filter.getExpression();
        Expression lowerbounds = filter.getLowerBoundary();
        Expression upperbounds = filter.getUpperBoundary();
        AttributeDescriptor attType = (AttributeDescriptor)expr.evaluate((Object)this.featureType);
        Class context = attType != null ? attType.getType().getBinding() : String.class;
        try {
            expr.accept((ExpressionVisitor)this, extraData);
            this.out.write(" BETWEEN ");
            lowerbounds.accept((ExpressionVisitor)this, (Object)context);
            this.out.write(" AND ");
            upperbounds.accept((ExpressionVisitor)this, (Object)context);
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        char esc = filter.getEscape().charAt(0);
        char multi = filter.getWildCard().charAt(0);
        char single = filter.getSingleChar().charAt(0);
        boolean matchCase = filter.isMatchingCase();
        String literal = filter.getLiteral();
        Expression att = filter.getExpression();
        AttributeDescriptor ad = (AttributeDescriptor)att.evaluate((Object)this.featureType);
        if (ad != null && Date.class.isAssignableFrom(ad.getType().getBinding())) {
            literal = literal + multi;
        }
        String pattern = LikeFilterImpl.convertToSQL92((char)esc, (char)multi, (char)single, (boolean)matchCase, (String)literal);
        try {
            if (!matchCase) {
                this.out.write(" UPPER(");
            }
            att.accept((ExpressionVisitor)this, extraData);
            if (!matchCase) {
                this.out.write(") LIKE '");
            } else {
                this.out.write(" LIKE '");
            }
            this.out.write(pattern);
            this.out.write("' ");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(And filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"AND");
    }

    public Object visit(Not filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"NOT");
    }

    public Object visit(Or filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"OR");
    }

    protected Object visit(BinaryLogicOperator filter, Object extraData) {
        LOGGER.finer("exporting LogicFilter");
        String type = (String)extraData;
        try {
            Iterator list = filter.getChildren().iterator();
            if (filter instanceof Not) {
                this.out.write(type + " (");
                ((Filter)list.next()).accept((FilterVisitor)this, extraData);
                this.out.write(")");
            } else {
                this.out.write("(");
                while (list.hasNext()) {
                    ((Filter)list.next()).accept((FilterVisitor)this, extraData);
                    if (!list.hasNext()) continue;
                    this.out.write(" " + type + " ");
                }
                this.out.write(")");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">");
        return extraData;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<");
        return extraData;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<=");
        return extraData;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "!=");
        return extraData;
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData) throws RuntimeException {
        AttributeDescriptor attType;
        LOGGER.finer("exporting SQL ComparisonFilter");
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        Class leftContext = null;
        Class rightContext = null;
        if (left instanceof PropertyName && (attType = (AttributeDescriptor)left.evaluate((Object)this.featureType)) != null) {
            rightContext = attType.getType().getBinding();
        }
        if (right instanceof PropertyName && (attType = (AttributeDescriptor)right.evaluate((Object)this.featureType)) != null) {
            leftContext = attType.getType().getBinding();
        }
        boolean matchCase = true;
        if (!filter.isMatchingCase() && (filter instanceof PropertyIsEqualTo || filter instanceof PropertyIsNotEqualTo) && (String.class.equals(leftContext) || String.class.equals((Object)rightContext))) {
            matchCase = false;
        }
        String type = (String)extraData;
        try {
            if (matchCase) {
                left.accept((ExpressionVisitor)this, (Object)leftContext);
                this.out.write(" " + type + " ");
                right.accept((ExpressionVisitor)this, (Object)rightContext);
            } else {
                FunctionImpl f = new FunctionImpl();
                f.setName("lower");
                f.setParameters(Arrays.asList(left));
                f.accept((ExpressionVisitor)this, Arrays.asList(leftContext));
                this.out.write(" " + type + " ");
                f.setParameters(Arrays.asList(right));
                f.accept((ExpressionVisitor)this, Arrays.asList(rightContext));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    public Object visit(PropertyIsNull filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting NullFilter");
        Expression expr = filter.getExpression();
        try {
            expr.accept((ExpressionVisitor)this, extraData);
            this.out.write(" IS NULL ");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(Id filter, Object extraData) {
        if (this.mapper == null) {
            throw new RuntimeException("Must set a fid mapper before trying to encode FIDFilters");
        }
        Set ids = filter.getIdentifiers();
        LOGGER.finer("Exporting FID=" + ids);
        String[] colNames = new String[this.mapper.getColumnCount()];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = this.mapper.getColumnName(i);
        }
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            try {
                Identifier id = (Identifier)i.next();
                Object[] attValues = this.mapper.getPKAttributes(id.toString());
                this.out.write("(");
                for (int j = 0; j < attValues.length; ++j) {
                    this.out.write(this.escapeName(colNames[j]));
                    this.out.write(" = '");
                    this.out.write(attValues[j].toString());
                    this.out.write("'");
                    if (j >= attValues.length - 1) continue;
                    this.out.write(" AND ");
                }
                this.out.write(")");
                if (!i.hasNext()) continue;
                this.out.write(" OR ");
            }
            catch (IOException e) {
                throw new RuntimeException(IO_ERROR, e);
            }
        }
        return extraData;
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData) {
        throw new RuntimeException("Subclasses must implement this method in order to handle geometries");
    }

    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    public Object visit(PropertyName expression, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyName");
        try {
            AttributeDescriptor attribute = null;
            try {
                attribute = (AttributeDescriptor)expression.evaluate((Object)this.featureType);
            }
            catch (Exception e) {
                String msg = "Error occured mapping " + expression + " to feature type";
                LOGGER.log(Level.WARNING, msg, e);
            }
            if (attribute != null) {
                this.out.write(this.escapeName(attribute.getLocalName()));
            } else {
                this.out.write(this.escapeName(expression.getPropertyName()));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing attribute exp", ioe);
        }
        return extraData;
    }

    public Object visit(Literal expression, Object context) throws RuntimeException {
        LOGGER.finer("exporting LiteralExpression");
        Class target = null;
        if (context instanceof Class) {
            target = (Class)context;
        }
        try {
            Object literal = this.evaluateLiteral(expression, target);
            if (literal instanceof Geometry) {
                this.visitLiteralGeometry(CommonFactoryFinder.getFilterFactory(null).literal(literal));
            } else {
                this.writeLiteral(literal);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO problems writing literal", e);
        }
        return context;
    }

    protected Object evaluateLiteral(Literal expression, Class target) {
        Object literal = null;
        if (target != null && !Number.class.isAssignableFrom(target)) {
            literal = expression.evaluate(null, target);
        }
        if (literal == null) {
            literal = expression.evaluate(null);
        }
        if (literal == null) {
            literal = expression.getValue();
        }
        return literal;
    }

    protected void writeLiteral(Object literal) throws IOException {
        if (literal == null) {
            this.out.write("NULL");
        } else if (literal instanceof Number || literal instanceof Boolean) {
            this.out.write(String.valueOf(literal));
        } else {
            String encoding = (String)Converters.convert((Object)literal, String.class, null);
            if (encoding == null) {
                encoding = literal.toString();
            }
            String escaped = encoding.replaceAll("'", "''");
            this.out.write("'" + escaped + "'");
        }
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        throw new RuntimeException("Subclasses must implement this method in order to handle geometries");
    }

    public Object visit(Add expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "+", extraData);
    }

    public Object visit(Divide expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "/", extraData);
    }

    public Object visit(Multiply expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "*", extraData);
    }

    public Object visit(Subtract expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "-", extraData);
    }

    protected Object visit(BinaryExpression expression, String operator, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting Expression Math");
        try {
            expression.getExpression1().accept((ExpressionVisitor)this, extraData);
            this.out.write(" " + operator + " ");
            expression.getExpression2().accept((ExpressionVisitor)this, extraData);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing expression", ioe);
        }
        return extraData;
    }

    public Object visit(Function function, Object extraData) throws RuntimeException {
        try {
            List parameters = function.getParameters();
            List contexts = null;
            if (extraData instanceof List && ((List)extraData).size() == parameters.size()) {
                contexts = (List)extraData;
            }
            this.encodingFunction = true;
            this.out.write(function.getName());
            this.out.write("(");
            for (int i = 0; i < parameters.size(); ++i) {
                Expression e = (Expression)parameters.get(i);
                Object context = contexts != null ? contexts.get(i) : extraData;
                e.accept((ExpressionVisitor)this, context);
                if (i >= parameters.size() - 1) continue;
                this.out.write(",");
            }
            this.out.write(")");
            this.encodingFunction = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    public Object visit(NilExpression expression, Object extraData) {
        try {
            this.out.write(" ");
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing expression", ioe);
        }
        return extraData;
    }

    public void setSqlNameEscape(String escape) {
        this.sqlNameEscape = escape;
    }

    public String escapeName(String name) {
        return this.sqlNameEscape + name + this.sqlNameEscape;
    }
}

