/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.wms.util.WMSRequests;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.xml.sax.ContentHandler;

public class KMLNetworkLinkTransformer
extends TransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    boolean encodeAsRegion = false;

    public Translator createTranslator(ContentHandler handler) {
        return new KMLNetworkLinkTranslator(handler);
    }

    public void setEncodeAsRegion(boolean encodeAsRegion) {
        this.encodeAsRegion = encodeAsRegion;
    }

    class KMLNetworkLinkTranslator
    extends TransformerBase.TranslatorSupport {
        public KMLNetworkLinkTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            GetMapRequest request = (GetMapRequest)((Object)o);
            this.start("kml");
            this.start("Folder");
            if (KMLNetworkLinkTransformer.this.encodeAsRegion) {
                this.encodeAsSuperOverlay(request);
            } else {
                this.encodeAsOverlay(request);
            }
            this.encodeLookAt(request);
            this.end("Folder");
            this.end("kml");
        }

        protected void encodeAsSuperOverlay(GetMapRequest request) {
            MapLayerInfo[] layers = request.getLayers();
            List styles = request.getStyles();
            for (int i = 0; i < layers.length; ++i) {
                this.start("NetworkLink");
                this.element("name", layers[i].getName());
                this.element("open", "1");
                this.element("visibility", "1");
                this.start("Region");
                Envelope bbox = request.getBbox();
                this.start("LatLonAltBox");
                this.element("north", "" + bbox.getMaxY());
                this.element("south", "" + bbox.getMinY());
                this.element("east", "" + bbox.getMaxX());
                this.element("west", "" + bbox.getMinX());
                this.end("LatLonAltBox");
                this.start("Lod");
                this.element("minLodPixels", "256");
                this.element("maxLodPixels", "-1");
                this.end("Lod");
                this.end("Region");
                this.start("Link");
                String style = i < styles.size() ? ((Style)styles.get(i)).getName() : null;
                String href = WMSRequests.getGetMapUrl(request, layers[i].getName(), i, style, null, null);
                this.start("href");
                this.cdata(href);
                this.end("href");
                this.end("Link");
                this.end("NetworkLink");
            }
        }

        protected void encodeAsOverlay(GetMapRequest request) {
            MapLayerInfo[] layers = request.getLayers();
            List styles = request.getStyles();
            for (int i = 0; i < layers.length; ++i) {
                this.start("NetworkLink");
                this.element("name", layers[i].getName());
                this.element("open", "1");
                this.element("visibility", "1");
                this.start("Url");
                request.setBbox(null);
                String style = i < styles.size() ? ((Style)styles.get(i)).getName() : null;
                String href = WMSRequests.getGetMapUrl(request, layers[i].getName(), i, style, null, null);
                this.start("href");
                this.cdata(href);
                this.end("href");
                this.element("viewRefreshMode", "onStop");
                this.element("viewRefreshTime", "1");
                this.end("Url");
                this.end("NetworkLink");
            }
        }

        private void encodeLookAt(GetMapRequest request) {
            Envelope e = new Envelope();
            e.setToNull();
            for (int i = 0; i < request.getLayers().length; ++i) {
                MapLayerInfo layer = request.getLayers()[i];
                Envelope b = null;
                try {
                    b = request.getLayers()[i].getLatLongBoundingBox();
                }
                catch (IOException e1) {
                    LOGGER.warning("Unable to calculate bounds for " + layer.getName());
                    continue;
                }
                if (e.isNull()) {
                    e.init(b);
                    continue;
                }
                e.expandToInclude(b);
            }
            if (e.isNull()) {
                return;
            }
            double lon1 = e.getMinX();
            double lat1 = e.getMinY();
            double lon2 = e.getMaxX();
            double lat2 = e.getMaxY();
            double R_EARTH = 6371000.0;
            double VIEWER_WIDTH = 0.3839724354387525;
            double[] p1 = this.getRect(lon1, lat1, R_EARTH);
            double[] p2 = this.getRect(lon2, lat2, R_EARTH);
            double[] midpoint = new double[]{(p1[0] + p2[0]) / 2.0, (p1[1] + p2[1]) / 2.0, (p1[2] + p2[2]) / 2.0};
            midpoint = this.getGeographic(midpoint[0], midpoint[1], midpoint[2]);
            double distance = this.distance(p1, p2);
            double height = distance / (2.0 * Math.tan(VIEWER_WIDTH));
            LOGGER.fine("lat1: " + lat1 + "; lon1: " + lon1);
            LOGGER.fine("lat2: " + lat2 + "; lon2: " + lon2);
            LOGGER.fine("latmid: " + midpoint[1] + "; lonmid: " + midpoint[0]);
            this.start("LookAt");
            this.element("longitude", "" + midpoint[0]);
            this.element("latitude", "" + midpoint[1]);
            this.element("altitude", "0");
            this.element("range", "" + distance);
            this.element("tilt", "0");
            this.element("heading", "0");
            this.element("altitudeMode", "clampToGround");
            this.end("LookAt");
        }

        private double[] getRect(double lat, double lon, double radius) {
            double theta = (90.0 - lat) * Math.PI / 180.0;
            double phi = (90.0 - lon) * Math.PI / 180.0;
            double x = radius * Math.sin(phi) * Math.cos(theta);
            double y = radius * Math.sin(phi) * Math.sin(theta);
            double z = radius * Math.cos(phi);
            return new double[]{x, y, z};
        }

        private double[] getGeographic(double x, double y, double z) {
            double radius = this.distance(new double[]{x, y, z}, new double[]{0.0, 0.0, 0.0});
            double theta = Math.atan2(Math.sqrt(x * x + y * y), z);
            double phi = Math.atan2(y, x);
            double lat = 90.0 - theta * 180.0 / Math.PI;
            double lon = 90.0 - phi * 180.0 / Math.PI;
            return new double[]{lon > 180.0 ? lon - 360.0 : lon, lat, radius};
        }

        private double distance(double[] p1, double[] p2) {
            double dx = p1[0] - p2[0];
            double dy = p1[1] - p2[1];
            double dz = p1[2] - p2[2];
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
    }
}

