/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.jpeg;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public final class JPEGMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)JPEGMapProducer.class.toString());
    static final String MIME_TYPE = "image/jpeg";
    private Boolean JPEGNativeAcc;
    private boolean hasJAIWriter;

    public JPEGMapProducer(WMS wms) {
        super(MIME_TYPE, wms);
        this.JPEGNativeAcc = wms.getGeoServer().getJPEGNativeAcceleration();
        try {
            Class.forName("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter");
            this.hasJAIWriter = true;
        }
        catch (ClassNotFoundException e) {
            this.hasJAIWriter = false;
        }
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        transparent = false;
        palette = null;
        return super.prepareImage(width, height, palette, transparent);
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to write a JPEG image.");
        }
        WritableRaster raster = (WritableRaster)image.getData();
        if (image instanceof BufferedImage) {
            BufferedImage im = (BufferedImage)image;
            im.flush();
            im = null;
        } else {
            PlanarImage.wrapRenderedImage((RenderedImage)image).dispose();
        }
        BufferedImage finalImage = new BufferedImage(image.getColorModel(), raster.createWritableTranslatedChild(0, 0), image.getColorModel().isAlphaPremultiplied(), null);
        new ImageWorker((RenderedImage)finalImage).writeJPEG((Object)outStream, "JPEG", 0.75f, this.JPEGNativeAcc.booleanValue());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing a JPEG done!!!");
        }
    }

    public String getContentDisposition() {
        return null;
    }
}

