/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.TransformedDirectPosition;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.featureInfo.GetFeatureInfoDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureInfoResponse
extends GetFeatureInfoDelegate {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.featureinfo");
    protected List supportedFormats = null;
    protected List results;
    protected List metas;
    protected String format = null;

    public String getContentEncoding() {
        return null;
    }

    public abstract void writeTo(OutputStream var1) throws ServiceException, IOException;

    @Override
    public List getSupportedFormats() {
        return this.supportedFormats;
    }

    public void abort(GeoServer gs) {
    }

    public String getContentType(GeoServer gs) {
        if (this.format == null) {
            throw new IllegalStateException("Content type unknown since execute() has not been called yet");
        }
        return this.format + ";charset=" + gs.getCharSet().name();
    }

    @Override
    protected void execute(MapLayerInfo[] requestedLayers, Style[] styles, Filter[] filters, int x, int y, int buffer) throws WmsException {
        GetFeatureInfoRequest request = this.getRequest();
        this.format = request.getInfoFormat();
        GetMapRequest getMapReq = request.getGetMapRequest();
        CoordinateReferenceSystem requestedCRS = getMapReq.getCrs();
        int width = getMapReq.getWidth();
        int height = getMapReq.getHeight();
        ReferencedEnvelope bbox = new ReferencedEnvelope(getMapReq.getBbox(), getMapReq.getCrs());
        double scaleDenominator = RendererUtilities.calculateOGCScale((ReferencedEnvelope)bbox, (int)width, new HashMap());
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        int layerCount = requestedLayers.length;
        this.results = new ArrayList(layerCount);
        this.metas = new ArrayList(layerCount);
        try {
            for (int i = 0; i < layerCount; ++i) {
                List<Rule> rules = this.getActiveRules(styles[i], scaleDenominator);
                if (rules.size() == 0) continue;
                if (requestedLayers[i].getType() == Data.TYPE_VECTOR.intValue()) {
                    double radius;
                    FeatureTypeInfo finfo = requestedLayers[i].getFeature();
                    CoordinateReferenceSystem dataCRS = finfo.getFeatureType().getCoordinateReferenceSystem();
                    if (buffer <= 0) {
                        MetaBufferEstimator estimator = new MetaBufferEstimator();
                        for (Rule rule : rules) {
                            rule.accept((StyleVisitor)estimator);
                        }
                        radius = (double)estimator.getBuffer() < 2.0 || !estimator.isEstimateAccurate() ? 2.0 : (double)estimator.getBuffer() / 2.0;
                    } else {
                        radius = buffer;
                    }
                    int maxRadius = request.getWMS().getMaxBuffer();
                    if (maxRadius > 0 && radius > (double)maxRadius) {
                        radius = maxRadius;
                    }
                    Polygon pixelRect = this.getEnvelopeFilter(x, y, width, height, (Envelope)bbox, radius);
                    if (requestedCRS != null && !CRS.equalsIgnoreMetadata((Object)dataCRS, (Object)requestedCRS)) {
                        try {
                            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)requestedCRS, (CoordinateReferenceSystem)dataCRS, (boolean)true);
                            pixelRect = (Polygon)JTS.transform((Geometry)pixelRect, (MathTransform)transform);
                        }
                        catch (MismatchedDimensionException e) {
                            LOGGER.severe(e.getLocalizedMessage());
                        }
                        catch (TransformException e) {
                            LOGGER.severe(e.getLocalizedMessage());
                        }
                        catch (FactoryException e) {
                            LOGGER.severe(e.getLocalizedMessage());
                        }
                    }
                    Intersects getFInfoFilter = null;
                    try {
                        getFInfoFilter = ff.intersects((Expression)ff.property(finfo.getFeatureType().getGeometryDescriptor().getLocalName()), (Expression)ff.literal((Object)pixelRect));
                    }
                    catch (IllegalFilterException e) {
                        throw new WmsException(null, "Internal error : " + e.getMessage());
                    }
                    if (filters[i] != null) {
                        getFInfoFilter = ff.and((Filter)getFInfoFilter, filters[i]);
                    }
                    IncludeFilter postFilter = Filter.INCLUDE;
                    Filter rulesFilters = this.buildRulesFilter((FilterFactory)ff, rules);
                    if (!(rulesFilters instanceof Or) || rulesFilters instanceof Or && ((Or)rulesFilters).getChildren().size() <= 20) {
                        getFInfoFilter = ff.and((Filter)getFInfoFilter, rulesFilters);
                    } else {
                        postFilter = rulesFilters;
                    }
                    DefaultQuery q = new DefaultQuery(finfo.getTypeName(), null, (Filter)getFInfoFilter, request.getFeatureCount(), Query.ALL_NAMES, null);
                    FeatureCollection match = finfo.getFeatureSource().getFeatures((Query)q);
                    if (!Filter.INCLUDE.equals(postFilter)) {
                        match = new FilteringFeatureCollection(match, (Filter)postFilter);
                    }
                    this.results.add(match);
                    this.metas.add(requestedLayers[i]);
                    continue;
                }
                CoverageInfo cinfo = requestedLayers[i].getCoverage();
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)cinfo.getReader();
                ParameterValueGroup params = reader.getFormat().getReadParameters();
                GeneralParameterValue[] parameters = CoverageUtils.getParameters((ParameterValueGroup)params, (Map)requestedLayers[i].getCoverage().getParameters(), (boolean)true);
                GridGeometry2D coverageGeometry = (GridGeometry2D)cinfo.getGrid();
                Coordinate middle = AbstractFeatureInfoResponse.pixelToWorld(x, y, (Envelope)bbox, width, height);
                DirectPosition2D position = new DirectPosition2D(requestedCRS, middle.x, middle.y);
                if (requestedCRS != null) {
                    CoordinateReferenceSystem targetCRS = coverageGeometry.getCoordinateReferenceSystem();
                    TransformedDirectPosition arbitraryToInternal = new TransformedDirectPosition(requestedCRS, targetCRS, new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
                    try {
                        arbitraryToInternal.transform((DirectPosition)position);
                    }
                    catch (TransformException exception) {
                        throw new CannotEvaluateException("Unable to answer the geatfeatureinfo", (Throwable)exception);
                    }
                    position = arbitraryToInternal;
                }
                if (!reader.getOriginalEnvelope().contains((DirectPosition)position)) {
                    throw new CannotEvaluateException("The position at which we should evaluate the coverage does not fall within the coverage's bbox");
                }
                MathTransform worldToGrid = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER).inverse();
                DirectPosition rasterMid = worldToGrid.transform((DirectPosition)position, null);
                Rectangle2D.Double rasterArea = new Rectangle2D.Double();
                rasterArea.setFrameFromCenter(rasterMid.getOrdinate(0), rasterMid.getOrdinate(1), rasterMid.getOrdinate(0) + 10.0, rasterMid.getOrdinate(1) + 10.0);
                Rectangle interegerRasterArea = rasterArea.getBounds();
                XRectangle2D.intersect((Rectangle2D)interegerRasterArea, (Rectangle2D)reader.getOriginalGridRange().toRectangle(), (Rectangle2D)interegerRasterArea);
                if (interegerRasterArea.isEmpty()) {
                    throw new CannotEvaluateException("Unable to evaluate the request coverage " + requestedLayers[i].toString());
                }
                for (int k = 0; k < parameters.length; ++k) {
                    Parameter parameter;
                    if (!(parameters[k] instanceof Parameter) || !(parameter = (Parameter)parameters[k]).getDescriptor().getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
                    parameter.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(interegerRasterArea), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCrs()));
                }
                GridCoverage2D coverage = (GridCoverage2D)reader.read(parameters);
                if (coverage == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Unable to load raster data for this request.");
                    }
                    return;
                }
                try {
                    double[] pixelValues = coverage.evaluate((DirectPosition)position, (double[])null);
                    FeatureCollection<SimpleFeatureType, SimpleFeature> pixel = this.wrapPixelInFeatureCollection(coverage, pixelValues, cinfo.getName());
                    this.metas.add(requestedLayers[i]);
                    this.results.add(pixel);
                    continue;
                }
                catch (PointOutsideCoverageException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new WmsException(null, "Internal error occurred", e);
        }
    }

    private Filter buildRulesFilter(FilterFactory ff, List<Rule> rules) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Rule rule : rules) {
            if (rule.getFilter() == null) {
                return Filter.INCLUDE;
            }
            filters.add(rule.getFilter());
        }
        Or or = ff.or(filters);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        return (Filter)or.accept((FilterVisitor)simplifier, null);
    }

    private List<Rule> getActiveRules(Style style, double scaleDenominator) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (FeatureTypeStyle fts : style.getFeatureTypeStyles()) {
            for (Rule r : fts.rules()) {
                if (!(r.getMinScaleDenominator() <= scaleDenominator) || !(r.getMaxScaleDenominator() > scaleDenominator)) continue;
                result.add(r);
            }
        }
        return result;
    }

    private Polygon getEnvelopeFilter(int x, int y, int width, int height, Envelope bbox, double radius) {
        Coordinate[] coords;
        Coordinate upperLeft = AbstractFeatureInfoResponse.pixelToWorld((double)x - radius, (double)y - radius, bbox, width, height);
        Coordinate lowerRight = AbstractFeatureInfoResponse.pixelToWorld((double)x + radius, (double)y + radius, bbox, width, height);
        coords = new Coordinate[]{upperLeft, new Coordinate(lowerRight.x, upperLeft.y), lowerRight, new Coordinate(upperLeft.x, lowerRight.y), coords[0]};
        GeometryFactory geomFac = new GeometryFactory();
        LinearRing boundary = geomFac.createLinearRing(coords);
        Polygon pixelRect = geomFac.createPolygon(boundary, null);
        return pixelRect;
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> wrapPixelInFeatureCollection(GridCoverage2D coverage, double[] pixelValues, String coverageName) throws SchemaException, IllegalAttributeException {
        SimpleFeatureType gridType;
        int i;
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        try {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setName(coverageName);
            HashSet<String> bandNames = new HashSet<String>();
            for (i = 0; i < sampleDimensions.length; ++i) {
                String name = sampleDimensions[i].getDescription().toString();
                if (bandNames.contains(name)) {
                    name = name + "_Band" + i;
                }
                bandNames.add(name);
                builder.add(name, Double.class);
            }
            gridType = builder.buildFeatureType();
        }
        catch (Exception e) {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setName(coverageName);
            for (i = 0; i < sampleDimensions.length; ++i) {
                builder.add("Band " + (i + 1), Double.class);
            }
            gridType = builder.buildFeatureType();
        }
        Object[] values = new Double[pixelValues.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = new Double(pixelValues[i2]);
        }
        return DataUtilities.collection((SimpleFeature)SimpleFeatureBuilder.build((SimpleFeatureType)gridType, (Object[])values, (String)""));
    }

    private static Coordinate pixelToWorld(double x, double y, Envelope map, double width, double height) {
        AffineTransform at = AbstractFeatureInfoResponse.worldToScreenTransform(map, width, height);
        Point2D result = null;
        try {
            result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        return new Coordinate(result.getX(), result.getY());
    }

    private static AffineTransform worldToScreenTransform(Envelope mapExtent, double width, double height) {
        double scaleX = width / mapExtent.getWidth();
        double scaleY = height / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + height;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        return at;
    }
}

