/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMSExtensions;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.metatile.MetatileMapProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMapResponse
implements Response {
    static final Logger LOGGER = Logging.getLogger((String)GetMapResponse.class.getPackage().getName());
    private static FilterFactory filterFac = CommonFactoryFinder.getFilterFactory(null);
    private GetMapProducer delegate;
    private WMSMapContext map;
    private HashMap responseHeaders;
    String headerContentDisposition;
    private Collection<GetMapProducer> availableProducers;

    public GetMapResponse(Collection<GetMapProducer> availableProducers) {
        if (availableProducers == null) {
            throw new NullPointerException("availableProducers");
        }
        if (availableProducers.size() == 0) {
            throw new IllegalArgumentException("No available map producers provided");
        }
        this.availableProducers = new ArrayList<GetMapProducer>(availableProducers);
        this.responseHeaders = null;
    }

    public HashMap getResponseHeaders() {
        return this.responseHeaders == null ? null : new HashMap(this.responseHeaders);
    }

    public void execute(Request req) throws ServiceException {
        GetMapRequest request = (GetMapRequest)req;
        this.assertMandatory(request);
        String outputFormat = request.getFormat();
        this.delegate = this.getDelegate(outputFormat);
        this.map = new WMSMapContext(request);
        this.delegate.setMapContext(this.map);
        Envelope env = request.getBbox();
        if (MetatileMapProducer.isRequestTiled(request, this.delegate)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Tiled request detected, activating on the fly meta tiler");
            }
            this.delegate = new MetatileMapProducer(request, (RasterMapProducer)this.delegate);
            this.delegate.setMapContext(this.map);
        }
        MapLayerInfo[] layers = request.getLayers();
        Style[] styles = request.getStyles().toArray(new Style[0]);
        Filter[] filters = this.buildLayersFilters(request.getFilter(), layers);
        CoordinateReferenceSystem mapcrs = request.getCrs();
        if (mapcrs != null) {
            this.map.setAreaOfInterest(env, mapcrs);
        } else {
            this.map.setAreaOfInterest(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        this.map.setMapWidth(request.getWidth());
        this.map.setMapHeight(request.getHeight());
        this.map.setBgColor(request.getBgColor());
        this.map.setTransparent(request.isTransparent());
        this.map.setBuffer(request.getBuffer());
        this.map.setPaletteInverter(request.getPalette());
        if (request.getWidth() <= 0 || request.getHeight() <= 0 || this.map.getAreaOfInterest().getLength(0) <= 0.0 || this.map.getAreaOfInterest().getLength(1) <= 0.0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("We are not going to render anything because either the area is null or the dimensions are not positive.");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up map");
        }
        try {
            String contentDisposition;
            boolean cachingPossible = "GET".equals(request.getHttpServletRequest().getMethod());
            String featureVersion = request.getFeatureVersion();
            int maxAge = Integer.MAX_VALUE;
            for (int i = 0; i < layers.length; ++i) {
                DefaultQuery definitionQuery;
                DefaultMapLayer layer;
                FeatureSource source;
                Style layerStyle = styles[i];
                Filter layerFilter = filters[i];
                if (layers[i].getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                    cachingPossible = false;
                    source = layers[i].getRemoteFeatureSource();
                    layer = new DefaultMapLayer(source, layerStyle);
                    layer.setTitle(layers[i].getName());
                    definitionQuery = new DefaultQuery(((SimpleFeatureType)source.getSchema()).getTypeName());
                    definitionQuery.setFilter(layerFilter);
                    definitionQuery.setVersion(featureVersion);
                    int maxFeatures = request.getMaxFeatures() != null ? request.getMaxFeatures() : Integer.MAX_VALUE;
                    definitionQuery.setMaxFeatures(maxFeatures);
                    layer.setQuery((Query)definitionQuery);
                    this.map.addLayer((MapLayer)layer);
                    continue;
                }
                if (layers[i].getType() == MapLayerInfo.TYPE_VECTOR) {
                    if (cachingPossible) {
                        if (layers[i].getFeature().isCachingEnabled()) {
                            int nma = Integer.valueOf(layers[i].getFeature().getCacheMaxAge());
                            if (nma < maxAge) {
                                maxAge = nma;
                            }
                        } else {
                            cachingPossible = false;
                        }
                    }
                    try {
                        source = layers[i].getFeature().getFeatureSource(true);
                    }
                    catch (IOException exp) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, new StringBuffer("Getting feature source: ").append(exp.getMessage()).toString(), exp);
                        }
                        throw new WmsException("Internal error", "", exp);
                    }
                    layer = new DefaultMapLayer(source, layerStyle);
                    layer.setTitle(layers[i].getName());
                    definitionQuery = new DefaultQuery(((SimpleFeatureType)source.getSchema()).getTypeName());
                    definitionQuery.setVersion(featureVersion);
                    definitionQuery.setFilter(layerFilter);
                    Integer startIndex = request.getStartIndex();
                    if (startIndex != null) {
                        QueryCapabilities queryCapabilities = source.getQueryCapabilities();
                        if (queryCapabilities.isOffsetSupported()) {
                            definitionQuery.setStartIndex(startIndex);
                        } else {
                            throw new WmsException("startIndex is not supported for the " + layers[i].getName() + " layer");
                        }
                    }
                    int maxFeatures = request.getMaxFeatures() != null ? request.getMaxFeatures() : Integer.MAX_VALUE;
                    definitionQuery.setMaxFeatures(maxFeatures);
                    layer.setQuery((Query)definitionQuery);
                    this.map.addLayer((MapLayer)layer);
                    continue;
                }
                if (layers[i].getType() != MapLayerInfo.TYPE_RASTER) continue;
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)layers[i].getCoverage().getReader();
                if (reader != null) {
                    try {
                        ParameterValue time = reader.getFormat().getReadParameters().parameter("TIME");
                        if (time != null && request.getTime() != null) {
                            time.setValue((Object)request.getTime());
                        }
                    }
                    catch (ParameterNotFoundException p) {
                        // empty catch block
                    }
                    try {
                        ParameterValue elevation = reader.getFormat().getReadParameters().parameter("ELEVATION");
                        if (elevation != null && request.getElevation() != null) {
                            elevation.setValue(request.getElevation().intValue());
                        }
                    }
                    catch (ParameterNotFoundException p) {
                        // empty catch block
                    }
                    try {
                        ParameterValueGroup params = reader.getFormat().getReadParameters();
                        layer = new DefaultMapLayer(FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, (GeneralParameterValue[])CoverageUtils.getParameters((ParameterValueGroup)params, (Map)layers[i].getCoverage().getParameters())), layerStyle);
                        layer.setTitle(layers[i].getName());
                        layer.setQuery(Query.ALL);
                        this.map.addLayer((MapLayer)layer);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, new StringBuffer("Wrapping GC in feature source: ").append(e.getLocalizedMessage()).toString(), e);
                        }
                        throw new WmsException(null, new StringBuffer("Internal error : unable to get reader for this coverage layer ").append(layers[i].toString()).toString());
                    }
                }
                throw new WmsException(null, new StringBuffer("Internal error : unable to get reader for this coverage layer ").append(layers[i].toString()).toString());
            }
            this.delegate.produceMap();
            if (cachingPossible) {
                if (this.responseHeaders == null) {
                    this.responseHeaders = new HashMap();
                }
                this.responseHeaders.put("Cache-Control", "max-age=" + maxAge + ", must-revalidate");
                Date expires = new Date();
                expires.setTime(expires.getTime() + (long)(maxAge * 1000));
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.responseHeaders.put("Expires", format.format(expires));
            }
            if ((contentDisposition = this.delegate.getContentDisposition()) != null) {
                this.headerContentDisposition = contentDisposition;
            }
        }
        catch (Exception e) {
            this.clearMapContext();
            throw new WmsException(e, "Internal error ", "");
        }
    }

    private void assertMandatory(GetMapRequest request) throws ServiceException {
        if (0 >= request.getWidth() || 0 >= request.getHeight()) {
            throw new ServiceException("Missing or invalid requested map size. Parameters WIDTH and HEIGHT shall be present and be integers > 0. Got WIDTH=" + request.getWidth() + ", HEIGHT=" + request.getHeight(), "MissingOrInvalidParameter");
        }
        if (request.getLayers().length == 0) {
            throw new ServiceException("No layers have been requested", "LayerNotDefined");
        }
        if (request.getStyles().size() == 0) {
            throw new ServiceException("No styles have been requested", "StyleNotDefined");
        }
        if (request.getFormat() == null) {
            throw new ServiceException("No output map format requested", "InvalidFormat");
        }
        Envelope env = request.getBbox();
        if (env == null) {
            throw new WmsException("GetMap requests must include a BBOX parameter.", "MissingBBox");
        }
        if (env.isNull() || env.getWidth() <= 0.0 || env.getHeight() <= 0.0) {
            throw new WmsException(new StringBuffer("The request bounding box has zero area: ").append(env).toString(), "InvalidBBox");
        }
    }

    private Filter[] buildLayersFilters(List<Filter> requestFilters, MapLayerInfo[] layers) {
        int nLayers = layers.length;
        if (requestFilters == null || requestFilters.size() == 0) {
            requestFilters = Collections.nCopies(layers.length, Filter.INCLUDE);
        } else if (requestFilters.size() != nLayers) {
            throw new IllegalArgumentException("requested filters and number of layers do not match");
        }
        Filter[] combinedList = new Filter[nLayers];
        for (int i = 0; i < nLayers; ++i) {
            MapLayerInfo layer = layers[i];
            Filter userRequestedFilter = requestFilters.get(i);
            if (layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                combinedList[i] = userRequestedFilter;
                continue;
            }
            if (layer.getType() == MapLayerInfo.TYPE_RASTER) continue;
            Filter layerDefinitionFilter = layer.getFeature().getDefinitionQuery();
            if (layerDefinitionFilter == null) {
                layerDefinitionFilter = Filter.INCLUDE;
            }
            And combined = filterFac.and(layerDefinitionFilter, userRequestedFilter);
            combinedList[i] = combined;
        }
        return combinedList;
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.delegate == null) {
            throw new IllegalStateException("No request has been processed");
        }
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("returning content encoding null");
        }
        return null;
    }

    public void abort(Service gs) {
        if (this.delegate != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("asking delegate for aborting the process");
            }
            this.delegate.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            if (this.delegate == null) {
                throw new IllegalStateException("No GetMapDelegate is setted, make sure you have called execute and it has succeed");
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer("asking delegate for write to ").append(out).toString());
            }
            this.delegate.writeTo(out);
        }
        finally {
            this.clearMapContext();
        }
    }

    void clearMapContext() {
        block3: {
            try {
                if (this.map != null && this.map.getLayerCount() > 0) {
                    this.map.clearLayerList();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, new StringBuffer("Getting feature source: ").append(e.getMessage()).toString(), e);
            }
        }
    }

    private GetMapProducer getDelegate(String outputFormat) throws WmsException {
        GetMapProducer producer = WMSExtensions.findMapProducer(outputFormat, this.availableProducers);
        if (producer == null) {
            WmsException e = new WmsException("There is no support for creating maps in " + outputFormat + " format", "InvalidFormat");
            e.setCode("InvalidFormat");
            throw e;
        }
        producer.setOutputFormat(outputFormat);
        return producer;
    }

    public String getContentDisposition() {
        return this.headerContentDisposition;
    }

    protected void finalize() throws Throwable {
        this.clearMapContext();
    }

    GetMapProducer getDelegate() {
        return this.delegate;
    }
}

