/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.vfny.geoserver.config.ServiceConfig;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.global.dto.WMSDTO;

public class WMSConfig
extends ServiceConfig {
    private static final String WMS_VERSION = "1.1.1";
    public static final String CONFIG_KEY = "Config.WMS";
    public static final String SVG_SIMPLE = "Simple";
    public static final String SVG_BATIK = "Batik";
    public static final String INT_NEAREST = "Nearest";
    public static final String INT_BIlINEAR = "Bilinear";
    public static final String INT_BICUBIC = "Bicubic";
    private String svgRenderer;
    private boolean svgAntiAlias;
    private boolean globalWatermarking;
    private String globalWatermarkingURL;
    private int watermarkTransparency;
    private int watermarkPosition;
    private Map baseMapLayers;
    private Map baseMapStyles;
    private Map baseMapEnvelopes;
    private String allowInterpolation;
    private Set capabilitiesCrs;
    private int maxBuffer;

    public WMSConfig() {
        this.svgRenderer = SVG_SIMPLE;
        this.svgAntiAlias = true;
        this.globalWatermarking = false;
        this.globalWatermarkingURL = "";
        this.watermarkTransparency = 0;
        this.watermarkPosition = 8;
        this.maxBuffer = 25;
        this.allowInterpolation = INT_NEAREST;
        this.baseMapLayers = new HashMap();
        this.baseMapStyles = new HashMap();
        this.baseMapEnvelopes = new HashMap();
        this.capabilitiesCrs = new HashSet();
    }

    public WMSConfig(WMSDTO w) {
        super(w.getService());
        this.svgRenderer = w.getSvgRenderer();
        this.svgAntiAlias = w.getSvgAntiAlias();
        this.globalWatermarking = w.getGlobalWatermarking();
        this.globalWatermarkingURL = w.getGlobalWatermarkingURL();
        this.watermarkTransparency = w.getWatermarkTransparency();
        this.watermarkPosition = w.getWatermarkPosition();
        this.allowInterpolation = w.getAllowInterpolation();
        this.baseMapLayers = w.getBaseMapLayers();
        this.baseMapStyles = w.getBaseMapStyles();
        this.baseMapEnvelopes = w.getBaseMapEnvelopes();
        this.capabilitiesCrs = w.getCapabilitiesCrs();
        this.maxBuffer = w.getMaxBuffer();
    }

    public WMSConfig(WMS wms) {
        this(wms.toDTO());
    }

    public void update(WMSDTO dto) {
        if (dto == null) {
            throw new NullPointerException("WMS Data Transfer Object required");
        }
        super.update(dto.getService());
        this.svgRenderer = dto.getSvgRenderer();
        this.svgAntiAlias = dto.getSvgAntiAlias();
        this.globalWatermarking = dto.getGlobalWatermarking();
        this.globalWatermarkingURL = dto.getGlobalWatermarkingURL();
        this.watermarkTransparency = dto.getWatermarkTransparency();
        this.watermarkPosition = dto.getWatermarkPosition();
        this.allowInterpolation = dto.getAllowInterpolation();
        this.baseMapLayers = dto.getBaseMapLayers();
        this.baseMapStyles = dto.getBaseMapStyles();
        this.baseMapEnvelopes = dto.getBaseMapEnvelopes();
        this.capabilitiesCrs = dto.getCapabilitiesCrs();
        this.maxBuffer = dto.getMaxBuffer();
    }

    public WMSDTO toDTO() {
        WMSDTO wmsDto = new WMSDTO();
        wmsDto.setService(super.toServDTO());
        wmsDto.setSvgRenderer(this.svgRenderer);
        wmsDto.setSvgAntiAlias(this.svgAntiAlias);
        wmsDto.setGlobalWatermarking(this.globalWatermarking);
        wmsDto.setGlobalWatermarkingURL(this.globalWatermarkingURL);
        wmsDto.setWatermarkTransparency(this.watermarkTransparency);
        wmsDto.setWatermarkPosition(this.watermarkPosition);
        wmsDto.setAllowInterpolation(this.allowInterpolation);
        wmsDto.setBaseMapLayers(this.baseMapLayers);
        wmsDto.setBaseMapStyles(this.baseMapStyles);
        wmsDto.setBaseMapEnvelopes(this.baseMapEnvelopes);
        wmsDto.setCapabilitiesCrs(this.capabilitiesCrs);
        wmsDto.setMaxBuffer(this.maxBuffer);
        return wmsDto;
    }

    public String getSvgRenderer() {
        return this.svgRenderer;
    }

    public void setSvgRenderer(String svgRenderer) {
        this.svgRenderer = svgRenderer;
    }

    public void setSvgAntiAlias(boolean svgAntiAlias) {
        this.svgAntiAlias = svgAntiAlias;
    }

    public boolean getSvgAntiAlias() {
        return this.svgAntiAlias;
    }

    public void setAllowInterpolation(String allowInterpolation) {
        this.allowInterpolation = allowInterpolation;
    }

    public String getAllowInterpolation() {
        return this.allowInterpolation;
    }

    public Map getBaseMapLayers() {
        return this.baseMapLayers;
    }

    public void setBaseMapLayers(Map layers) {
        this.baseMapLayers = layers;
    }

    public Map getBaseMapStyles() {
        return this.baseMapStyles;
    }

    public void setBaseMapStyles(Map styles) {
        this.baseMapStyles = styles;
    }

    public Map getBaseMapEnvelopes() {
        return this.baseMapEnvelopes;
    }

    public void setBaseMapEnvelopes(Map envelopes) {
        this.baseMapEnvelopes = envelopes;
    }

    public boolean getGlobalWatermarking() {
        return this.globalWatermarking;
    }

    public void setGlobalWatermarking(boolean globalWatermarking) {
        this.globalWatermarking = globalWatermarking;
    }

    public String getGlobalWatermarkingURL() {
        return this.globalWatermarkingURL;
    }

    public void setGlobalWatermarkingURL(String globalWatermarkingURL) {
        this.globalWatermarkingURL = globalWatermarkingURL;
    }

    public int getWatermarkTransparency() {
        return this.watermarkTransparency;
    }

    public void setWatermarkTransparency(int watermarkTransparency) {
        this.watermarkTransparency = watermarkTransparency;
    }

    public int getWatermarkPosition() {
        return this.watermarkPosition;
    }

    public void setWatermarkPosition(int watermarkPosition) {
        this.watermarkPosition = watermarkPosition;
    }

    public Set getCapabilitiesCrs() {
        return new TreeSet(this.capabilitiesCrs);
    }

    public void setCapabilitiesCrs(Set crsList) {
        this.capabilitiesCrs = crsList == null ? new TreeSet() : new TreeSet(crsList);
    }
}

