/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Binding;
import org.geotools.xml.Configuration;
import org.geotools.xml.PropertyExtractor;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.BindingFactoryImpl;
import org.geotools.xml.impl.BindingLoader;
import org.geotools.xml.impl.BindingPropertyExtractor;
import org.geotools.xml.impl.BindingWalker;
import org.geotools.xml.impl.BindingWalkerFactoryImpl;
import org.geotools.xml.impl.ElementEncoder;
import org.geotools.xml.impl.GetPropertyExecutor;
import org.geotools.xml.impl.NamespaceSupportWrapper;
import org.geotools.xml.impl.SchemaIndexImpl;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class Encoder {
    public static final QName COMMENT = new QName("http://www.geotools.org", "comment");
    private XSDSchema schema;
    private SchemaIndex index;
    private BindingLoader bindingLoader;
    private MutablePicoContainer context;
    private BindingWalker bindingWalker;
    private List propertyExtractors;
    private ElementEncoder encoder;
    private Document doc;
    private NamespaceSupport namespaces;
    private ContentHandler serializer;
    private HashMap schemaLocations;
    private OutputFormat outputFormat;
    private boolean namespaceAware = true;
    private boolean inline = false;
    private Logger logger;

    public Encoder(Configuration configuration) {
        this(configuration, configuration.schema());
    }

    public Encoder(Configuration configuration, XSDSchema schema) {
        this.schema = schema;
        this.index = new SchemaIndexImpl(new XSDSchema[]{schema});
        this.bindingLoader = new BindingLoader(configuration.setupBindings());
        this.bindingWalker = new BindingWalker(this.bindingLoader);
        this.context = new DefaultPicoContainer();
        BindingFactoryImpl bindingFactory = new BindingFactoryImpl(this.bindingLoader);
        this.context.registerComponentInstance((Object)bindingFactory);
        this.encoder = new ElementEncoder(this.bindingWalker, this.context);
        this.context.registerComponentInstance((Object)this.encoder);
        this.context.registerComponentInstance((Object)this.index);
        this.context.registerComponentInstance((Object)new BindingWalkerFactoryImpl(this.bindingLoader, this.context));
        this.context = configuration.setupContext(this.context);
        this.encoder.setContext(this.context);
        this.schemaLocations = new HashMap();
        this.logger = (Logger)this.context.getComponentInstanceOfType(Logger.class);
        if (this.logger == null) {
            this.logger = Logging.getLogger((String)"org.geotools.xml");
            this.context.registerComponentInstance((Object)this.logger);
        }
        this.encoder.setLogger(this.logger);
        this.namespaces = new NamespaceSupport();
        this.context.registerComponentInstance((Object)this.namespaces);
        this.context.registerComponentInstance((Object)new NamespaceSupportWrapper(this.namespaces));
        this.context.registerComponentInstance((Object)configuration);
        this.propertyExtractors = Schemas.getComponentInstancesOfType((PicoContainer)this.context, PropertyExtractor.class);
        this.propertyExtractors.add(0, new BindingPropertyExtractor(this, this.context));
        this.outputFormat = new OutputFormat();
    }

    public void setEncoding(Charset charset) {
        String charsetName = charset.name();
        this.outputFormat.setEncoding(charsetName);
    }

    public Charset getEncoding() {
        String charsetName = this.outputFormat.getEncoding();
        Charset charset = Charset.forName(charsetName);
        return charset;
    }

    public void setOmitXMLDeclaration(boolean ommitXmlDeclaration) {
        this.outputFormat.setOmitXMLDeclaration(ommitXmlDeclaration);
    }

    public boolean isOmitXMLDeclaration() {
        return this.outputFormat.getOmitXMLDeclaration();
    }

    public void setIndenting(boolean doIndent) {
        this.outputFormat.setIndenting(doIndent);
    }

    public boolean isIndenting() {
        return this.outputFormat.getIndenting();
    }

    public void setIndentSize(int indentSize) {
        if (indentSize < 0) {
            throw new IllegalArgumentException("indentSize shall be >= 0: " + indentSize);
        }
        this.outputFormat.setIndent(indentSize);
    }

    public int getIndentSize() {
        return this.outputFormat.getIndent();
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth < 0) {
            throw new IllegalArgumentException("lineWidth shall be >= 0: " + lineWidth);
        }
        this.outputFormat.setLineWidth(lineWidth);
    }

    public int getLineWidth() {
        return this.outputFormat.getLineWidth();
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }

    public void setEncodeFullDocument(boolean encodeFullDocument) {
        this.inline = !encodeFullDocument;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setSchemaLocation(String namespaceURI, String location) {
        this.schemaLocations.put(namespaceURI, location);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public BindingWalker getBindingWalker() {
        return this.bindingWalker;
    }

    public SchemaIndex getSchemaIndex() {
        return this.index;
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public void write(Object object, QName name, OutputStream out) throws IOException, SAXException {
        this.encode(object, name, out);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void encode(Object object, QName name, OutputStream out) throws IOException {
        if (this.inline) {
            String msg = "Must use 'encode(Object,QName,ContentHandler)' when inline flag is set";
            throw new IllegalStateException(msg);
        }
        XMLSerializer xmls = new XMLSerializer(out, this.outputFormat);
        xmls.setNamespaces(this.namespaceAware);
        try {
            this.encode(object, name, (ContentHandler)xmls);
        }
        catch (SAXException e) {
            if (e.getException() != null && e.getCause() == null) {
                e.initCause(e.getException());
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Object object, QName name, ContentHandler handler) throws IOException, SAXException {
        try {
            QName typeDefintion;
            this.serializer = handler;
            if (!this.inline) {
                this.serializer.startDocument();
            }
            if (this.namespaceAware) {
                Enumeration<String> e = this.namespaces.getPrefixes();
                while (e.hasMoreElements()) {
                    String prefix = e.nextElement();
                    String uri = this.namespaces.getURI(prefix);
                    if ("xml".equals(prefix)) continue;
                    this.serializer.startPrefixMapping(prefix, uri);
                }
                for (Map.Entry entry : this.schema.getQNamePrefixToNamespaceMap().entrySet()) {
                    String pre = (String)entry.getKey();
                    String ns = (String)entry.getValue();
                    if ("http://www.w3.org/2001/XMLSchema".equals(ns)) continue;
                    this.serializer.startPrefixMapping(pre, ns);
                    this.serializer.endPrefixMapping(pre);
                    this.namespaces.declarePrefix(pre != null ? pre : "", ns);
                }
                if (this.namespaces.getURI("") == null) {
                    this.namespaces.declarePrefix("", this.schema.getTargetNamespace());
                }
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                this.doc = docFactory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                new IOException().initCause(e);
            }
            Stack<EncodingEntry> encoded = new Stack<EncodingEntry>();
            XSDElementDeclaration root = this.index.getElementDeclaration(name);
            if (root == null && (typeDefintion = (QName)this.context.getComponentInstance((Object)"http://geotools.org/typeDefinition")) != null) {
                XSDTypeDefinition type = this.index.getTypeDefinition(typeDefintion);
                if (type == null) {
                    throw new NullPointerException();
                }
                root = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                root.setName(name.getLocalPart());
                root.setTargetNamespace(name.getNamespaceURI());
                root.setTypeDefinition(type);
            }
            if (root == null) {
                String msg = "Could not find elmeent declaration for:" + name;
                throw new IllegalArgumentException(msg);
            }
            encoded.add(new EncodingEntry(object, root, null));
            while (!encoded.isEmpty()) {
                EList sub;
                EncodingEntry entry = (EncodingEntry)encoded.peek();
                if (entry.encoding != null) {
                    if (!entry.children.isEmpty()) {
                        Object[] child = (Object[])entry.children.get(0);
                        XSDElementDeclaration element = (XSDElementDeclaration)child[0];
                        Iterator itr = (Iterator)child[1];
                        if (itr.hasNext()) {
                            Object next = itr.next();
                            if (next == null) {
                                this.logger.warning("Iterator returned null for " + element.getName());
                            }
                            encoded.push(new EncodingEntry(next, element, entry));
                            continue;
                        }
                        Object source = child[2];
                        if (source instanceof FeatureCollection && !(itr instanceof SingleIterator)) {
                            ((FeatureCollection)source).close(itr);
                        }
                        entry.children.remove(0);
                        continue;
                    }
                    this.end(entry.encoding);
                    encoded.pop();
                    entry.object = null;
                    entry.element = null;
                    entry.encoding = null;
                    entry.children = null;
                    entry.parent = null;
                    continue;
                }
                if (entry.element.isAbstract() && (sub = entry.element.getSubstitutionGroup()).size() > 0) {
                    ArrayList<Object[]> matches = new ArrayList<Object[]>();
                    for (XSDElementDeclaration e : sub) {
                        if (e.equals(entry.element) || e.getName() == null) continue;
                        Binding binding = this.bindingLoader.loadBinding(new QName(e.getTargetNamespace(), e.getName()), this.context);
                        if (binding == null) {
                            XSDTypeDefinition type = e.getType();
                            if (type.getName() == null) continue;
                            binding = this.bindingLoader.loadBinding(new QName(type.getTargetNamespace(), type.getName()), this.context);
                        }
                        if (binding == null) continue;
                        if (binding.getType() == null) {
                            this.logger.warning("Binding: " + binding.getTarget() + " returns null type.");
                            continue;
                        }
                        if (!binding.getType().isAssignableFrom(entry.object.getClass())) continue;
                        matches.add(new Object[]{e, binding});
                    }
                    if (matches.size() == 1) {
                        entry.element = (XSDElementDeclaration)((Object[])matches.get(0))[0];
                    } else if (matches.size() > 0) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            StringBuffer msg = new StringBuffer("Found multiple non-abstract bindings for ");
                            msg.append(entry.element.getName()).append(": ");
                            Iterator m = matches.iterator();
                            while (m.hasNext()) {
                                msg.append(m.next().getClass().getName());
                                msg.append(", ");
                            }
                            this.logger.fine(msg.toString());
                        }
                        Collections.sort(matches, new Comparator(){

                            public int compare(Object o1, Object o2) {
                                Object[] match1 = (Object[])o1;
                                Object[] match2 = (Object[])o2;
                                Binding b1 = (Binding)match1[1];
                                Binding b2 = (Binding)match2[1];
                                if (b1.getType() != b2.getType()) {
                                    if (b2.getType().isAssignableFrom(b1.getType())) {
                                        return -1;
                                    }
                                    if (b1.getType().isAssignableFrom(b2.getType())) {
                                        return 1;
                                    }
                                }
                                if (b1 instanceof Comparable) {
                                    return ((Comparable)((Object)b1)).compareTo(b2);
                                }
                                if (b2 instanceof Comparable) {
                                    return -1 * ((Comparable)((Object)b2)).compareTo(b1);
                                }
                                return 0;
                            }
                        });
                    }
                    if (matches.size() > 0) {
                        entry.element = (XSDElementDeclaration)((Object[])matches.get(0))[0];
                    }
                }
                if (entry.element.isAbstract()) {
                    this.logger.fine(entry.element.getName() + " is abstract");
                }
                entry.encoding = entry.parent != null ? (Element)this.encode(entry.object, (XSDNamedComponent)entry.element, entry.parent.element.getType()) : (Element)this.encode(entry.object, (XSDNamedComponent)entry.element);
                List attributes = this.index.getAttributes(entry.element);
                for (XSDAttributeDeclaration attribute : attributes) {
                    Attr attr;
                    String local;
                    String ns = attribute.getTargetNamespace();
                    if (entry.encoding.getAttributeNS(ns, local = attribute.getName()) != null && !"".equals(entry.encoding.getAttributeNS(ns, local))) continue;
                    GetPropertyExecutor executor = new GetPropertyExecutor(entry.object, (XSDNamedComponent)attribute);
                    this.bindingWalker.walk((XSDFeature)entry.element, executor, this.context);
                    if (executor.getChildObject() == null || (attr = (Attr)this.encode(executor.getChildObject(), (XSDNamedComponent)attribute)) == null) continue;
                    entry.encoding.setAttributeNodeNS(attr);
                }
                if (this.schemaLocations != null) {
                    if (!this.schemaLocations.isEmpty()) {
                        this.serializer.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                        this.serializer.endPrefixMapping("xsi");
                        this.namespaces.declarePrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                        StringBuffer schemaLocation = new StringBuffer();
                        Iterator e = this.schemaLocations.entrySet().iterator();
                        while (e.hasNext()) {
                            Map.Entry tuple = e.next();
                            String namespaceURI = (String)tuple.getKey();
                            String location = (String)tuple.getValue();
                            schemaLocation.append(namespaceURI + " " + location);
                            if (!e.hasNext()) continue;
                            schemaLocation.append(" ");
                        }
                        entry.encoding.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", schemaLocation.toString());
                    }
                    this.schemaLocations = null;
                }
                this.start(entry.encoding);
                for (PropertyExtractor propertyExtractor : this.propertyExtractors) {
                    if (!propertyExtractor.canHandle(entry.object)) continue;
                    List extracted = propertyExtractor.properties(entry.object, entry.element);
                    block13: for (Object[] tuple : extracted) {
                        XSDParticle cParticle;
                        XSDModelGroup group;
                        XSDParticle particle = (XSDParticle)tuple[0];
                        XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                        if (child != null && COMMENT.getNamespaceURI().equals(child.getTargetNamespace()) && COMMENT.getLocalPart().equals(child.getName())) {
                            this.comment(child.getElement());
                            continue;
                        }
                        if (child.isElementDeclarationReference()) {
                            child = child.getResolvedElementDeclaration();
                        }
                        String ns = child.getTargetNamespace();
                        String local = child.getName();
                        for (int i = 0; i < entry.encoding.getChildNodes().getLength(); ++i) {
                            Node node = entry.encoding.getChildNodes().item(i);
                            if (node instanceof Element && (ns != null ? ns.equals(node.getNamespaceURI()) && local.equals(node.getLocalName()) : local.equals(node.getLocalName()))) continue block13;
                        }
                        Object obj = tuple[1];
                        if (obj == null) {
                            if (particle.getMinOccurs() == 0) continue;
                            this.logger.fine("Property " + ns + ":" + local + " not found but minoccurs > 0 ");
                            continue;
                        }
                        int maxOccurs = 1;
                        if (particle.isSetMaxOccurs()) {
                            maxOccurs = particle.getMaxOccurs();
                        } else if (particle.eContainer() instanceof XSDModelGroup && (group = (XSDModelGroup)particle.eContainer()).eContainer() instanceof XSDParticle && (cParticle = (XSDParticle)group.eContainer()).isSetMaxOccurs()) {
                            maxOccurs = cParticle.getMaxOccurs();
                        }
                        if (maxOccurs == -1 || maxOccurs > 1) {
                            Object collection;
                            Iterator iterator = null;
                            if (obj instanceof Iterator) {
                                iterator = (Iterator<Object>)obj;
                            } else if (obj.getClass().isArray()) {
                                Object[] array = (Object[])obj;
                                iterator = Arrays.asList(array).iterator();
                            } else if (obj instanceof Collection) {
                                collection = (Collection)obj;
                                iterator = collection.iterator();
                            } else if (obj instanceof FeatureCollection) {
                                collection = (FeatureCollection)obj;
                                iterator = collection.iterator();
                            } else {
                                iterator = new SingleIterator(obj);
                            }
                            entry.children.add(new Object[]{child, iterator, obj});
                            continue;
                        }
                        entry.children.add(new Object[]{child, new SingleIterator(obj), obj});
                    }
                }
            }
            if (!this.inline) {
                this.serializer.endDocument();
            }
        }
        finally {
            this.index.destroy();
        }
    }

    public Document encodeAsDOM(Object object, QName name) throws IOException, SAXException, TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(object, name, out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        DOMResult result = new DOMResult();
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.transform(new StreamSource(in), result);
        return (Document)result.getNode();
    }

    protected Node encode(Object object, XSDNamedComponent component) {
        return this.encode(object, component, null);
    }

    protected Node encode(Object object, XSDNamedComponent component, XSDTypeDefinition container) {
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            return this.encoder.encode(object, element, this.doc, container);
        }
        if (component instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)component;
            return this.encoder.encode(object, attribute, this.doc, container);
        }
        return null;
    }

    protected void start(Element element) throws SAXException {
        Node node;
        int i;
        String uri = element.getNamespaceURI();
        String local = element.getLocalName();
        String qName = element.getLocalName();
        NamespaceSupport namespaces = this.namespaces;
        if (this.namespaceAware) {
            uri = uri != null ? uri : namespaces.getURI("");
            qName = namespaces.getPrefix(uri) + ":" + qName;
        } else {
            uri = "";
            namespaces = null;
        }
        DOMAttributes atts = new DOMAttributes(element.getAttributes(), namespaces);
        this.serializer.startElement(uri, local, qName, atts);
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            node = element.getChildNodes().item(i);
            if (!(node instanceof Text)) continue;
            char[] ch = ((Text)node).getData().toCharArray();
            this.serializer.characters(ch, 0, ch.length);
        }
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            node = element.getChildNodes().item(i);
            if (!(node instanceof Element)) continue;
            this.start((Element)node);
            this.end((Element)node);
        }
        this.namespaces.pushContext();
        if (uri != null) {
            this.namespaces.declarePrefix("", uri);
        }
    }

    protected void comment(Element element) throws SAXException, IOException {
        if (this.serializer instanceof XMLSerializer) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node text = children.item(i);
                ((XMLSerializer)this.serializer).comment(text.getNodeValue());
            }
        }
    }

    protected void end(Element element) throws SAXException {
        this.namespaces.popContext();
        String uri = element.getNamespaceURI();
        String local = element.getLocalName();
        String qName = element.getLocalName();
        if (element.getPrefix() != null && !"".equals(element.getPrefix())) {
            qName = element.getPrefix() + ":" + qName;
        }
        this.serializer.endElement(uri, local, qName);
    }

    private static class DOMAttributes
    implements Attributes {
        NamedNodeMap atts;
        NamespaceSupport namespaces;

        public DOMAttributes(NamedNodeMap atts, NamespaceSupport namespaces) {
            this.atts = atts;
            this.namespaces = namespaces;
        }

        public int getLength() {
            return this.atts.getLength();
        }

        public String getLocalName(int index) {
            return this.atts.item(index).getLocalName();
        }

        public String getQName(int index) {
            Node n = this.atts.item(index);
            if (this.namespaces != null) {
                String prefix;
                String uri = n.getNamespaceURI();
                String string = prefix = uri != null ? this.namespaces.getPrefix(uri) : null;
                if (prefix != null) {
                    return prefix + ":" + n.getLocalName();
                }
            }
            return n.getLocalName();
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getURI(int index) {
            return this.atts.item(index).getNamespaceURI();
        }

        public String getValue(int index) {
            return this.atts.item(index).getNodeValue();
        }

        public int getIndex(String qName) {
            String pre = null;
            String local = null;
            if (qName.lastIndexOf(58) != -1) {
                String[] split = qName.split(":");
                pre = split[0];
                local = split[1];
            } else {
                pre = "";
                local = qName;
            }
            for (int i = 0; i < this.atts.getLength(); ++i) {
                Node att = this.atts.item(i);
                if (!att.getLocalName().equals(local)) continue;
                String apre = att.getPrefix();
                if (apre == null) {
                    apre = "";
                }
                if (!pre.equals(apre)) continue;
                return i;
            }
            return -1;
        }

        public String getType(String qName) {
            return this.getType(this.getIndex(qName));
        }

        public String getValue(String qName) {
            return this.getValue(this.getIndex(qName));
        }

        public int getIndex(String uri, String localName) {
            if (uri == null || uri.equals("")) {
                return this.getIndex(localName);
            }
            return this.getIndex(uri + ":" + localName);
        }

        public String getType(String uri, String localName) {
            return this.getType(this.getIndex(uri, localName));
        }

        public String getValue(String uri, String localName) {
            return this.getValue(this.getIndex(uri, localName));
        }
    }

    private static class EncodingEntry {
        public Object object;
        public XSDElementDeclaration element;
        public Element encoding;
        public List children;
        public EncodingEntry parent;

        public EncodingEntry(Object object, XSDElementDeclaration element, EncodingEntry parent) {
            this.object = object;
            this.element = element;
            this.parent = parent;
            this.children = new ArrayList();
        }
    }

    private static class SingleIterator
    implements Iterator {
        Object object;
        boolean more;

        public SingleIterator(Object object) {
            this.object = object;
            this.more = true;
        }

        public void remove() {
        }

        public boolean hasNext() {
            return this.more;
        }

        public Object next() {
            this.more = false;
            return this.object;
        }
    }

    private static class NullIterator
    implements Iterator {
        private NullIterator() {
        }

        public void remove() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    }
}

