/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.javacc;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.javacc.JavaCC;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class JJTree
extends Task {
    private static final String BUILD_NODE_FILES = "BUILD_NODE_FILES";
    private static final String MULTI = "MULTI";
    private static final String NODE_DEFAULT_VOID = "NODE_DEFAULT_VOID";
    private static final String NODE_FACTORY = "NODE_FACTORY";
    private static final String NODE_SCOPE_HOOK = "NODE_SCOPE_HOOK";
    private static final String NODE_USES_PARSER = "NODE_USES_PARSER";
    private static final String STATIC = "STATIC";
    private static final String VISITOR = "VISITOR";
    private static final String NODE_PACKAGE = "NODE_PACKAGE";
    private static final String VISITOR_EXCEPTION = "VISITOR_EXCEPTION";
    private static final String NODE_PREFIX = "NODE_PREFIX";
    private final Hashtable optionalAttrs = new Hashtable();
    private File outputDirectory = null;
    private File target = null;
    private File javaccHome = null;
    private CommandlineJava cmdl = new CommandlineJava();

    public void setBuildnodefiles(boolean buildNodeFiles) {
        this.optionalAttrs.put(BUILD_NODE_FILES, new Boolean(buildNodeFiles));
    }

    public void setMulti(boolean multi) {
        this.optionalAttrs.put(MULTI, new Boolean(multi));
    }

    public void setNodedefaultvoid(boolean nodeDefaultVoid) {
        this.optionalAttrs.put(NODE_DEFAULT_VOID, new Boolean(nodeDefaultVoid));
    }

    public void setNodefactory(boolean nodeFactory) {
        this.optionalAttrs.put(NODE_FACTORY, new Boolean(nodeFactory));
    }

    public void setNodescopehook(boolean nodeScopeHook) {
        this.optionalAttrs.put(NODE_SCOPE_HOOK, new Boolean(nodeScopeHook));
    }

    public void setNodeusesparser(boolean nodeUsesParser) {
        this.optionalAttrs.put(NODE_USES_PARSER, new Boolean(nodeUsesParser));
    }

    public void setStatic(boolean staticParser) {
        this.optionalAttrs.put(STATIC, new Boolean(staticParser));
    }

    public void setVisitor(boolean visitor) {
        this.optionalAttrs.put(VISITOR, new Boolean(visitor));
    }

    public void setNodepackage(String nodePackage) {
        this.optionalAttrs.put(NODE_PACKAGE, new String(nodePackage));
    }

    public void setVisitorException(String visitorException) {
        this.optionalAttrs.put(VISITOR_EXCEPTION, new String(visitorException));
    }

    public void setNodeprefix(String nodePrefix) {
        this.optionalAttrs.put(NODE_PREFIX, new String(nodePrefix));
    }

    public void setOutputdirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void setJavacchome(File javaccHome) {
        this.javaccHome = javaccHome;
    }

    public JJTree() {
        this.cmdl.setVm("java");
        this.cmdl.setClassname("COM.sun.labs.jjtree.Main");
    }

    public void execute() throws BuildException {
        Enumeration iter = this.optionalAttrs.keys();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            Object value = this.optionalAttrs.get(name);
            this.cmdl.createArgument().setValue("-" + name + ":" + value.toString());
        }
        if (this.target == null || !this.target.isFile()) {
            throw new BuildException("Invalid target: " + this.target);
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(this.target.getParent());
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("'outputdirectory' " + this.outputDirectory + " is not a directory.");
        }
        this.cmdl.createArgument().setValue("-OUTPUT_DIRECTORY:" + this.outputDirectory.getAbsolutePath().replace('\\', '/'));
        String targetName = this.target.getName();
        File javaFile = new File(this.outputDirectory, targetName.substring(0, targetName.indexOf(".jjt")) + ".jj");
        if (javaFile.exists() && this.target.lastModified() < javaFile.lastModified()) {
            this.log("Target is already built - skipping (" + this.target + ")", 3);
            return;
        }
        this.cmdl.createArgument().setValue(this.target.getAbsolutePath());
        Path classpath = this.cmdl.createClasspath(this.getProject());
        File javaccJar = JavaCC.getArchiveFile(this.javaccHome);
        classpath.createPathElement().setPath(javaccJar.getAbsolutePath());
        classpath.addJavaRuntime();
        Commandline.Argument arg = this.cmdl.createVmArgument();
        arg.setValue("-mx140M");
        arg.setValue("-Dinstall.root=" + this.javaccHome.getAbsolutePath());
        Execute process = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 2), null);
        this.log(this.cmdl.describeCommand(), 3);
        process.setCommandline(this.cmdl.getCommandline());
        try {
            if (process.execute() != 0) {
                throw new BuildException("JJTree failed.");
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to launch JJTree", (Throwable)e);
        }
    }
}

