/*
 * Decompiled with CFR 0.152.
 */
package simple.util.lease;

import java.util.Hashtable;
import simple.util.MessageQueue;
import simple.util.lease.Cleaner;
import simple.util.lease.Contract;
import simple.util.lease.LeaseException;
import simple.util.lease.LeaseScheduler;
import simple.util.lease.Monitor;

final class Processor
extends Thread {
    private MessageQueue ready;
    private Notifier pending;
    private Hashtable active;
    private Cleaner cleaner;

    public Processor(Cleaner cleaner) {
        this(cleaner, new MessageQueue());
    }

    private Processor(Cleaner cleaner, MessageQueue ready) {
        this.pending = new Notifier(ready);
        this.active = new Hashtable();
        this.cleaner = cleaner;
        this.ready = ready;
        this.start();
    }

    public synchronized void lease(Contract lease) {
        this.active.put(lease, lease);
        this.pending.update(lease);
    }

    public synchronized void update(Contract lease) throws LeaseException {
        if (!this.active.containsKey(lease)) {
            throw new LeaseException("Lease expiry");
        }
        this.active.put(lease, lease);
        this.pending.update(lease);
    }

    public synchronized Contract lookup(String name) throws LeaseException {
        if (!this.active.containsKey(name)) {
            throw new LeaseException("Lease expiry");
        }
        return (Contract)this.active.get(name);
    }

    private synchronized void expire(Contract lease) {
        String name = lease.getName();
        Object value = this.active.get(name);
        if (lease == value) {
            this.active.remove(name);
            this.cleaner.clean(name);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Object top = this.ready.dequeue();
                    this.expire((Contract)top);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private class Notifier
    implements Monitor {
        private LeaseScheduler pending = new LeaseScheduler(this);
        private MessageQueue ready;

        public Notifier(MessageQueue ready) {
            this.ready = ready;
        }

        public void update(Contract lease) {
            this.pending.update(lease);
        }

        public void expire(Contract lease) {
            this.ready.enqueue(lease);
        }
    }
}

