/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.util.HashMap;
import simple.http.ProtocolHandler;
import simple.http.Request;
import simple.http.Response;
import simple.util.Resolver;

public class DomainHandler
implements ProtocolHandler {
    private ProtocolHandler primary;
    private HashMap handlers = new HashMap();
    private Resolver matcher = new Resolver();

    public DomainHandler(ProtocolHandler primary) {
        this.primary = primary;
    }

    public void handle(Request req, Response resp) {
        ProtocolHandler handler = this.primary;
        if (req.getMajor() > 0 && req.getMinor() > 0 && req.contains("Host")) {
            String domain = req.getValue("Host");
            handler = this.lookup(domain);
        }
        handler.handle(req, resp);
    }

    public void insert(ProtocolHandler handler, String pattern) {
        this.handlers.put(pattern, handler);
        this.matcher.insert(pattern, pattern);
    }

    public void remove(String pattern) {
        this.handlers.remove(pattern);
        this.matcher.remove(pattern);
    }

    public boolean contains(String pattern) {
        return this.handlers.containsKey(pattern);
    }

    public ProtocolHandler lookup(String domain) {
        String name = this.matcher.resolve(domain);
        Object handler = this.handlers.get(name);
        if (handler == null) {
            return this.primary;
        }
        return (ProtocolHandler)handler;
    }
}

