/*
 * Decompiled with CFR 0.152.
 */
package simple.http.load;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Hashtable;
import simple.http.load.Layout;
import simple.http.load.Loader;
import simple.http.load.LoaderManager;
import simple.http.load.PlainLayout;
import simple.http.load.Profile;
import simple.util.BlockingQueue;

final class Processor
extends Thread {
    private LoaderManager manager;
    private BlockingQueue queue = new BlockingQueue();
    private Hashtable registry = new Hashtable();

    public Processor(LoaderManager manager) {
        this.manager = manager;
        this.start();
    }

    public synchronized void add(String name, Loader loader) {
        this.registry.put(name, loader);
    }

    public synchronized void remove(String name) {
        this.registry.remove(name);
    }

    public void update(Profile profile) {
        try {
            this.queue.enqueue(new PlainLayout(profile));
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private synchronized void update(Layout layout) {
        Collection values = this.registry.values();
        Object[] list = values.toArray();
        int i = 0;
        while (i < list.length) {
            try {
                Loader next = (Loader)list[i];
                next.update(this.manager, layout);
            }
            catch (RemoteException e) {
                values.remove(list[i]);
            }
            ++i;
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Object top = this.queue.dequeue();
                    this.update((Layout)top);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

