/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import simple.http.Header;
import simple.http.HeaderList;
import simple.http.PlainHeader;
import simple.http.Response;
import simple.util.parse.DateParser;
import simple.util.parse.ListParser;

abstract class ResponseHeader
implements Response {
    private HeaderList list = new HeaderList();
    private DateParser date = new DateParser();
    private String text = "OK";
    private int code = 200;
    private int major = 1;
    private int minor = 1;

    protected ResponseHeader() {
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int headerCount() {
        return this.list.headerCount();
    }

    public String getValue(int off) {
        return this.list.getValue(off);
    }

    public String getName(int off) {
        return this.list.getName(off);
    }

    public int indexOf(String name) {
        return this.list.indexOf(name);
    }

    public int indexOf(String name, int from) {
        return this.list.indexOf(name, from);
    }

    public void add(String name, String val) {
        this.list.add(new PlainHeader(name, val));
    }

    public void set(String name, String val) {
        this.removeAll(name);
        this.add(name, val);
    }

    public void add(String name, int val) {
        this.add(name, String.valueOf(val));
    }

    public void set(String name, int val) {
        this.removeAll(name);
        this.add(name, val);
    }

    public void addDate(String name, long time) {
        this.date.parse(time);
        this.add(name, this.date.toString());
    }

    public void setDate(String name, long time) {
        this.removeAll(name);
        this.addDate(name, time);
    }

    public void remove(int off) {
        this.list.remove(off);
    }

    public void removeAll(String name) {
        this.list.removeAll(name);
    }

    public String getValue(String name) {
        return this.list.getValue(name);
    }

    public String[] getValues(String name) {
        return this.getValues(this.list.getValues(name));
    }

    private String[] getValues(String[] list) {
        return new ListParser(list).list();
    }

    public long getDate(int off) {
        String value = this.getValue(off);
        if (value == null) {
            return -1L;
        }
        this.date.parse(value);
        return this.date.toLong();
    }

    public long getDate(String name) {
        String value = this.getValue(name);
        if (value == null) {
            return -1L;
        }
        this.date.parse(value);
        return this.date.toLong();
    }

    public boolean contains(String name) {
        return this.indexOf(name) != -1;
    }

    public boolean contains(String name, String value) {
        String[] list = this.getValues(name);
        int i = 0;
        while (i < list.length) {
            if (list[i].equalsIgnoreCase(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        while (this.headerCount() > 0) {
            this.remove(0);
        }
    }

    public String toString() {
        int size = this.headerCount() * 50;
        StringBuffer buf = new StringBuffer(size);
        buf.append("HTTP/");
        buf.append(this.major).append(".");
        buf.append(this.minor).append(" ");
        buf.append(this.code).append(" ");
        buf.append(this.text).append("\r\n");
        int i = 0;
        int len = this.headerCount();
        while (i < len) {
            Header head = this.list.get(i);
            buf.append(head.getName());
            buf.append(": ");
            buf.append(head.getValue());
            buf.append("\r\n");
            ++i;
        }
        buf.append("\r\n");
        return buf.toString();
    }
}

