/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineLineAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class LineEndPointCoveredByLineValidation
extends LineLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        FeatureSource fsLine = (FeatureSource)layers.get(this.getLineTypeRef());
        FeatureCollection fcLine = fsLine.getFeatures();
        FeatureIterator fLine = fcLine.features();
        FeatureSource fsRLine = (FeatureSource)layers.get(this.getRestrictedLineTypeRef());
        FeatureCollection fcRLine = fsRLine.getFeatures();
        while (fLine.hasNext()) {
            SimpleFeature line = (SimpleFeature)fLine.next();
            FeatureIterator fRLine = fcRLine.features();
            Geometry lineGeom = (Geometry)line.getDefaultGeometry();
            if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
            if (LineString.class.isAssignableFrom(lineGeom.getClass())) {
                while (fRLine.hasNext()) {
                    SimpleFeature rLine = (SimpleFeature)fRLine.next();
                    Geometry rLineGeom = (Geometry)rLine.getDefaultGeometry();
                    if (envelope.contains(rLineGeom.getEnvelopeInternal())) {
                        if (LineString.class.isAssignableFrom(rLineGeom.getClass())) {
                            Point p1 = ((LineString)rLineGeom).getEndPoint();
                            if (lineGeom.contains(p1)) continue;
                            results.error(rLine, "Line End Point not covered by the specified Line.");
                            r = false;
                            continue;
                        }
                        fcRLine.remove(rLine);
                        results.warning(rLine, "Invalid type: this feature is not a derivative of a LineString");
                        continue;
                    }
                    fcRLine.remove(rLine);
                }
                continue;
            }
            results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
        }
        return r;
    }
}

