/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.net.URI;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.AllHandler;
import org.geotools.xml.handlers.xsi.ChoiceHandler;
import org.geotools.xml.handlers.xsi.ElementGroupingHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.handlers.xsi.SequenceHandler;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.Group;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class GroupHandler
extends ElementGroupingHandler {
    public static final String LOCALNAME = "group";
    private static int offset = 0;
    private String id;
    private String name;
    private String ref = null;
    private int maxOccurs = 1;
    private int minOccurs = 1;
    private ElementGroupingHandler child;
    private int hashCodeOffset = GroupHandler.getOffset();
    private DefaultGroup cache = null;

    private static int getOffset() {
        return offset++;
    }

    public int hashCode() {
        return LOCALNAME.hashCode() * (this.name == null ? 1 : this.name.hashCode()) + this.hashCodeOffset;
    }

    public XSIElementHandler getHandler(String namespaceURI, String localName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(namespaceURI)) {
            if ("all".equalsIgnoreCase(localName)) {
                AllHandler sth = new AllHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("group may only have one child.");
                }
                this.child = sth;
                return sth;
            }
            if ("choice".equalsIgnoreCase(localName)) {
                ChoiceHandler sth = new ChoiceHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("group may only have one child.");
                }
                this.child = sth;
                return sth;
            }
            if ("sequence".equalsIgnoreCase(localName)) {
                SequenceHandler sth = new SequenceHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("group may only have one child.");
                }
                this.child = sth;
                return sth;
            }
        }
        return null;
    }

    public void startElement(String namespaceURI, String localName, Attributes atts) {
        String min;
        String max;
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI, "id");
        }
        if ((max = atts.getValue("", "maxOccurs")) == null) {
            max = atts.getValue(namespaceURI, "maxOccurs");
        }
        if ((min = atts.getValue("", "minOccurs")) == null) {
            min = atts.getValue(namespaceURI, "minOccurs");
        }
        this.name = atts.getValue("", "name");
        if (this.name == null || "".equals(this.name)) {
            this.name = atts.getValue(namespaceURI, "name");
        }
        this.ref = atts.getValue("", "ref");
        if (this.ref == null || "".equals(this.ref)) {
            this.ref = atts.getValue(namespaceURI, "ref");
        }
        if (min != null && !"".equalsIgnoreCase(min)) {
            this.minOccurs = Integer.parseInt(min);
        }
        if (max != null && !"".equalsIgnoreCase(max)) {
            this.maxOccurs = "unbounded".equalsIgnoreCase(max) ? Integer.MAX_VALUE : Integer.parseInt(max);
        }
    }

    public String getLocalName() {
        return LOCALNAME;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementGrouping compress(SchemaHandler parent) throws SAXException {
        Group g;
        GroupHandler groupHandler = this;
        synchronized (groupHandler) {
            if (this.cache != null) {
                return this.cache;
            }
            this.cache = new DefaultGroup();
        }
        this.cache.id = this.id;
        this.cache.name = this.name;
        this.cache.namespace = parent.getTargetNamespace();
        this.cache.min = this.minOccurs;
        this.cache.max = this.maxOccurs;
        ElementGrouping elementGrouping = this.cache.child = this.child == null ? null : this.child.compress(parent);
        if (this.ref != null && (g = parent.lookUpGroup(this.ref)) != null) {
            if (this.id == null || "".equalsIgnoreCase(this.id)) {
                this.id = g.getId();
            }
            this.cache.min = g.getMinOccurs();
            this.cache.max = g.getMaxOccurs();
            this.cache.name = g.getName();
            this.cache.namespace = g.getNamespace();
            this.cache.child = g.getChild() == null ? this.cache.child : g.getChild();
        }
        this.child = null;
        return this.cache;
    }

    public int getHandlerType() {
        return 0;
    }

    public void endElement(String namespaceURI, String localName) {
    }

    protected static class DefaultGroup
    implements Group {
        protected ElementGrouping child;
        protected String id;
        protected int min;
        protected int max;
        protected String name;
        protected URI namespace;

        protected DefaultGroup() {
        }

        public ElementGrouping getChild() {
            return this.child;
        }

        public String getId() {
            return this.id;
        }

        public int getMaxOccurs() {
            return this.max;
        }

        public int getMinOccurs() {
            return this.min;
        }

        public String getName() {
            return this.name;
        }

        public URI getNamespace() {
            return this.namespace;
        }

        public int getGrouping() {
            return 2;
        }

        public Element findChildElement(String arg1) {
            return this.child == null ? null : this.child.findChildElement(arg1);
        }

        public Element findChildElement(String localName, URI namespaceURI) {
            return this.child == null ? null : this.child.findChildElement(localName, namespaceURI);
        }
    }
}

