/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.platform.ExtensionPriority;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerExtensions
implements ApplicationContextAware,
ApplicationListener {
    public static Logger LOGGER = Logging.getLogger((String)"org.geoserver");
    static SoftValueHashMap<Class, String[]> extensionsCache = new SoftValueHashMap(40);
    static ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        GeoServerExtensions.context = context;
        extensionsCache.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T> List<T> extensions(Class<T> extensionPoint, ApplicationContext context) {
        String[] names = GeoServerExtensions.context == context ? (String[])extensionsCache.get(extensionPoint) : null;
        if (names == null) {
            GeoServerExtensions.checkContext(context);
            if (context == null) return Collections.EMPTY_LIST;
            try {
                names = context.getBeanNamesForType(extensionPoint);
                if (GeoServerExtensions.context == context) {
                    extensionsCache.put(extensionPoint, (Object)names);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "bean lookup error", e);
                return Collections.EMPTY_LIST;
            }
        }
        ArrayList<Object> result = new ArrayList<Object>(names.length);
        for (int i = 0; i < names.length; ++i) {
            result.add(context.getBean(names[i]));
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                int p1 = 100;
                if (o1 instanceof ExtensionPriority) {
                    p1 = ((ExtensionPriority)o1).getPriority();
                }
                int p2 = 100;
                if (o2 instanceof ExtensionPriority) {
                    p2 = ((ExtensionPriority)o2).getPriority();
                }
                return p1 - p2;
            }
        });
        return result;
    }

    public static final <T> List<T> extensions(Class<T> extensionPoint) {
        return GeoServerExtensions.extensions(extensionPoint, context);
    }

    public static final Object bean(String name) {
        GeoServerExtensions.checkContext(context);
        return context != null ? context.getBean(name) : null;
    }

    public static final <T> T bean(Class<T> type) throws IllegalArgumentException {
        GeoServerExtensions.checkContext(context);
        return context != null ? (T)GeoServerExtensions.bean(type, context) : null;
    }

    public static final <T> T bean(Class<T> type, ApplicationContext context) throws IllegalArgumentException {
        List<T> beans = GeoServerExtensions.extensions(type, context);
        if (beans.isEmpty()) {
            return null;
        }
        if (beans.size() > 1) {
            throw new IllegalArgumentException("Multiple beans of type " + type.getName());
        }
        return beans.get(0);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            extensionsCache.clear();
        }
    }

    static void checkContext(ApplicationContext context) {
        if (context == null) {
            LOGGER.severe("Extension lookup occured, but ApplicationContext is unset.");
        }
    }

    public static String getProperty(String propertyName, ApplicationContext context) {
        if (context instanceof WebApplicationContext) {
            return GeoServerExtensions.getProperty(propertyName, ((WebApplicationContext)context).getServletContext());
        }
        return GeoServerExtensions.getProperty(propertyName, (ServletContext)null);
    }

    public static String getProperty(String propertyName, ServletContext context) {
        String[] typeStrs = new String[]{"Java environment variable ", "Servlet context parameter ", "System environment variable "};
        String result = null;
        for (int j = 0; j < typeStrs.length; ++j) {
            switch (j) {
                case 0: {
                    result = System.getProperty(propertyName);
                    break;
                }
                case 1: {
                    if (context == null) break;
                    result = context.getInitParameter(propertyName);
                    break;
                }
                case 2: {
                    result = System.getenv(propertyName);
                }
            }
            if (result != null && !result.equalsIgnoreCase("")) break;
            LOGGER.finer("Found " + typeStrs[j] + ": '" + propertyName + "' to be unset");
        }
        return result;
    }
}

