/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.local;

import com.noelios.restlet.local.LocalClientHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.FileRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;
import org.restlet.service.MetadataService;
import org.restlet.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileClientHelper
extends LocalClientHelper {
    public FileClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.FILE);
    }

    @Override
    public void handle(Request request, Response response) {
        String scheme = request.getResourceRef().getScheme();
        request.getResourceRef().normalize();
        if (!scheme.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only FILE is supported.");
        }
        this.handleFile(request, response, request.getResourceRef().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFile(Request request, Response response, String path) {
        String decodedPath = LocalReference.localizePath(Reference.decode(path));
        File file = new File(decodedPath);
        MetadataService metadataService = this.getMetadataService(request);
        if (request.getMethod().equals(Method.GET) || request.getMethod().equals(Method.HEAD)) {
            Variant output = null;
            boolean found = false;
            Iterator<Preference<MediaType>> iterator = request.getClientInfo().getAcceptedMediaTypes().iterator();
            while (iterator.hasNext() && !found) {
                Preference<MediaType> pref = iterator.next();
                found = pref.getMetadata().equals(MediaType.TEXT_URI_LIST);
            }
            if (found) {
                File[] files;
                String baseName = this.getBaseName(file, metadataService);
                if (file.getParentFile() != null && (files = file.getParentFile().listFiles()) != null) {
                    ReferenceList rl = new ReferenceList(files.length);
                    String encodedParentDirectoryURI = path.substring(0, path.lastIndexOf("/"));
                    String encodedFileName = path.substring(path.lastIndexOf("/") + 1);
                    for (File entry : files) {
                        if (!baseName.equals(this.getBaseName(entry, metadataService))) continue;
                        rl.add(LocalReference.createFileReference(encodedParentDirectoryURI + "/" + this.getReencodedVariantFileName(encodedFileName, entry.getName())));
                    }
                    output = rl.getTextRepresentation();
                }
            } else if (file != null && file.exists()) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    ReferenceList rl = new ReferenceList(files.length);
                    rl.setIdentifier(request.getResourceRef());
                    String directoryUri = request.getResourceRef().toString();
                    if (!directoryUri.endsWith("/")) {
                        directoryUri = directoryUri + "/";
                    }
                    for (File entry : files) {
                        rl.add(directoryUri + entry.getName());
                    }
                    output = rl.getTextRepresentation();
                } else {
                    output = new FileRepresentation(file, metadataService.getDefaultMediaType(), this.getTimeToLive());
                    this.updateMetadata(metadataService, file.getName(), output);
                }
            }
            if (output == null) {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            } else {
                output.setIdentifier(request.getResourceRef());
                response.setEntity((Representation)output);
                response.setStatus(Status.SUCCESS_OK);
            }
        } else if (request.getMethod().equals(Method.PUT)) {
            if (!this.checkMetadataConsistency(file.getName(), metadataService, request.getEntity())) {
                response.setStatus(new Status(Status.REDIRECTION_SEE_OTHER, "The metadata are not consistent with the URI"));
            } else {
                boolean isDirectory = false;
                if (file.exists()) {
                    if (file.isDirectory()) {
                        isDirectory = true;
                        response.setStatus(new Status(Status.CLIENT_ERROR_FORBIDDEN, "Can't put a new representation of a directory"));
                    }
                } else if (path.endsWith("/")) {
                    isDirectory = true;
                    if (file.mkdirs()) {
                        response.setStatus(Status.SUCCESS_NO_CONTENT);
                    } else {
                        this.getLogger().log(Level.WARNING, "Unable to create the new directory");
                        response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new directory"));
                    }
                }
                if (!isDirectory) {
                    String baseName = this.getBaseName(file, metadataService);
                    Set<String> extensions = this.getExtensions(file, metadataService);
                    File[] files = file.getParentFile().listFiles();
                    File uniqueVariant = null;
                    ArrayList<File> variantsList = new ArrayList<File>();
                    if (files != null) {
                        for (File entry : files) {
                            Set<String> entryExtensions;
                            if (!entry.getName().startsWith(baseName) || !(entryExtensions = this.getExtensions(entry, metadataService)).containsAll(extensions)) continue;
                            variantsList.add(entry);
                            if (!extensions.containsAll(entryExtensions)) continue;
                            uniqueVariant = entry;
                        }
                    }
                    if (uniqueVariant != null) {
                        file = uniqueVariant;
                    } else if (!variantsList.isEmpty()) {
                        response.setStatus(new Status(Status.CLIENT_ERROR_NOT_ACCEPTABLE, "Unable to process properly the request. Several variants exist but none of them suits precisely."));
                    } else {
                        this.updateMetadata(metadataService, file.getName(), request.getEntity());
                        if (request.getEntity().getLanguages().isEmpty() && metadataService.getDefaultLanguage() != null) {
                            request.getEntity().getLanguages().add(metadataService.getDefaultLanguage());
                        }
                        if (request.getEntity().getMediaType() == null) {
                            request.getEntity().setMediaType(metadataService.getDefaultMediaType());
                        }
                        if (request.getEntity().getEncodings().isEmpty() && metadataService.getDefaultEncoding() != null && !metadataService.getDefaultEncoding().equals(Encoding.IDENTITY)) {
                            request.getEntity().getEncodings().add(metadataService.getDefaultEncoding());
                        }
                        StringBuilder fileName = new StringBuilder(baseName);
                        if (metadataService.getExtension(request.getEntity().getMediaType()) != null) {
                            fileName.append("." + metadataService.getExtension(request.getEntity().getMediaType()));
                        }
                        for (Language language : request.getEntity().getLanguages()) {
                            if (metadataService.getExtension(language) == null) continue;
                            fileName.append("." + metadataService.getExtension(language));
                        }
                        for (Encoding encoding : request.getEntity().getEncodings()) {
                            if (metadataService.getExtension(encoding) == null) continue;
                            fileName.append("." + metadataService.getExtension(encoding));
                        }
                        file = new File(file.getParentFile(), fileName.toString());
                    }
                    if (!this.checkExtensionsConsistency(file, metadataService)) {
                        response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to process properly the URI. At least one extension is not known by the server."));
                    } else {
                        File tmp = null;
                        if (file.exists()) {
                            FileOutputStream fos = null;
                            try {
                                tmp = File.createTempFile("restlet-upload", "bin");
                                if (request.isEntityAvailable()) {
                                    fos = new FileOutputStream(tmp);
                                    ByteUtils.write(request.getEntity().getStream(), fos);
                                }
                            }
                            catch (IOException ioe) {
                                this.getLogger().log(Level.WARNING, "Unable to create the temporary file", ioe);
                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create a temporary file"));
                            }
                            finally {
                                try {
                                    if (fos != null) {
                                        fos.close();
                                    }
                                }
                                catch (IOException ioe) {
                                    this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe);
                                    response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to close a temporary file"));
                                }
                            }
                            if (file.delete()) {
                                boolean renameSuccessfull = false;
                                if (tmp != null && tmp.renameTo(file)) {
                                    if (request.getEntity() == null) {
                                        response.setStatus(Status.SUCCESS_NO_CONTENT);
                                    } else {
                                        response.setStatus(Status.SUCCESS_OK);
                                    }
                                    renameSuccessfull = true;
                                } else {
                                    if (tmp != null && tmp.exists()) {
                                        try {
                                            String s;
                                            BufferedReader br = new BufferedReader(new FileReader(tmp));
                                            BufferedWriter wr = new BufferedWriter(new FileWriter(file));
                                            while ((s = br.readLine()) != null) {
                                                wr.append(s);
                                            }
                                            br.close();
                                            wr.flush();
                                            wr.close();
                                            renameSuccessfull = true;
                                            tmp.delete();
                                        }
                                        catch (Exception e) {
                                            renameSuccessfull = false;
                                        }
                                    }
                                    if (!renameSuccessfull) {
                                        this.getLogger().log(Level.WARNING, "Unable to move the temporary file to replace the existing file");
                                        response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to move the temporary file to replace the existing file"));
                                    }
                                }
                            } else {
                                this.getLogger().log(Level.WARNING, "Unable to delete the existing file");
                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to delete the existing file"));
                            }
                        } else {
                            File parent = file.getParentFile();
                            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                                this.getLogger().log(Level.WARNING, "Unable to create the parent directory");
                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the parent directory"));
                            }
                            FileOutputStream fos = null;
                            try {
                                if (file.createNewFile()) {
                                    if (request.getEntity() == null) {
                                        response.setStatus(Status.SUCCESS_NO_CONTENT);
                                    }
                                    fos = new FileOutputStream(file);
                                    ByteUtils.write(request.getEntity().getStream(), fos);
                                    response.setStatus(Status.SUCCESS_CREATED);
                                }
                                this.getLogger().log(Level.WARNING, "Unable to create the new file");
                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new file"));
                            }
                            catch (FileNotFoundException fnfe) {
                                this.getLogger().log(Level.WARNING, "Unable to create the new file", fnfe);
                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new file"));
                            }
                            catch (IOException ioe) {
                                this.getLogger().log(Level.WARNING, "Unable to create the new file", ioe);
                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new file"));
                            }
                            finally {
                                try {
                                    if (fos != null) {
                                        fos.close();
                                    }
                                }
                                catch (IOException ioe) {
                                    this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe);
                                    response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to close a temporary file"));
                                }
                            }
                        }
                    }
                }
            }
        } else if (request.getMethod().equals(Method.DELETE)) {
            if (file.isDirectory()) {
                if (file.listFiles().length == 0) {
                    if (file.delete()) {
                        response.setStatus(Status.SUCCESS_NO_CONTENT);
                    } else {
                        response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Couldn't delete the directory"));
                    }
                } else {
                    response.setStatus(new Status(Status.CLIENT_ERROR_FORBIDDEN, "Couldn't delete the non-empty directory"));
                }
            } else if (file.delete()) {
                response.setStatus(Status.SUCCESS_NO_CONTENT);
            } else {
                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Couldn't delete the file"));
            }
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
            response.getAllowedMethods().add(Method.PUT);
            response.getAllowedMethods().add(Method.DELETE);
        }
    }

    private String getBaseName(File file, MetadataService metadataService) {
        String[] result = file.getName().split("\\.");
        StringBuilder baseName = new StringBuilder().append(result[0]);
        boolean extensionFound = false;
        for (int i = 1; i < result.length && !extensionFound; ++i) {
            boolean bl = extensionFound = metadataService.getMetadata(result[i]) != null;
            if (extensionFound) continue;
            baseName.append(".").append(result[i]);
        }
        return baseName.toString();
    }

    private Set<String> getExtensions(File file, MetadataService metadataService) {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        String[] tokens = file.getName().split("\\.");
        boolean extensionFound = false;
        for (i = 1; i < tokens.length && !extensionFound; ++i) {
            extensionFound = metadataService.getMetadata(tokens[i]) != null;
        }
        if (extensionFound) {
            --i;
            while (i < tokens.length) {
                result.add(tokens[i]);
                ++i;
            }
        }
        return result;
    }

    private boolean checkMetadataConsistency(String fileName, MetadataService metadataService, Representation representation) {
        boolean result = true;
        if (representation != null) {
            Variant var = new Variant();
            this.updateMetadata(metadataService, fileName, var);
            if (!representation.getLanguages().isEmpty() && !var.getLanguages().containsAll(representation.getLanguages())) {
                result = false;
            }
            if (!(representation.getMediaType() == null || var.getMediaType() != null && var.getMediaType().includes(representation.getMediaType()))) {
                result = false;
            }
            if (!representation.getEncodings().isEmpty() && !var.getEncodings().containsAll(representation.getEncodings())) {
                result = false;
            }
        }
        return result;
    }

    private boolean checkExtensionsConsistency(File file, MetadataService metadataService) {
        boolean knownExtension = true;
        Set<String> set = this.getExtensions(file, metadataService);
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext() && knownExtension) {
            knownExtension = metadataService.getMetadata(iterator.next()) != null;
        }
        return knownExtension;
    }

    private String getReencodedVariantFileName(String encodedFileName, String decodedVariantFileName) {
        int i = 0;
        int j = 0;
        boolean stop = false;
        for (i = 0; i < decodedVariantFileName.length() && j < encodedFileName.length() && !stop; ++i) {
            String decodedChar = decodedVariantFileName.substring(i, i + 1);
            if (decodedChar.equals(encodedFileName.substring(j, j + 1))) {
                ++j;
                continue;
            }
            if (encodedFileName.substring(j, j + 1).equals("%")) {
                if (decodedChar.equals(Reference.decode(encodedFileName.substring(j, j + 3)))) {
                    j += 3;
                    continue;
                }
                stop = true;
                continue;
            }
            if (decodedChar.equals(Reference.decode(encodedFileName.substring(j, j + 1)))) {
                ++j;
                continue;
            }
            stop = true;
        }
        if (stop) {
            return encodedFileName.substring(0, j) + decodedVariantFileName.substring(i - 1);
        }
        if (j == encodedFileName.length()) {
            return encodedFileName.substring(0, j) + decodedVariantFileName.substring(i);
        }
        return encodedFileName.substring(0, j);
    }
}

