/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpServerCall;
import com.noelios.restlet.util.CookieReader;
import com.noelios.restlet.util.HeaderReader;
import com.noelios.restlet.util.PreferenceUtils;
import com.noelios.restlet.util.SecurityUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Tag;
import org.restlet.resource.Representation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends Request {
    private Context context;
    private HttpCall httpCall;
    private boolean clientAdded;
    private boolean conditionAdded;
    private boolean cookiesAdded;
    private boolean entityAdded;
    private boolean referrerAdded;
    private boolean securityAdded;

    public HttpRequest(Context context, HttpServerCall httpCall) {
        this.context = context;
        this.clientAdded = false;
        this.conditionAdded = false;
        this.cookiesAdded = false;
        this.entityAdded = false;
        this.referrerAdded = false;
        this.securityAdded = false;
        this.httpCall = httpCall;
        this.setMethod(Method.valueOf(httpCall.getMethod()));
        if (this.getHttpCall().isConfidential()) {
            this.setConfidential(true);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(httpCall.getProtocol().getSchemeName()).append("://");
        sb.append(httpCall.getHostDomain());
        if (httpCall.getHostPort() != -1 && httpCall.getHostPort() != httpCall.getProtocol().getDefaultPort()) {
            sb.append(':').append(httpCall.getHostPort());
        }
        this.setHostRef(sb.toString());
        this.setResourceRef(new Reference(this.getHostRef(), httpCall.getRequestUri()));
        if (this.getResourceRef().isRelative()) {
            if (!httpCall.getRequestUri().startsWith("/")) {
                this.setResourceRef(new Reference(this.getHostRef(), this.getHostRef().toString() + "/" + httpCall.getRequestUri()));
            } else {
                this.setResourceRef(new Reference(this.getHostRef(), this.getHostRef().toString() + httpCall.getRequestUri()));
            }
        }
    }

    @Override
    public ClientInfo getClientInfo() {
        ClientInfo result = super.getClientInfo();
        if (!this.clientAdded) {
            String header;
            String acceptCharset = this.getHttpCall().getRequestHeaders().getValues("Accept-Charset");
            String acceptEncoding = this.getHttpCall().getRequestHeaders().getValues("Accept-Encoding");
            String acceptLanguage = this.getHttpCall().getRequestHeaders().getValues("Accept-Language");
            String acceptMediaType = this.getHttpCall().getRequestHeaders().getValues("Accept");
            try {
                PreferenceUtils.parseCharacterSets(acceptCharset, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            try {
                PreferenceUtils.parseEncodings(acceptEncoding, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            try {
                PreferenceUtils.parseLanguages(acceptLanguage, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            try {
                PreferenceUtils.parseMediaTypes(acceptMediaType, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            result.setAgent(this.getHttpCall().getRequestHeaders().getValues("User-Agent"));
            result.setAddress(this.getHttpCall().getClientAddress());
            result.setPort(this.getHttpCall().getClientPort());
            boolean useForwardedForHeader = Boolean.parseBoolean(this.context.getParameters().getFirstValue("useForwardedForHeader", false));
            if (useForwardedForHeader && (header = this.getHttpCall().getRequestHeaders().getValues("X-Forwarded-For")) != null) {
                String[] addresses = header.split(",");
                for (int i = addresses.length - 1; i >= 0; --i) {
                    result.getAddresses().add(addresses[i].trim());
                }
            }
            this.clientAdded = true;
        }
        return result;
    }

    @Override
    public Conditions getConditions() {
        Conditions result = super.getConditions();
        if (!this.conditionAdded) {
            String ifMatchHeader = this.getHttpCall().getRequestHeaders().getValues("If-Match");
            String ifNoneMatchHeader = this.getHttpCall().getRequestHeaders().getValues("If-None-Match");
            Date ifModifiedSince = null;
            Date ifUnmodifiedSince = null;
            for (Parameter header : this.getHttpCall().getRequestHeaders()) {
                if (header.getName().equalsIgnoreCase("If-Modified-Since")) {
                    ifModifiedSince = this.getHttpCall().parseDate(header.getValue(), false);
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("If-Unmodified-Since")) continue;
                ifUnmodifiedSince = this.getHttpCall().parseDate(header.getValue(), false);
            }
            if (ifModifiedSince != null && ifModifiedSince.getTime() != -1L) {
                result.setModifiedSince(ifModifiedSince);
            }
            if (ifUnmodifiedSince != null && ifUnmodifiedSince.getTime() != -1L) {
                result.setUnmodifiedSince(ifUnmodifiedSince);
            }
            ArrayList<Tag> match = null;
            Tag current = null;
            if (ifMatchHeader != null) {
                try {
                    HeaderReader hr = new HeaderReader(ifMatchHeader);
                    String value = hr.readValue();
                    while (value != null) {
                        current = Tag.parse(value);
                        if (match == null) {
                            match = new ArrayList<Tag>();
                            result.setMatch(match);
                        }
                        match.add(current);
                        value = hr.readValue();
                    }
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, "Unable to process the if-match header: " + ifMatchHeader);
                }
            }
            ArrayList<Tag> noneMatch = null;
            if (ifNoneMatchHeader != null) {
                try {
                    HeaderReader hr = new HeaderReader(ifNoneMatchHeader);
                    String value = hr.readValue();
                    while (value != null) {
                        current = Tag.parse(value);
                        if (noneMatch == null) {
                            noneMatch = new ArrayList<Tag>();
                            result.setNoneMatch(noneMatch);
                        }
                        noneMatch.add(current);
                        value = hr.readValue();
                    }
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, "Unable to process the if-none-match header: " + ifNoneMatchHeader);
                }
            }
            this.conditionAdded = true;
        }
        return result;
    }

    public HttpCall getHttpCall() {
        return this.httpCall;
    }

    @Override
    public Series<Cookie> getCookies() {
        Series<Cookie> result = super.getCookies();
        if (!this.cookiesAdded) {
            String cookiesValue = this.getHttpCall().getRequestHeaders().getValues("Cookie");
            if (cookiesValue != null) {
                try {
                    CookieReader cr = new CookieReader(this.context.getLogger(), cookiesValue);
                    Cookie current = cr.readCookie();
                    while (current != null) {
                        result.add(current);
                        current = cr.readCookie();
                    }
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.WARNING, "An exception occurred during cookies parsing. Headers value: " + cookiesValue, e);
                }
            }
            this.cookiesAdded = true;
        }
        return result;
    }

    @Override
    public Representation getEntity() {
        if (!this.entityAdded) {
            this.setEntity(((HttpServerCall)this.getHttpCall()).getRequestEntity());
            this.entityAdded = true;
        }
        return super.getEntity();
    }

    @Override
    public Reference getReferrerRef() {
        if (!this.referrerAdded) {
            String referrerValue = this.getHttpCall().getRequestHeaders().getValues("Referer");
            if (referrerValue != null) {
                this.setReferrerRef(new Reference(referrerValue));
            }
            this.referrerAdded = true;
        }
        return super.getReferrerRef();
    }

    @Override
    public ChallengeResponse getChallengeResponse() {
        ChallengeResponse result = super.getChallengeResponse();
        if (!this.securityAdded) {
            String authorization = this.getHttpCall().getRequestHeaders().getValues("Authorization");
            result = SecurityUtils.parseResponse(this, this.context.getLogger(), authorization);
            this.setChallengeResponse(result);
            this.securityAdded = true;
        }
        return result;
    }

    @Override
    public void setChallengeResponse(ChallengeResponse response) {
        super.setChallengeResponse(response);
        this.securityAdded = true;
    }

    @Override
    public void setEntity(Representation entity) {
        super.setEntity(entity);
        this.entityAdded = true;
    }
}

