/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.geotools.data.jdbc.fidmapper.AutoIncrementFIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

public class PostGISAutoIncrementFIDMapper
extends AutoIncrementFIDMapper
implements FIDMapper {
    private static final long serialVersionUID = -6082930630426171079L;
    boolean can_usepg_get_serial_sequence = true;
    boolean hasSerialSequence = true;
    String sequenceName = null;

    public PostGISAutoIncrementFIDMapper(String tableSchemaName, String tableName, String colName, int dataType) {
        super(tableSchemaName, tableName, colName, dataType);
    }

    public PostGISAutoIncrementFIDMapper(String tableName, String colName, int dataType, boolean returnFIDColumnsAsAttributes) {
        super(tableName, colName, dataType);
        this.returnFIDColumnsAsAttributes = returnFIDColumnsAsAttributes;
    }

    public String createID(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
        String id = this.retriveId(conn, feature, statement);
        if (id != null && this.returnFIDColumnsAsAttributes) {
            try {
                feature.setAttribute(this.colNames[0], (Object)id);
            }
            catch (IllegalAttributeException e) {
                throw new IOException("Could not set generated key " + id + " into attribute " + this.colNames[0]);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retriveId(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
        String sql;
        ResultSet rs = null;
        if (this.can_usepg_get_serial_sequence) {
            try {
                sql = "SELECT currval(pg_get_serial_sequence('\"";
                String schema = this.getTableSchemaName();
                if (schema != null && !schema.equals("")) {
                    sql = sql + schema + "\".\"";
                }
                if ((rs = statement.executeQuery(sql = sql + this.getTableName() + "\"','" + this.getColumnName() + "'))")).next() && rs.getString("currval") != null) {
                    String string = rs.getString("currval");
                    return string;
                }
                this.can_usepg_get_serial_sequence = false;
            }
            catch (Exception e) {
                this.can_usepg_get_serial_sequence = false;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        if (this.hasSerialSequence) {
            if (this.sequenceName == null) {
                sql = "SELECT relname FROM pg_catalog.pg_class WHERE relkind = 'S' AND relname LIKE '" + this.getTableName() + "_" + this.getColumnName() + "_seq'";
                try {
                    rs = statement.executeQuery(sql);
                    if (rs.next() && rs.getString(1) != null) {
                        this.sequenceName = rs.getString(1);
                    } else {
                        this.hasSerialSequence = false;
                    }
                }
                catch (Exception e) {
                    this.hasSerialSequence = false;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
            if (this.sequenceName != null) {
                sql = "SELECT currval('\"" + this.sequenceName + "\"')";
                try {
                    rs = statement.executeQuery(sql);
                    if (rs.next() && rs.getString("currval") != null) {
                        String e = rs.getString("currval");
                        return e;
                    }
                    this.hasSerialSequence = false;
                }
                catch (Exception e) {
                    this.hasSerialSequence = false;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        return this.findInsertedFID(conn, feature, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findInsertedFID(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
        String sql = "SELECT \"" + this.getColumnName() + "\" FROM \"";
        String schema = this.getTableSchemaName();
        if (schema != null && !schema.equals("")) {
            sql = sql + schema + "\".\"";
        }
        sql = sql + this.getTableName() + "\" ORDER BY \"" + this.getColumnName() + "\" DESC LIMIT 1;";
        ResultSet rs = null;
        try {
            statement.execute(sql);
            rs = statement.getResultSet();
            rs.next();
            String string = rs.getString(this.getColumnName());
            return string;
        }
        catch (Exception e) {
            String string = super.createID(conn, feature, statement);
            return string;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

