/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.attributeio;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.attributeio.AttributeIO;

public class EWKTAttributeIO
implements AttributeIO {
    WKTReader reader;
    WKTWriter writer;

    private WKTReader getWKTReader() {
        if (this.reader == null) {
            this.reader = new WKTReader();
        }
        return this.reader;
    }

    private WKTWriter getWKTWriter() {
        if (this.writer == null) {
            this.writer = new WKTWriter();
        }
        return this.writer;
    }

    public Object read(ResultSet rs, int position) throws IOException {
        try {
            String wkt = rs.getString(position);
            if (wkt == null || wkt.equals("")) {
                return null;
            }
            int srid = 0;
            int split = wkt.indexOf(";");
            srid = Integer.parseInt(wkt.substring(5, split));
            wkt = wkt.substring(split + 1);
            Geometry geom = this.getWKTReader().read(wkt);
            geom.setSRID(srid);
            return geom;
        }
        catch (SQLException e) {
            throw new DataSourceException("Sql reading problem", e);
        }
        catch (ParseException e) {
            throw new DataSourceException("Could not parse WKT", e);
        }
    }

    public void write(ResultSet rs, int position, Object value) throws IOException {
        try {
            if (value == null) {
                rs.updateNull(position);
            } else {
                Geometry g = (Geometry)value;
                String wkt = this.getWKTWriter().write(g);
                String ewkt = "SRID=" + g.getSRID() + ";" + wkt;
                rs.updateString(position, ewkt);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Sql writing problem", e);
        }
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            if (value == null) {
                ps.setNull(position, 12);
            } else {
                Geometry g = (Geometry)value;
                String wkt = this.getWKTWriter().write(g);
                String ewkt = "SRID=" + g.getSRID() + ";" + wkt;
                ps.setString(position, ewkt);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Sql writing problem", e);
        }
    }
}

