/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCPSFeatureWriter;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PostgisPSFeatureWriter
extends JDBCPSFeatureWriter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    protected static WKTWriter geometryWriter = new WKTWriter();
    private boolean WKBEnabled;
    private boolean byteaWKB;
    private PostgisSQLBuilder sqlBuilder;

    public PostgisPSFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> fReader, QueryData queryData, boolean WKBEnabled, boolean byteaWKB, PostgisSQLBuilder sqlBuilder) throws IOException {
        super(fReader, queryData);
        this.WKBEnabled = WKBEnabled;
        this.byteaWKB = byteaWKB;
        this.sqlBuilder = sqlBuilder;
    }

    @Override
    protected PreparedStatement prepareInsertStatement(Connection conn, StringBuffer statementSQL, SimpleFeatureType featureType) throws SQLException {
        if (this.mapper.hasAutoIncrementColumns()) {
            statementSQL.append(" RETURNING ");
            for (int i = 0; i < this.mapper.getColumnCount(); ++i) {
                if (!this.mapper.isAutoIncrement(i)) continue;
                statementSQL.append(this.mapper.getColumnName(i));
                statementSQL.append(",");
            }
            statementSQL.deleteCharAt(statementSQL.length() - 1);
        }
        return super.prepareInsertStatement(conn, statementSQL, featureType);
    }

    @Override
    protected void executeInsert(PreparedStatement insertStatement) throws IOException {
        if (this.mapper.hasAutoIncrementColumns()) {
            try {
                insertStatement.executeQuery();
            }
            catch (SQLException sqle) {
                String msg = "SQL Exception executing insert statement";
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle);
                throw new DataSourceException(msg, sqle);
            }
        } else {
            super.executeInsert(insertStatement);
        }
    }

    @Override
    protected String getGeometryPlaceHolder(AttributeDescriptor type) {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        int srid = ftInfo.getSRID(type.getLocalName());
        String placeHolder = this.WKBEnabled ? (this.byteaWKB ? "setSRID( ?::geometry," + srid + ")" : "GeomFromWKB( ? , " + srid + ")") : "GeometryFromText( ?, " + srid + ")";
        return placeHolder;
    }

    public boolean isWKBEnabled() {
        return this.WKBEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.WKBEnabled = enabled;
    }

    @Override
    protected String encodeName(String tableName) {
        return this.sqlBuilder.encodeTableName(tableName);
    }

    @Override
    protected String encodeColumnName(String colName) {
        return this.sqlBuilder.encodeColumnName(colName);
    }

    protected String makeSelectForUpdateSql(SimpleFeature current) {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        SimpleFeatureType featureType = ftInfo.getSchema();
        String tableName = featureType.getTypeName();
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        FidFilter fid = ff.createFidFilter(current.getID());
        StringBuffer sql = new StringBuffer("SELECT ");
        this.sqlBuilder.sqlColumns(sql, this.mapper, new AttributeDescriptor[0]);
        this.sqlBuilder.sqlFrom(sql, tableName);
        try {
            this.sqlBuilder.sqlWhere(sql, fid);
        }
        catch (SQLEncoderException e) {
            e.printStackTrace();
        }
        sql.append(" FOR UPDATE");
        try {
            int major = this.queryData.getConnection().getMetaData().getDatabaseMajorVersion();
            int minor = this.queryData.getConnection().getMetaData().getDatabaseMinorVersion();
            if (major > 8 || major == 8 && minor >= 1) {
                sql.append(" NOWAIT");
            } else {
                LOGGER.warning("To fully support concurrent edits, please upgrade to postgres >= 8.1; the version currently in use will block");
            }
        }
        catch (SQLException e) {
            LOGGER.warning("Failed to determine postgres version; assuming < 8.1");
        }
        return sql.toString();
    }
}

