/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.geotools.filter.FilterTransformer;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;
import org.vfny.geoserver.global.dto.CoverageStoreInfoDTO;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObject;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.StyleDTO;
import org.vfny.geoserver.global.dto.WCSDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.NameSpaceElement;
import org.vfny.geoserver.global.xml.NameSpaceTranslator;
import org.vfny.geoserver.global.xml.NameSpaceTranslatorFactory;
import org.vfny.geoserver.global.xml.WriterHelper;

public class XMLConfigWriter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");

    private XMLConfigWriter() {
    }

    public static void store(DataDTO data, File root) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("In method store DataDTO");
        }
        if (data == null) {
            throw new ConfigurationException("DataDTO is null: cannot write.");
        }
        WriterUtils.initFile(root, true);
        File fileDir = root;
        File configDir = WriterUtils.initFile(fileDir, true);
        File catalogFile = WriterUtils.initWriteFile(new File(configDir, "catalog.xml"), false);
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(catalogFile), XMLConfigWriter.getDefaultEncoding());
            XMLConfigWriter.storeCatalog(new WriterHelper(fw), data);
            ((Writer)fw).close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Store" + root, e);
        }
        File dataDir = root;
        File featureTypeDir = WriterUtils.initFile(new File(dataDir, "featureTypes/"), true);
        XMLConfigWriter.storeFeatures(featureTypeDir, data);
        File coverageDir = WriterUtils.initFile(new File(dataDir, "coverages/"), true);
        XMLConfigWriter.storeCoverages(coverageDir, data);
    }

    private static String getDefaultEncoding() {
        return "UTF-8";
    }

    public static void store(WCSDTO wcs, WMSDTO wms, WFSDTO wfs, GeoServerDTO geoServer, File root) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("In method store WCSDTO,WMSDTO,WFSDTO, GeoServerDTO");
        }
        if (geoServer == null) {
            throw new ConfigurationException("null parameter in store(WCSDTO,WMSDTO,WFSDTO, GeoServerDTO): cannot write.");
        }
        WriterUtils.initFile(root, true);
        File fileDir = root;
        File configDir = WriterUtils.initFile(fileDir, true);
        File configFile = WriterUtils.initWriteFile(new File(configDir, "services.xml"), false);
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), XMLConfigWriter.getDefaultEncoding());
            XMLConfigWriter.storeServices(new WriterHelper(fw), wcs, wms, wfs, geoServer);
            ((Writer)fw).close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Store" + root, e);
        }
    }

    public static synchronized void store(WCSDTO wcs, WMSDTO wms, WFSDTO wfs, GeoServerDTO geoServer, DataDTO data, File root) throws ConfigurationException {
        XMLConfigWriter.store(wcs, wms, wfs, geoServer, root);
        XMLConfigWriter.store(data, root);
    }

    protected static void storeServices(WriterHelper cw, WCSDTO wcs, WMSDTO wms, WFSDTO wfs, GeoServerDTO geoServer) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("In method storeServices");
        }
        cw.writeln("<?config.xml version=\"1.0\" encoding=\"UTF-8\"?>");
        cw.comment("Service level configuration");
        cw.openTag("serverConfiguration");
        GeoServerDTO g = geoServer;
        if (g != null) {
            cw.openTag("global");
            if (g.getLog4jConfigFile() != null) {
                cw.textTag("log4jConfigFile", g.getLog4jConfigFile());
            }
            cw.valueTag("suppressStdOutLogging", g.getSuppressStdOutLogging() + "");
            if (g.getLogLocation() != null) {
                cw.textTag("logLocation", g.getLogLocation());
            }
            cw.valueTag("JaiMemoryCapacity", "" + g.getJaiMemoryCapacity());
            cw.valueTag("JaiMemoryThreshold", "" + g.getJaiMemoryThreshold());
            cw.valueTag("JaiTileThreads", "" + g.getJaiTileThreads());
            cw.valueTag("JaiTilePriority", "" + g.getJaiTilePriority());
            cw.valueTag("JaiRecycling", "" + g.getJaiRecycling());
            cw.valueTag("ImageIOCache", "" + g.getImageIOCache());
            cw.valueTag("JaiJPEGNative", "" + g.getJaiJPEGNative());
            cw.valueTag("JaiPNGNative", "" + g.getJaiPNGNative());
            cw.valueTag("JaiMosaicNative", "" + g.getJaiMosaicNative());
            cw.comment("Sets the max number of Features returned by GetFeature");
            cw.valueTag("maxFeatures", "" + g.getMaxFeatures());
            cw.comment("Whether newlines and indents should be returned in \nXML responses.  Default is false");
            cw.valueTag("verbose", "" + g.isVerbose());
            cw.comment("Whether the Service Exceptions returned to clients should contain\nfull java stack traces (useful for debugging). ");
            cw.valueTag("verboseExceptions", "" + g.isVerboseExceptions());
            cw.comment("Sets the max number of decimal places past the zero returned in\na GetFeature response.  Default is 4");
            cw.valueTag("numDecimals", "" + g.getNumDecimals());
            if (g.getCharSet() != null) {
                cw.comment("Sets the global character set.  This could use some more testing\nfrom international users, but what it does is sets the encoding\nglobally for all postgis database connections (the charset tag\nin FeatureTypeConfig), as well as specifying the encoding in the return\nconfig.xml header and mime type.  The default is UTF-8.  Also be warned\nthat GeoServer does not check if the CharSet is valid before\nattempting to use it, so it will fail miserably if a bad charset\nis used.");
                cw.valueTag("charSet", g.getCharSet().toString());
            }
            if (g.getSchemaBaseUrl() != null && g.getSchemaBaseUrl() != "") {
                cw.comment("Define a base url for the location of the wfs schemas.\nBy default GeoServer loads and references its own at\n<URL>/data/capabilities. Uncomment to enable.  The\nstandalone Tomcat server needs SchemaBaseUrl defined\nfor validation.");
                cw.textTag("SchemaBaseUrl", g.getSchemaBaseUrl());
            }
            if (g.getProxyBaseUrl() != null && g.getSchemaBaseUrl() != "") {
                cw.comment("Define a base url for the geoserver application.\nBy default GeoServer uses the local one, but it may be wrong if you're using a reverse proxy in front of Geoserver");
                cw.textTag("ProxyBaseUrl", g.getProxyBaseUrl());
            }
            if (g.getContact() != null) {
                XMLConfigWriter.storeContact(g.getContact(), cw);
            }
            if (g.getTileCache() != null && !"".equals(g.getTileCache().trim())) {
                cw.comment("Defines hte location of a tile cache (full url or relative path)");
                cw.textTag("tileCache", g.getTileCache());
            }
            cw.comment("Stores the current updateSequence");
            cw.textTag("updateSequence", g.getUpdateSequence() + "");
            cw.closeTag("global");
        }
        if (wcs != null || wfs != null || wms != null) {
            cw.openTag("services");
            if (wcs != null) {
                XMLConfigWriter.storeService(wcs, cw);
            }
            if (wfs != null) {
                XMLConfigWriter.storeService(wfs, cw);
            }
            if (wms != null) {
                XMLConfigWriter.storeService(wms, cw);
            }
            cw.closeTag("services");
        }
        cw.closeTag("serverConfiguration");
    }

    protected static void storeContact(ContactDTO c, WriterHelper cw) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("In method storeContact");
        }
        if (c != null && !c.equals(new ContactDTO())) {
            cw.openTag("ContactInformation");
            cw.openTag("ContactPersonPrimary");
            cw.textTag("ContactPerson", c.getContactPerson());
            cw.textTag("ContactOrganization", c.getContactOrganization());
            cw.closeTag("ContactPersonPrimary");
            cw.textTag("ContactPosition", c.getContactPosition());
            cw.openTag("ContactAddress");
            cw.textTag("AddressType", c.getAddressType());
            cw.textTag("Address", c.getAddress());
            cw.textTag("City", c.getAddressCity());
            cw.textTag("StateOrProvince", c.getAddressState());
            cw.textTag("PostCode", c.getAddressPostalCode());
            cw.textTag("Country", c.getAddressCountry());
            cw.closeTag("ContactAddress");
            cw.textTag("ContactVoiceTelephone", c.getContactVoice());
            cw.textTag("ContactFacsimileTelephone", c.getContactFacsimile());
            cw.textTag("ContactElectronicMailAddress", c.getContactEmail());
            cw.textTag("ContactOnlineResource", c.getOnlineResource());
            cw.closeTag("ContactInformation");
        }
    }

    protected static void storeService(Object obj, WriterHelper cw) throws ConfigurationException {
        DataTransferObject w;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("In method storeService");
        }
        ServiceDTO s = null;
        Object u = null;
        String t = "";
        boolean fBounds = false;
        boolean srsXmlStyle = false;
        int serviceLevel = 0;
        String svgRenderer = null;
        Map baseMapLayers = null;
        Map baseMapStyles = null;
        Map baseMapEnvelopes = null;
        boolean svgAntiAlias = false;
        boolean globalWatermarking = false;
        String globalWatermarkingURL = null;
        int watermarkTransparency = 0;
        int watermarkPosition = 8;
        int maxBuffer = 25;
        String allowInterpolation = null;
        boolean citeConformanceHacks = false;
        if (obj instanceof WCSDTO) {
            w = (WCSDTO)obj;
            s = ((WCSDTO)w).getService();
            t = "WCS";
        } else if (obj instanceof WFSDTO) {
            w = (WFSDTO)obj;
            s = ((WFSDTO)w).getService();
            t = "WFS";
            fBounds = ((WFSDTO)w).isFeatureBounding();
            srsXmlStyle = ((WFSDTO)w).isSrsXmlStyle();
            serviceLevel = ((WFSDTO)w).getServiceLevel();
            citeConformanceHacks = ((WFSDTO)w).getCiteConformanceHacks();
        } else if (obj instanceof WMSDTO) {
            w = (WMSDTO)obj;
            s = ((WMSDTO)w).getService();
            t = "WMS";
            svgRenderer = ((WMSDTO)w).getSvgRenderer();
            svgAntiAlias = ((WMSDTO)w).getSvgAntiAlias();
            globalWatermarking = ((WMSDTO)w).getGlobalWatermarking();
            globalWatermarkingURL = ((WMSDTO)w).getGlobalWatermarkingURL();
            watermarkTransparency = ((WMSDTO)w).getWatermarkTransparency();
            watermarkPosition = ((WMSDTO)w).getWatermarkPosition();
            allowInterpolation = ((WMSDTO)w).getAllowInterpolation();
            baseMapLayers = ((WMSDTO)w).getBaseMapLayers();
            baseMapStyles = ((WMSDTO)w).getBaseMapStyles();
            baseMapEnvelopes = ((WMSDTO)w).getBaseMapEnvelopes();
            maxBuffer = ((WMSDTO)w).getMaxBuffer();
        } else {
            throw new ConfigurationException("Invalid object: not WMS or WFS or WCS");
        }
        HashMap<String, String> atrs = new HashMap<String, String>();
        atrs.put("type", t);
        atrs.put("enabled", s.isEnabled() + "");
        cw.openTag("service", atrs);
        cw.comment("ServiceDTO elements, needed for the capabilities document\nTitle and OnlineResource are the two required");
        if (s.getName() != null && s.getName() != "") {
            cw.textTag("name", s.getName());
        }
        if (s.getTitle() != null && s.getTitle() != "") {
            cw.textTag("title", s.getTitle());
        }
        if (s.getAbstract() != null && s.getAbstract() != "") {
            cw.textTag("abstract", s.getAbstract());
        }
        if (s.getMetadataLink() != null) {
            MetaDataLink ml = s.getMetadataLink();
            HashMap<String, String> mlAttr = new HashMap<String, String>();
            mlAttr.put("about", ml.getAbout());
            mlAttr.put("type", ml.getType());
            mlAttr.put("metadataType", ml.getMetadataType());
            cw.textTag("metadataLink", mlAttr, ml.getContent());
        }
        if (!s.getKeywords().isEmpty()) {
            cw.openTag("keywords");
            for (int i = 0; i < s.getKeywords().size(); ++i) {
                String str = s.getKeywords().get(i).toString();
                cw.textTag("keyword", str.replaceAll("\\r", ""));
            }
            cw.closeTag("keywords");
        }
        if (s.getOnlineResource() != null) {
            cw.textTag("onlineResource", s.getOnlineResource().toString());
        }
        if (s.getFees() != null && s.getFees() != "") {
            cw.textTag("fees", s.getFees());
        }
        if (s.getAccessConstraints() != null && s.getAccessConstraints() != "") {
            cw.textTag("accessConstraints", s.getAccessConstraints());
        }
        if (fBounds) {
            cw.valueTag("featureBounding", fBounds + "");
        }
        cw.valueTag("srsXmlStyle", srsXmlStyle + "");
        if (serviceLevel != 0) {
            cw.valueTag("serviceLevel", serviceLevel + "");
        }
        if (obj instanceof WFSDTO) {
            cw.textTag("citeConformanceHacks", citeConformanceHacks + "");
        }
        if (s.getMaintainer() != null && s.getMaintainer() != "") {
            cw.textTag("maintainer", s.getMaintainer());
        }
        if (svgRenderer != null) {
            cw.textTag("svgRenderer", svgRenderer);
        }
        if (baseMapLayers != null && baseMapStyles != null && baseMapEnvelopes != null) {
            cw.openTag("BaseMapGroups");
            String[] titles = baseMapLayers.keySet().toArray(new String[0]);
            for (int i = 0; i < titles.length; ++i) {
                HashMap<String, String> titleMap = new HashMap<String, String>();
                titleMap.put("baseMapTitle", titles[i]);
                cw.openTag("BaseMapGroup", titleMap);
                cw.textTag("baseMapLayers", (String)baseMapLayers.get(titles[i]));
                cw.textTag("baseMapStyles", (String)baseMapStyles.get(titles[i]));
                GeneralEnvelope e = (GeneralEnvelope)baseMapEnvelopes.get(titles[i]);
                HashMap<String, String> m = new HashMap<String, String>();
                try {
                    m.put("srsName", "EPSG:" + CRS.lookupEpsgCode((CoordinateReferenceSystem)e.getCoordinateReferenceSystem(), (boolean)true));
                }
                catch (Exception ex) {
                    m.put("srsName", e.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString());
                }
                if (!e.isNull()) {
                    cw.openTag("baseMapEnvelope", m);
                    cw.textTag("pos", e.getLowerCorner().getOrdinate(0) + " " + e.getLowerCorner().getOrdinate(1));
                    cw.textTag("pos", e.getUpperCorner().getOrdinate(0) + " " + e.getUpperCorner().getOrdinate(1));
                    cw.closeTag("baseMapEnvelope");
                }
                cw.closeTag("BaseMapGroup");
            }
            cw.closeTag("BaseMapGroups");
        }
        if (obj instanceof WMSDTO) {
            Set limitedCrsListForCapabilities = ((WMSDTO)obj).getCapabilitiesCrs();
            StringBuffer sb = new StringBuffer();
            Iterator it = limitedCrsListForCapabilities.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            cw.comment("List of EPSG codes used to limit the number of SRS elements\nshown in the WMS GetCapabilities document");
            cw.textTag("capabilitiesCrsList", sb.toString());
            cw.textTag("svgAntiAlias", svgAntiAlias + "");
            cw.textTag("globalWatermarking", globalWatermarking + "");
            if (globalWatermarkingURL != null) {
                cw.textTag("globalWatermarkingURL", globalWatermarkingURL);
            }
            cw.textTag("globalWatermarkingTransparency", watermarkTransparency + "");
            cw.textTag("globalWatermarkingPosition", watermarkPosition + "");
            cw.textTag("maxBuffer", maxBuffer + "");
            if (allowInterpolation != null) {
                cw.textTag("allowInterpolation", allowInterpolation);
            }
        }
        if (s.getStrategy() != null && !"".equals(s.getStrategy())) {
            cw.textTag("serviceStrategy", s.getStrategy());
        }
        if (s.getPartialBufferSize() != 0) {
            cw.textTag("partialBufferSize", s.getPartialBufferSize() + "");
        }
        cw.closeTag("service");
    }

    protected static void storeCatalog(WriterHelper cw, DataDTO data) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("In method storeCatalog");
        }
        cw.writeln("<?config.xml version=\"1.0\" encoding=\"UTF-8\"?>");
        cw.openTag("catalog");
        cw.openTag("datastores");
        cw.comment("a datastore configuration element serves as a common data source connection\nparameters repository for all featuretypes it holds.");
        for (String s : data.getDataStores().keySet()) {
            DataStoreInfoDTO ds = (DataStoreInfoDTO)data.getDataStores().get(s);
            if (ds == null) continue;
            XMLConfigWriter.storeDataStore(cw, ds);
        }
        cw.closeTag("datastores");
        cw.openTag("formats");
        cw.comment("a format configuration element serves as a common data source\nparameters repository for all coverages it holds.");
        for (String s : data.getFormats().keySet()) {
            CoverageStoreInfoDTO df = (CoverageStoreInfoDTO)data.getFormats().get(s);
            if (df == null) continue;
            XMLConfigWriter.storeFormat(cw, df);
        }
        cw.closeTag("formats");
        cw.comment("Defines namespaces to be used by the datastores.");
        cw.openTag("namespaces");
        for (String s : data.getNameSpaces().keySet()) {
            NameSpaceInfoDTO ns = (NameSpaceInfoDTO)data.getNameSpaces().get(s);
            if (ns == null) continue;
            XMLConfigWriter.storeNameSpace(cw, ns);
        }
        cw.closeTag("namespaces");
        cw.openTag("styles");
        cw.comment("Defines the style ids and file name to be used by the wms.");
        for (String s : data.getStyles().keySet()) {
            StyleDTO st = (StyleDTO)data.getStyles().get(s);
            if (st == null) continue;
            XMLConfigWriter.storeStyle(cw, st);
        }
        cw.closeTag("styles");
        cw.closeTag("catalog");
    }

    protected static void storeDataStore(WriterHelper cw, DataStoreInfoDTO ds) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("In method storeDataStore");
        }
        HashMap<String, String> temp = new HashMap<String, String>();
        if (ds.getId() != null) {
            temp.put("id", ds.getId());
        }
        temp.put("enabled", ds.isEnabled() + "");
        if (ds.getNameSpaceId() != null) {
            temp.put("namespace", ds.getNameSpaceId());
        }
        cw.openTag("datastore", temp);
        if (ds.getAbstract() != null && ds.getAbstract() != "") {
            cw.textTag("abstract", ds.getAbstract());
        }
        if (ds.getTitle() != null && ds.getTitle() != "") {
            cw.textTag("title", ds.getTitle());
        }
        if (ds.getConnectionParams().size() != 0) {
            cw.openTag("connectionParams");
            Iterator i = ds.getConnectionParams().keySet().iterator();
            temp = new HashMap();
            while (i.hasNext()) {
                String key = (String)i.next();
                temp.put("name", key);
                temp.put("value", ds.getConnectionParams().get(key).toString());
                cw.attrTag("parameter", temp);
            }
            cw.closeTag("connectionParams");
        }
        cw.closeTag("datastore");
    }

    protected static void storeFormat(WriterHelper cw, CoverageStoreInfoDTO df) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("In method storeFormat");
        }
        HashMap<String, String> temp = new HashMap<String, String>();
        if (df.getId() != null) {
            temp.put("id", df.getId());
        }
        temp.put("enabled", df.isEnabled() + "");
        if (df.getNameSpaceId() != null) {
            temp.put("namespace", df.getNameSpaceId());
        }
        cw.openTag("format", temp);
        if (df.getAbstract() != null && df.getAbstract() != "") {
            cw.textTag("description", df.getAbstract());
        }
        if (df.getTitle() != null && df.getTitle() != "") {
            cw.textTag("title", df.getTitle());
        }
        if (df.getType() != null && df.getType() != "") {
            cw.textTag("type", df.getType());
        }
        if (df.getUrl() != null && df.getUrl() != "") {
            cw.textTag("url", df.getUrl());
        }
        cw.closeTag("format");
    }

    protected static void storeNameSpace(WriterHelper cw, NameSpaceInfoDTO ns) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("In method storeNameSpace");
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        if (ns.getUri() != null && ns.getUri() != "") {
            attr.put("uri", ns.getUri());
        }
        if (ns.getPrefix() != null && ns.getPrefix() != "") {
            attr.put("prefix", ns.getPrefix());
        }
        if (ns.isDefault()) {
            attr.put("default", "true");
        }
        if (attr.size() != 0) {
            cw.attrTag("namespace", attr);
        }
    }

    protected static void storeStyle(WriterHelper cw, StyleDTO s) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("In method storeStyle: ").append(s).toString());
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        if (s.getId() != null && s.getId() != "") {
            attr.put("id", s.getId());
        }
        if (s.getFilename() != null) {
            attr.put("filename", s.getFilename().getName());
        }
        if (s.isDefault()) {
            attr.put("default", "true");
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("storing style ").append(attr).toString());
        }
        if (attr.size() != 0) {
            cw.attrTag("style", attr);
        }
    }

    protected static void storeFeatures(File dir, DataDTO data) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("In method storeFeatures");
        }
        for (String s : data.getFeaturesTypes().keySet()) {
            FeatureTypeInfoDTO ft = (FeatureTypeInfoDTO)data.getFeaturesTypes().get(s);
            if (ft == null) continue;
            String ftDirName = XMLConfigWriter.featureTypeDirectoryName(ft);
            try {
                ftDirName = URLEncoder.encode(ftDirName, XMLConfigWriter.getDefaultEncoding());
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(new StringBuffer("Writing encoded URL: ").append(ftDirName).toString());
                }
            }
            catch (UnsupportedEncodingException e1) {
                throw new ConfigurationException(e1);
            }
            File dir2 = WriterUtils.initWriteFile(new File(dir, ftDirName), true);
            XMLConfigWriter.storeFeature(ft, dir2);
            if (ft.getSchemaAttributes() == null || !LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.finer(new StringBuffer(ft.getKey()).append(" writing schema.xml w/ ").append(ft.getSchemaAttributes().size()).toString());
        }
        File[] fa = dir.listFiles();
        for (int j = 0; j < fa.length; ++j) {
            if (fa[j].getName().startsWith(".")) continue;
            Iterator<Object> i = data.getFeaturesTypes().values().iterator();
            FeatureTypeInfoDTO fti = null;
            while (fti == null && i.hasNext()) {
                FeatureTypeInfoDTO ft = (FeatureTypeInfoDTO)i.next();
                String ftDirName = XMLConfigWriter.featureTypeDirectoryName(ft);
                try {
                    ftDirName = URLEncoder.encode(ftDirName, XMLConfigWriter.getDefaultEncoding());
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(new StringBuffer("Decoded URL: ").append(ftDirName).toString());
                    }
                }
                catch (UnsupportedEncodingException e1) {
                    throw new ConfigurationException(e1);
                }
                if (!ftDirName.equals(fa[j].getName())) continue;
                fti = ft;
            }
            if (fti != null) continue;
            File[] files = fa[j].listFiles();
            if (files != null) {
                for (int x = 0; x < files.length; ++x) {
                    if (!files[x].getName().equals("info.xml") && !files[x].getName().equals("schema.xml")) continue;
                    try {
                        WriterUtils.backupFile(files[x], true);
                        continue;
                    }
                    catch (IOException e) {
                        LOGGER.severe("Unable to backup: " + files[x].getAbsolutePath());
                    }
                }
            }
            if (fa[j].getName().endsWith(".bak")) continue;
            try {
                WriterUtils.backupDirectory(fa[j]);
                continue;
            }
            catch (IOException e) {
                LOGGER.severe("Unable to backup: " + fa[j].getAbsolutePath());
            }
        }
    }

    static String featureTypeDirectoryName(FeatureTypeInfoDTO ft) {
        String ftDirName = ft.getDirName();
        if (ftDirName == null) {
            ftDirName = ft.getDataStoreId() + "_" + (ft.getAlias() != null ? ft.getAlias() : ft.getName());
        }
        return ftDirName;
    }

    protected static void storeFeature(FeatureTypeInfoDTO ft, File dir) throws ConfigurationException {
        File ftInfo;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("In method storeFeature");
        }
        if ((ftInfo = new File(dir, "info.xml")).exists()) {
            try {
                WriterUtils.backupFile(ftInfo, true);
            }
            catch (IOException e) {
                LOGGER.severe("Unable to backup: " + ftInfo.getAbsolutePath());
            }
        }
        File f = WriterUtils.initWriteFile(ftInfo, false);
        try {
            Envelope e;
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), XMLConfigWriter.getDefaultEncoding());
            WriterHelper cw = new WriterHelper(fw);
            HashMap<String, String> m = new HashMap<String, String>();
            if (ft.getDataStoreId() != null && ft.getDataStoreId() != "") {
                m.put("datastore", ft.getDataStoreId());
            }
            cw.openTag("featureType", m);
            if (ft.getName() != null && ft.getName() != "") {
                cw.textTag("name", ft.getName());
            }
            if (ft.getAlias() != null && !ft.getAlias().equals("")) {
                cw.textTag("alias", ft.getAlias());
            }
            cw.comment("native wich EPGS code for the FeatureTypeInfoDTO");
            cw.textTag("SRS", ft.getSRS() + "");
            cw.textTag("SRSHandling", String.valueOf(ft.getSRSHandling()));
            if (ft.getTitle() != null && ft.getTitle() != "") {
                cw.textTag("title", ft.getTitle());
            }
            if (ft.getAbstract() != null && ft.getAbstract() != "") {
                cw.textTag("abstract", ft.getAbstract());
            }
            if (ft.getWmsPath() != null && ft.getWmsPath() != "") {
                cw.textTag("wmspath", ft.getWmsPath());
            }
            cw.valueTag("numDecimals", ft.getNumDecimals() + "");
            if (ft.getKeywords() != null && ft.getKeywords().size() != 0) {
                String s = "";
                Iterator i = ft.getKeywords().iterator();
                if (i.hasNext()) {
                    s = i.next().toString();
                    while (i.hasNext()) {
                        s = s + ", " + i.next().toString();
                    }
                }
                cw.textTag("keywords", s);
            }
            if (ft.getMetadataLinks() != null && ft.getMetadataLinks().size() != 0) {
                cw.openTag("metadataLinks");
                for (MetaDataLink ml : ft.getMetadataLinks()) {
                    HashMap<String, String> mlAttr = new HashMap<String, String>();
                    mlAttr.put("about", ml.getAbout());
                    mlAttr.put("type", ml.getType());
                    mlAttr.put("metadataType", ml.getMetadataType());
                    cw.textTag("metadataLink", mlAttr, ml.getContent());
                }
                cw.closeTag("metadataLinks");
            }
            if (ft.getLatLongBBox() != null) {
                m = new HashMap();
                e = ft.getLatLongBBox();
                if (!e.isNull()) {
                    m.put("dynamic", "false");
                    m.put("minx", e.getMinX() + "");
                    m.put("miny", e.getMinY() + "");
                    m.put("maxx", e.getMaxX() + "");
                    m.put("maxy", e.getMaxY() + "");
                } else {
                    m.put("dynamic", "true");
                }
                cw.attrTag("latLonBoundingBox", m);
            }
            if (ft.getNativeBBox() != null) {
                m = new HashMap();
                e = ft.getNativeBBox();
                if (!e.isNull()) {
                    m.put("dynamic", "false");
                    m.put("minx", e.getMinX() + "");
                    m.put("miny", e.getMinY() + "");
                    m.put("maxx", e.getMaxX() + "");
                    m.put("maxy", e.getMaxY() + "");
                } else {
                    m.put("dynamic", "true");
                }
                cw.attrTag("nativeBBox", m);
            }
            if (ft.getDefaultStyle() != null && ft.getDefaultStyle() != "") {
                cw.comment("the default style this FeatureTypeInfoDTO can be represented by.\nat least must contain the \"default\" attribute ");
                m = new HashMap();
                m.put("default", ft.getDefaultStyle());
                ArrayList styles = ft.getStyles();
                if (styles.isEmpty()) {
                    cw.attrTag("styles", m);
                } else {
                    cw.openTag("styles", m);
                    Iterator s_IT = styles.iterator();
                    while (s_IT.hasNext()) {
                        cw.textTag("style", (String)s_IT.next());
                    }
                    cw.closeTag("styles");
                }
            }
            m = new HashMap();
            if (ft.getCacheMaxAge() != null) {
                m.put("maxage", ft.getCacheMaxAge());
            }
            if (ft.isCachingEnabled()) {
                m.put("enabled", "true");
            } else {
                m.put("enabled", "false");
            }
            cw.attrTag("cacheinfo", m);
            cw.attrTag("searchable", Collections.singletonMap("enabled", Boolean.toString(ft.isIndexingEnabled())));
            if (ft.getRegionateAttribute() != null) {
                cw.attrTag("regionateAttribute", Collections.singletonMap("value", ft.getRegionateAttribute()));
            }
            if (ft.getRegionateStrategy() != null && ft.getRegionateStrategy() != "best_guess") {
                cw.attrTag("regionateStrategy", Collections.singletonMap("value", ft.getRegionateStrategy()));
            }
            cw.attrTag("regionateFeatureLimit", Collections.singletonMap("value", Integer.toString(ft.getRegionateFeatureLimit())));
            if (ft.getDefinitionQuery() != null) {
                cw.openTag("definitionQuery");
                FilterTransformer ftransformer = new FilterTransformer();
                ftransformer.setOmitXMLDeclaration(true);
                ftransformer.setNamespaceDeclarationEnabled(false);
                String sfilter = ftransformer.transform((Object)ft.getDefinitionQuery());
                cw.writeln(sfilter);
            }
            cw.textTag("maxFeatures", String.valueOf(ft.getMaxFeatures()));
            cw.closeTag("featureType");
            ((Writer)fw).close();
            if (ft.getNameTemplate() != null) {
                PrintWriter ftl = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(dir, "title.ftl"))));
                ftl.println("${" + ft.getNameTemplate() + ".value}");
                ftl.flush();
                ftl.close();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        catch (TransformerException e) {
            throw new ConfigurationException(e);
        }
    }

    protected static void storeFeatureSchema(FeatureTypeInfoDTO fs, File dir) throws ConfigurationException {
        if (fs.getSchemaBase() == null || fs.getSchemaBase() == "") {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer(fs.getKey()).append(" has not schemaBase").toString());
            }
            return;
        }
        if (fs.getSchemaName() == null || fs.getSchemaName() == "") {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer(fs.getKey()).append(" has not schemaName").toString());
            }
            return;
        }
        File ftSchema = new File(dir, "schema.xml");
        if (ftSchema.exists()) {
            try {
                WriterUtils.backupFile(ftSchema, true);
            }
            catch (IOException e) {
                LOGGER.severe("Unable to backup: " + ftSchema.getAbsolutePath());
            }
        }
        File f = WriterUtils.initWriteFile(ftSchema, false);
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), XMLConfigWriter.getDefaultEncoding());
            XMLConfigWriter.storeFeatureSchema(fs, fw);
            ((Writer)fw).close();
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public static void storeFeatureSchema(FeatureTypeInfoDTO fs, Writer w) throws ConfigurationException {
        WriterHelper cw = new WriterHelper(w);
        HashMap<String, String> m = new HashMap<String, String>();
        String t = fs.getSchemaName();
        if (t != null) {
            if (!"_Type".equals(t.substring(t.length() - 5))) {
                t = t + "_Type";
            }
            m.put("name", t);
        }
        cw.openTag("xs:complexType", m);
        cw.openTag("xs:complexContent");
        m = new HashMap();
        t = fs.getSchemaBase();
        if (t != null) {
            m.put("base", t);
        }
        cw.openTag("xs:extension", m);
        cw.openTag("xs:sequence");
        for (int i = 0; i < fs.getSchemaAttributes().size(); ++i) {
            AttributeTypeInfoDTO ati = (AttributeTypeInfoDTO)fs.getSchemaAttributes().get(i);
            m = new HashMap();
            m.put("nillable", "" + ati.isNillable());
            m.put("minOccurs", "" + ati.getMinOccurs());
            m.put("maxOccurs", "" + ati.getMaxOccurs());
            NameSpaceTranslator nst_xs = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
            NameSpaceTranslator nst_gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
            if (!ati.isComplex()) {
                NameSpaceElement nse;
                String r;
                if (ati.getName() == ati.getType()) {
                    r = "";
                    nse = nst_xs.getElement(ati.getType());
                    if (nse == null) {
                        nse = nst_gml.getElement(ati.getType());
                    }
                    r = nse.getQualifiedTypeRefName();
                    m.put("ref", r);
                } else {
                    m.put("name", ati.getName());
                    r = "";
                    nse = nst_xs.getElement(ati.getType());
                    if (nse == null) {
                        nse = nst_gml.getElement(ati.getType());
                        r = nse.getQualifiedTypeDefName();
                    } else {
                        r = nse.getQualifiedTypeRefName();
                    }
                    m.put("type", r);
                }
                cw.attrTag("xs:element", m);
                continue;
            }
            m.put("name", ati.getName());
            cw.openTag("xs:element", m);
            cw.writeln(ati.getType());
            cw.closeTag("xs:element");
        }
        cw.closeTag("xs:sequence");
        cw.closeTag("xs:extension");
        cw.closeTag("xs:complexContent");
        cw.closeTag("xs:complexType");
    }

    protected static void storeCoverages(File dir, DataDTO data) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("In method storeCoverages");
        }
        for (String s : data.getCoverages().keySet()) {
            CoverageInfoDTO cv = (CoverageInfoDTO)data.getCoverages().get(s);
            if (cv == null) continue;
            File dir2 = WriterUtils.initWriteFile(new File(dir, cv.getDirName()), true);
            XMLConfigWriter.storeCoverage(cv, dir2);
        }
        File[] fa = dir.listFiles();
        for (int j = 0; j < fa.length; ++j) {
            if (!fa[j].isDirectory()) continue;
            Iterator<Object> i = data.getCoverages().values().iterator();
            CoverageInfoDTO cvi = null;
            while (cvi == null && i.hasNext()) {
                CoverageInfoDTO cv = (CoverageInfoDTO)i.next();
                if (!cv.getDirName().equals(fa[j].getName())) continue;
                cvi = cv;
            }
            if (cvi != null) continue;
            File[] t = fa[j].listFiles();
            if (t != null) {
                for (int x = 0; x < t.length; ++x) {
                    if (!t[x].getName().equals("info.xml")) continue;
                    t[x].delete();
                }
            }
            if (fa[j].listFiles().length != 0) continue;
            fa[j].delete();
        }
    }

    protected static void storeCoverage(CoverageInfoDTO cv, File dir) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("In method storeCoverage");
        }
        File f = WriterUtils.initWriteFile(new File(dir, "info.xml"), false);
        try {
            String s;
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), XMLConfigWriter.getDefaultEncoding());
            WriterHelper cw = new WriterHelper(fw);
            HashMap<String, Object> m = new HashMap<String, Object>();
            if (cv.getFormatId() != null && cv.getFormatId() != "") {
                m.put("format", cv.getFormatId());
            }
            cw.openTag("coverage", m);
            if (cv.getName() != null && cv.getName() != "") {
                cw.textTag("name", cv.getName());
            }
            if (cv.getLabel() != null && cv.getLabel() != "") {
                cw.textTag("label", cv.getLabel());
            }
            if (cv.getDescription() != null && cv.getDescription() != "") {
                cw.textTag("description", cv.getDescription());
            }
            if (cv.getWmsPath() != null && cv.getWmsPath() != "") {
                cw.textTag("wmspath", cv.getWmsPath());
            }
            m = new HashMap();
            if (cv.getMetadataLink() != null) {
                m.put("about", cv.getMetadataLink().getAbout());
                m.put("type", cv.getMetadataLink().getType());
                m.put("metadataType", cv.getMetadataLink().getMetadataType());
                cw.openTag("metadataLink", m);
                cw.writeln(cv.getMetadataLink().getContent());
                cw.closeTag("metadataLink");
            }
            if (cv.getKeywords() != null && cv.getKeywords().size() != 0) {
                s = "";
                Iterator i = cv.getKeywords().iterator();
                if (i.hasNext()) {
                    s = i.next().toString();
                    while (i.hasNext()) {
                        s = s + "," + i.next().toString();
                    }
                }
                cw.textTag("keywords", s);
            }
            if (cv.getDefaultStyle() != null && cv.getDefaultStyle() != "") {
                cw.comment("the default style this CoverageInfoDTO can be represented by.\nat least must contain the \"default\" attribute ");
                m = new HashMap();
                m.put("default", cv.getDefaultStyle());
                ArrayList styles = cv.getStyles();
                if (styles.isEmpty()) {
                    cw.attrTag("styles", m);
                } else {
                    cw.openTag("styles", m);
                    Iterator s_IT = styles.iterator();
                    while (s_IT.hasNext()) {
                        cw.textTag("style", (String)s_IT.next());
                    }
                    cw.closeTag("styles");
                }
            }
            if (cv.getEnvelope() != null) {
                GeneralEnvelope e = cv.getEnvelope();
                m = new HashMap();
                String userDefinedCrsIdentifier = cv.getUserDefinedCrsIdentifier();
                if (userDefinedCrsIdentifier != null && userDefinedCrsIdentifier != "") {
                    m.put("srsName", userDefinedCrsIdentifier);
                }
                String nativeCrsWkt = cv.getNativeCrsWKT();
                m.put("crs", nativeCrsWkt.replaceAll("\"", "'").replaceAll("\r\n", "\n"));
                if (!e.isNull()) {
                    cw.comment("crs: native CRS definition, srsName: user defined CRS identifier");
                    cw.openTag("envelope", m);
                    cw.textTag("pos", e.getLowerCorner().getOrdinate(0) + " " + e.getLowerCorner().getOrdinate(1));
                    cw.textTag("pos", e.getUpperCorner().getOrdinate(0) + " " + e.getUpperCorner().getOrdinate(1));
                    cw.closeTag("envelope");
                }
            }
            if (cv.getGrid() != null) {
                GridGeometry g = cv.getGrid();
                MathTransform tx = g.getGridToCRS();
                InternationalString[] dimNames = cv.getDimensionNames();
                m = new HashMap();
                m.put("dimension", new Integer(g.getGridRange().getDimension()));
                String lowers = "";
                String upers = "";
                for (int r = 0; r < g.getGridRange().getDimension(); ++r) {
                    lowers = lowers + g.getGridRange().getLower(r) + " ";
                    upers = upers + g.getGridRange().getUpper(r) + " ";
                }
                cw.openTag("grid", m);
                cw.textTag("low", lowers);
                cw.textTag("high", upers);
                if (dimNames != null) {
                    for (int dn = 0; dn < dimNames.length; ++dn) {
                        cw.textTag("axisName", dimNames[dn].toString());
                    }
                }
                if (tx instanceof AffineTransform) {
                    AffineTransform aTX = (AffineTransform)tx;
                    cw.openTag("geoTransform");
                    cw.textTag("scaleX", String.valueOf(aTX.getScaleX()));
                    cw.textTag("scaleY", String.valueOf(aTX.getScaleY()));
                    cw.textTag("shearX", String.valueOf(aTX.getShearX()));
                    cw.textTag("shearY", String.valueOf(aTX.getShearY()));
                    cw.textTag("translateX", String.valueOf(aTX.getTranslateX()));
                    cw.textTag("translateY", String.valueOf(aTX.getTranslateY()));
                    cw.closeTag("geoTransform");
                }
                cw.closeTag("grid");
            }
            if (cv.getDimensions() != null) {
                CoverageDimension[] dims = cv.getDimensions();
                for (int d = 0; d < dims.length; ++d) {
                    Double[] nulls = dims[d].getNullValues();
                    cw.openTag("CoverageDimension");
                    cw.textTag("name", dims[d].getName());
                    cw.textTag("description", dims[d].getDescription());
                    if (dims[d].getRange() != null) {
                        cw.openTag("interval");
                        cw.textTag("min", Double.toString(dims[d].getRange().getMinimum(true)));
                        cw.textTag("max", Double.toString(dims[d].getRange().getMaximum(true)));
                        cw.closeTag("interval");
                    } else {
                        cw.openTag("interval");
                        cw.textTag("min", Double.toString(Double.NEGATIVE_INFINITY));
                        cw.textTag("max", Double.toString(Double.POSITIVE_INFINITY));
                        cw.closeTag("interval");
                    }
                    if (nulls != null) {
                        cw.openTag("nullValues");
                        for (int n = 0; n < nulls.length; ++n) {
                            cw.textTag("value", nulls[n].toString());
                        }
                        cw.closeTag("nullValues");
                    }
                    cw.closeTag("CoverageDimension");
                }
            }
            cw.openTag("supportedCRSs");
            if (cv.getRequestCRSs() != null && cv.getRequestCRSs().size() != 0) {
                s = "";
                Iterator i = cv.getRequestCRSs().iterator();
                if (i.hasNext()) {
                    s = i.next().toString();
                    while (i.hasNext()) {
                        s = s + "," + i.next().toString();
                    }
                }
                cw.textTag("requestCRSs", s);
            }
            if (cv.getResponseCRSs() != null && cv.getResponseCRSs().size() != 0) {
                s = "";
                Iterator i = cv.getResponseCRSs().iterator();
                if (i.hasNext()) {
                    s = i.next().toString();
                    while (i.hasNext()) {
                        s = s + "," + i.next().toString();
                    }
                }
                cw.textTag("responseCRSs", s);
            }
            cw.closeTag("supportedCRSs");
            m = new HashMap();
            if (cv.getNativeFormat() != null && cv.getNativeFormat() != "") {
                m.put("nativeFormat", cv.getNativeFormat());
            }
            cw.openTag("supportedFormats", m);
            if (cv.getSupportedFormats() != null && cv.getSupportedFormats().size() != 0) {
                s = "";
                Iterator i = cv.getSupportedFormats().iterator();
                if (i.hasNext()) {
                    s = i.next().toString();
                    while (i.hasNext()) {
                        s = s + "," + i.next().toString();
                    }
                }
                cw.textTag("formats", s);
            }
            cw.closeTag("supportedFormats");
            m = new HashMap();
            if (cv.getDefaultInterpolationMethod() != null && cv.getDefaultInterpolationMethod() != "") {
                m.put("default", cv.getDefaultInterpolationMethod());
            }
            cw.openTag("supportedInterpolations", m);
            if (cv.getInterpolationMethods() != null && cv.getInterpolationMethods().size() != 0) {
                s = "";
                Iterator i = cv.getInterpolationMethods().iterator();
                if (i.hasNext()) {
                    s = i.next().toString();
                    while (i.hasNext()) {
                        s = s + "," + i.next().toString();
                    }
                }
                cw.textTag("interpolationMethods", s);
            }
            cw.closeTag("supportedInterpolations");
            if (cv.getParameters() != null && cv.getParameters().size() != 0) {
                cw.openTag("parameters");
                Iterator i = cv.getParameters().keySet().iterator();
                HashMap<String, String> temp = new HashMap<String, String>();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (cv.getParameters().get(key) != null) {
                        temp.put("name", key);
                        temp.put("value", cv.getParameters().get(key).toString().replaceAll("\"", "'"));
                    }
                    cw.attrTag("parameter", temp);
                }
                cw.closeTag("parameters");
            }
            cw.closeTag("coverage");
            ((Writer)fw).close();
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public static class WriterUtils {
        private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");

        private WriterUtils() {
        }

        public static File initFile(File f, boolean isDir) throws ConfigurationException {
            if (!f.exists()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(new StringBuffer("Creating File: ").append(f.toString()).toString());
                }
                if (isDir) {
                    if (!f.mkdir()) {
                        throw new ConfigurationException("Path specified does not have a valid file.\n" + f + "\n\n");
                    }
                } else {
                    try {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer(new StringBuffer("Attempting to create file:").append(f.getAbsolutePath()).toString());
                        }
                        if (!f.createNewFile()) {
                            throw new ConfigurationException("Path specified does not have a valid file.\n" + f + "\n\n");
                        }
                    }
                    catch (IOException e) {
                        throw new ConfigurationException(e);
                    }
                }
            }
            if (isDir && !f.isDirectory()) {
                throw new ConfigurationException("Path specified does not have a valid file.\n" + f + "\n\n");
            }
            if (!isDir && !f.isFile()) {
                throw new ConfigurationException("Path specified does not have a valid file.\n" + f + "\n\n");
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer("File is valid: ").append(f).toString());
            }
            return f;
        }

        public static File initWriteFile(File f, boolean isDir) throws ConfigurationException {
            WriterUtils.initFile(f, isDir);
            if (!f.canWrite()) {
                throw new ConfigurationException("Cannot Write to file: " + f.toString());
            }
            return f;
        }

        public static void backupFile(File f, boolean rename) throws IOException {
            File b = new File(f.getAbsolutePath() + ".bak");
            if (b.exists()) {
                WriterUtils.delete(b);
            }
            if (rename) {
                f.renameTo(b);
            } else {
                FileUtils.copyFile((File)f, (File)b);
            }
        }

        public static void backupDirectory(File d) throws IOException {
            File b = new File(d.getAbsolutePath() + ".bak");
            if (b.exists()) {
                if (b.isDirectory()) {
                    WriterUtils.deleteDirectory(b);
                } else {
                    b.delete();
                }
            }
            d.renameTo(b);
        }

        public static void delete(File f) throws IOException {
            if (f.isDirectory()) {
                WriterUtils.deleteDirectory(f);
            } else {
                f.delete();
            }
        }

        public static void deleteDirectory(File d) throws IOException {
            File[] ls = d.listFiles();
            for (int i = 0; i < ls.length; ++i) {
                if (ls[i].isDirectory()) {
                    WriterUtils.deleteDirectory(ls[i]);
                    continue;
                }
                ls[i].delete();
            }
            d.delete();
        }
    }
}

