/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.vfny.geoserver.global.dto.DataTransferObject;
import org.vfny.geoserver.global.dto.ServiceDTO;

public final class WMSDTO
implements DataTransferObject {
    private boolean gmlPrefixing;
    private ServiceDTO service;
    private String svgRenderer;
    private boolean svgAntiAlias;
    private Map baseMapLayers;
    private Map baseMapStyles;
    private Map baseMapEnvelopes;
    private String allowInterpolation;
    private boolean globalWatermarking = false;
    private String globalWatermarkingURL;
    private int watermarkTransparency;
    private int maxBuffer;
    private int watermarkPosition;
    private Set capabilitiesCrs = new TreeSet();

    public WMSDTO() {
    }

    public WMSDTO(WMSDTO other) {
        if (other == null) {
            throw new NullPointerException("Data Transfer Object required");
        }
        this.service = (ServiceDTO)other.getService().clone();
        this.gmlPrefixing = other.isGmlPrefixing();
        this.svgRenderer = other.getSvgRenderer();
        this.svgAntiAlias = other.getSvgAntiAlias();
        this.globalWatermarking = other.getGlobalWatermarking();
        this.globalWatermarkingURL = other.getGlobalWatermarkingURL();
        this.watermarkTransparency = other.getWatermarkTransparency();
        this.watermarkPosition = other.getWatermarkPosition();
        this.allowInterpolation = other.getAllowInterpolation();
        this.baseMapLayers = other.getBaseMapLayers();
        this.baseMapStyles = other.getBaseMapStyles();
        this.baseMapEnvelopes = other.getBaseMapEnvelopes();
        this.capabilitiesCrs = other.getCapabilitiesCrs();
        this.maxBuffer = other.getMaxBuffer();
    }

    public Object clone() {
        return new WMSDTO(this);
    }

    public boolean equals(Object other) {
        boolean equals;
        if (other == null || !(other instanceof WMSDTO)) {
            return false;
        }
        WMSDTO dto = (WMSDTO)other;
        boolean bl = equals = this.gmlPrefixing == dto.gmlPrefixing && this.svgAntiAlias == dto.svgAntiAlias && this.globalWatermarking == dto.getGlobalWatermarking() && this.globalWatermarkingURL == dto.getGlobalWatermarkingURL() && this.watermarkTransparency == dto.getWatermarkTransparency() && this.watermarkPosition == dto.getWatermarkPosition() && this.allowInterpolation == dto.allowInterpolation && this.maxBuffer == dto.maxBuffer;
        if (equals) {
            equals = this.service == null ? dto.getService() == null : this.service.equals(dto.getService());
        }
        if (equals) {
            equals = this.svgRenderer == null ? dto.getSvgRenderer() == null : this.svgRenderer.equals(dto.getSvgRenderer());
        }
        if (equals) {
            equals = this.baseMapLayers == null ? dto.getBaseMapLayers() == null : ((Object)this.baseMapLayers).equals(dto.getBaseMapLayers());
        }
        if (equals) {
            equals = this.baseMapStyles == null ? dto.getBaseMapStyles() == null : ((Object)this.baseMapStyles).equals(dto.getBaseMapStyles());
        }
        if (equals) {
            equals = this.baseMapEnvelopes == null ? dto.getBaseMapEnvelopes() == null : ((Object)this.baseMapEnvelopes).equals(dto.getBaseMapEnvelopes());
        }
        equals = ((Object)this.capabilitiesCrs).equals(dto.getCapabilitiesCrs());
        return equals;
    }

    public int hashCode() {
        return this.gmlPrefixing | this.svgAntiAlias | (this.globalWatermarking ? 1 : 0) | this.watermarkTransparency | this.watermarkPosition | this.maxBuffer | (this.globalWatermarkingURL != null ? 0 : this.globalWatermarkingURL.hashCode()) | (this.allowInterpolation != null ? 0 : this.allowInterpolation.hashCode()) | (this.service == null ? 0 : this.service.hashCode()) | (this.svgRenderer == null ? 0 : this.svgRenderer.hashCode()) | (this.baseMapLayers == null ? 0 : ((Object)this.baseMapLayers).hashCode()) | (this.baseMapStyles == null ? 0 : ((Object)this.baseMapStyles).hashCode()) | (this.baseMapEnvelopes == null ? 0 : ((Object)this.baseMapEnvelopes).hashCode()) | ((Object)this.capabilitiesCrs).hashCode();
    }

    public ServiceDTO getService() {
        return this.service;
    }

    public void setService(ServiceDTO service) {
        if (service == null) {
            throw new NullPointerException("ServiceDTO required");
        }
        this.service = service;
    }

    public boolean isGmlPrefixing() {
        return this.gmlPrefixing;
    }

    public void setGmlPrefixing(boolean b) {
        this.gmlPrefixing = b;
    }

    public String getSvgRenderer() {
        return this.svgRenderer;
    }

    public void setSvgRenderer(String svgRenderer) {
        this.svgRenderer = svgRenderer;
    }

    public void setSvgAntiAlias(boolean svgAntiAlias) {
        this.svgAntiAlias = svgAntiAlias;
    }

    public boolean getSvgAntiAlias() {
        return this.svgAntiAlias;
    }

    public void setBaseMapLayers(Map layers) {
        this.baseMapLayers = layers;
    }

    public Map getBaseMapLayers() {
        return this.baseMapLayers;
    }

    public void setBaseMapStyles(Map styles) {
        this.baseMapStyles = styles;
    }

    public Map getBaseMapStyles() {
        return this.baseMapStyles;
    }

    public void setBaseMapEnvelopes(Map envelopes) {
        this.baseMapEnvelopes = envelopes;
    }

    public Map getBaseMapEnvelopes() {
        return this.baseMapEnvelopes;
    }

    public void setAllowInterpolation(String allowInterpolation) {
        this.allowInterpolation = allowInterpolation;
    }

    public String getAllowInterpolation() {
        return this.allowInterpolation;
    }

    public boolean getGlobalWatermarking() {
        return this.globalWatermarking;
    }

    public void setGlobalWatermarking(boolean globalWatermarking) {
        this.globalWatermarking = globalWatermarking;
    }

    public String getGlobalWatermarkingURL() {
        return this.globalWatermarkingURL;
    }

    public void setGlobalWatermarkingURL(String globalWatermarkingURL) {
        this.globalWatermarkingURL = globalWatermarkingURL;
    }

    public int getWatermarkTransparency() {
        return this.watermarkTransparency;
    }

    public void setWatermarkTransparency(int watermarkTransparency) {
        this.watermarkTransparency = watermarkTransparency;
    }

    public int getWatermarkPosition() {
        return this.watermarkPosition;
    }

    public void setWatermarkPosition(int watermarkPosition) {
        this.watermarkPosition = watermarkPosition;
    }

    public Set getCapabilitiesCrs() {
        return new TreeSet(this.capabilitiesCrs);
    }

    public void setCapabilitiesCrs(Set crsList) {
        if (crsList == null) {
            this.capabilitiesCrs.clear();
        } else {
            this.capabilitiesCrs = new TreeSet(crsList);
        }
    }

    public int getMaxBuffer() {
        return this.maxBuffer;
    }

    public void setMaxBuffer(int maxBuffer) {
        this.maxBuffer = maxBuffer;
    }
}

