/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.xml.NameSpaceElement;
import org.vfny.geoserver.global.xml.NameSpaceTranslator;
import org.vfny.geoserver.global.xml.NameSpaceTranslatorFactory;

public class DataTransferObjectFactory {
    public static Map schemaBaseMap = new HashMap();

    public static AttributeTypeInfoDTO create(String schemaBase, AttributeDescriptor attributeType) {
        AttributeTypeInfoDTO dto = new AttributeTypeInfoDTO();
        dto.setName(attributeType.getLocalName());
        if (DataTransferObjectFactory.isManditory(schemaBase, attributeType.getLocalName()) || attributeType.getMinOccurs() > 0) {
            dto.setMinOccurs(1);
        } else {
            dto.setMinOccurs(0);
        }
        dto.setMaxOccurs(1);
        dto.setNillable(attributeType.isNillable());
        NameSpaceTranslator xs = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        NameSpaceElement element = xs.getElement(attributeType.getType().getBinding(), attributeType.getLocalName());
        if (element == null) {
            element = gml.getElement(attributeType.getType().getBinding(), attributeType.getLocalName());
        }
        if (element == null) {
            element = xs.getElement("string");
        }
        dto.setComplex(false);
        dto.setType(element.getTypeRefName());
        return dto;
    }

    public static AttributeTypeInfoDTO create(String schemaBase, String attributeName) {
        AttributeTypeInfoDTO dto = new AttributeTypeInfoDTO();
        dto.setName(attributeName);
        dto.setMinOccurs(DataTransferObjectFactory.isManditory(schemaBase, attributeName) ? 1 : 0);
        dto.setMaxOccurs(1);
        dto.setNillable(true);
        NameSpaceTranslator xs = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        NameSpaceElement element = xs.getElement(attributeName);
        if (element == null) {
            element = gml.getElement(attributeName);
        }
        if (element == null) {
            element = xs.getElement("string");
        }
        dto.setComplex(false);
        dto.setType(element.getTypeRefName());
        return dto;
    }

    public static FeatureTypeInfoDTO create(String dataStoreId, SimpleFeatureType schema) {
        FeatureTypeInfoDTO dto = new FeatureTypeInfoDTO();
        dto.setAbstract(null);
        dto.setDataStoreId(dataStoreId);
        dto.setDefaultStyle("styles/normal.sld");
        dto.setDefinitionQuery(null);
        dto.setDirName(dataStoreId + "_" + schema.getTypeName());
        dto.setKeywords(Collections.EMPTY_LIST);
        dto.setLatLongBBox(new Envelope());
        dto.setNativeBBox(new Envelope());
        dto.setName(schema.getTypeName());
        dto.setNumDecimals(8);
        dto.setSchemaAttributes(DataTransferObjectFactory.generateAttributes(schema));
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        String schemaBase = gml.getElement("AbstractFeatureType").getQualifiedTypeDefName();
        dto.setSchemaBase(schemaBase);
        dto.setSchemaName(dataStoreId.toUpperCase() + "_" + schema.getTypeName().toUpperCase() + "_TYPE");
        Integer epsgCode = null;
        try {
            CRS.lookupEpsgCode((CoordinateReferenceSystem)schema.getCoordinateReferenceSystem(), (boolean)true);
        }
        catch (FactoryException e) {
            // empty catch block
        }
        if (epsgCode != null) {
            dto.setSRS(epsgCode);
        } else {
            dto.setSRS(0);
        }
        dto.setTitle(schema.getName().getNamespaceURI() + " " + schema.getTypeName());
        return dto;
    }

    public static List generateAttributes(SimpleFeatureType schema) {
        List attributes = schema.getAttributeDescriptors();
        ArrayList<AttributeTypeInfoDTO> list = new ArrayList<AttributeTypeInfoDTO>(attributes.size());
        for (int i = 0; i < attributes.size(); ++i) {
            list.add(DataTransferObjectFactory.create("AbstractFeatureType", (AttributeDescriptor)attributes.get(i)));
        }
        return list;
    }

    public static List generateRequiredAttributes(String schemaBase) {
        String[] attributeNames = DataTransferObjectFactory.getRequiredBaseAttributes(schemaBase);
        ArrayList<AttributeTypeInfoDTO> list = new ArrayList<AttributeTypeInfoDTO>(attributeNames.length);
        for (int i = 0; i < attributeNames.length; ++i) {
            list.add(DataTransferObjectFactory.create(schemaBase, attributeNames[i]));
        }
        return list;
    }

    public static boolean isManditory(String schemaBase, String attribute) {
        String[] required = DataTransferObjectFactory.getRequiredBaseAttributes(schemaBase);
        for (int i = 0; i < required.length; ++i) {
            if (!attribute.equals(required[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] getRequiredBaseAttributes(String schemaBase) {
        if (schemaBaseMap.containsKey(schemaBase)) {
            return (String[])schemaBaseMap.get(schemaBase);
        }
        return new String[0];
    }

    public static List getElements(String name, Class type) {
        NameSpaceElement element2;
        NameSpaceTranslator xs = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
        NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
        LinkedList<NameSpaceElement> result = new LinkedList<NameSpaceElement>();
        if (name == null || name == "") {
            throw new NullPointerException("Element name must be defined.");
        }
        if (type == null) {
            throw new NullPointerException("Element type must be defined.");
        }
        Set s = xs.getAssociatedTypes(type);
        s.addAll(xs.getAssociatedTypes(name));
        s.addAll(gml.getAssociatedTypes(type));
        s.addAll(gml.getAssociatedTypes(name));
        for (NameSpaceElement element2 : s) {
            if (!name.equals(element2.getTypeDefName())) continue;
            if (!result.contains(element2)) {
                result.add(element2);
                continue;
            }
            if (!name.equals(element2.getTypeRefName())) continue;
            if (!result.contains(element2)) {
                result.add(element2);
                continue;
            }
            if (!name.equals(element2.getQualifiedTypeDefName())) continue;
            if (!result.contains(element2)) {
                result.add(element2);
                continue;
            }
            if (!name.equals(element2.getQualifiedTypeRefName()) || result.contains(element2)) continue;
            result.add(element2);
        }
        if (!Object.class.equals((Object)type)) {
            Class cls = type;
            while (!Object.class.equals((Object)cls)) {
                for (NameSpaceElement element3 : s) {
                    if (!element3.getJavaClass().equals(cls) || result.contains(element3)) continue;
                    result.add(element3);
                }
                cls = cls.getSuperclass();
            }
        }
        for (NameSpaceElement element2 : s) {
            if (result.contains(element2)) continue;
            result.add(element2);
        }
        element2 = xs.getElement("string");
        if (!result.contains(element2)) {
            result.add(element2);
        }
        return result;
    }

    private static final NameSpaceElement getBestMatch(String name, Class type) {
        return (NameSpaceElement)DataTransferObjectFactory.getElements(name, type).get(0);
    }

    static {
        schemaBaseMap.put("gml:AbstractFeatureType", new String[0]);
    }
}

